/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff;

import com.netflix.hollow.core.read.dataaccess.HollowCollectionTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.HollowDiffNodeIdentifier;
import java.util.ArrayList;
import java.util.List;

public class HollowDiffRecordFieldExtractor {
    public List<Object> extractValues(HollowDataAccess dataAccess, HollowDiffNodeIdentifier fieldIdentifier, int ordinal) {
        IntList ordinalList = new IntList(1);
        ordinalList.add(ordinal);
        return this.traverse(dataAccess.getTypeDataAccess(this.getType(fieldIdentifier)), ordinalList, fieldIdentifier, 0);
    }

    private List<Object> traverse(HollowTypeDataAccess typeDataAccess, IntList ordinals, HollowDiffNodeIdentifier fieldIdentifier, int level) {
        IntList childOrdinals;
        HollowTypeDataAccess childDataAccess;
        block7: {
            block8: {
                block6: {
                    if (level == fieldIdentifier.getParents().size() - 1) {
                        return this.extractValues(typeDataAccess, ordinals, fieldIdentifier);
                    }
                    childDataAccess = null;
                    childOrdinals = new IntList();
                    if (!(typeDataAccess instanceof HollowObjectTypeDataAccess)) break block6;
                    HollowObjectTypeDataAccess objectAccess = (HollowObjectTypeDataAccess)typeDataAccess;
                    int fieldIdx = objectAccess.getSchema().getPosition(fieldIdentifier.getParents().get(level + 1).getViaFieldName());
                    childDataAccess = typeDataAccess.getDataAccess().getTypeDataAccess(objectAccess.getSchema().getReferencedType(fieldIdx));
                    for (int i = 0; i < ordinals.size(); ++i) {
                        childOrdinals.add(objectAccess.readOrdinal(ordinals.get(i), fieldIdx));
                    }
                    break block7;
                }
                if (!(typeDataAccess instanceof HollowCollectionTypeDataAccess)) break block8;
                HollowCollectionTypeDataAccess collectionAccess = (HollowCollectionTypeDataAccess)typeDataAccess;
                childDataAccess = typeDataAccess.getDataAccess().getTypeDataAccess(collectionAccess.getSchema().getElementType());
                for (int i = 0; i < ordinals.size(); ++i) {
                    HollowOrdinalIterator iter = collectionAccess.ordinalIterator(ordinals.get(i));
                    int childOrdinal = iter.next();
                    while (childOrdinal != Integer.MAX_VALUE) {
                        childOrdinals.add(childOrdinal);
                        childOrdinal = iter.next();
                    }
                }
                break block7;
            }
            if (!(typeDataAccess instanceof HollowMapTypeDataAccess)) break block7;
            HollowMapTypeDataAccess mapAccess = (HollowMapTypeDataAccess)typeDataAccess;
            boolean isValue = fieldIdentifier.getParents().get(level + 1).getViaFieldName().equals("value");
            String childType = isValue ? mapAccess.getSchema().getValueType() : mapAccess.getSchema().getKeyType();
            childDataAccess = typeDataAccess.getDataAccess().getTypeDataAccess(childType);
            for (int i = 0; i < ordinals.size(); ++i) {
                HollowMapEntryOrdinalIterator iter = mapAccess.ordinalIterator(ordinals.get(i));
                while (iter.next()) {
                    childOrdinals.add(isValue ? iter.getValue() : iter.getKey());
                }
            }
        }
        return this.traverse(childDataAccess, childOrdinals, fieldIdentifier, level + 1);
    }

    private List<Object> extractValues(HollowTypeDataAccess typeDataAccess, IntList ordinals, HollowDiffNodeIdentifier fieldIdentifier) {
        ArrayList<Object> values = new ArrayList<Object>();
        HollowObjectTypeDataAccess objectAccess = (HollowObjectTypeDataAccess)typeDataAccess;
        int fieldIdx = objectAccess.getSchema().getPosition(fieldIdentifier.getViaFieldName());
        block10: for (int i = 0; i < ordinals.size(); ++i) {
            switch (objectAccess.getSchema().getFieldType(fieldIdx)) {
                case BOOLEAN: {
                    values.add(objectAccess.readBoolean(ordinals.get(i), fieldIdx));
                    continue block10;
                }
                case BYTES: {
                    values.add(objectAccess.readBytes(ordinals.get(i), fieldIdx));
                    continue block10;
                }
                case DOUBLE: {
                    values.add(objectAccess.readDouble(ordinals.get(i), fieldIdx));
                    continue block10;
                }
                case FLOAT: {
                    values.add(Float.valueOf(objectAccess.readFloat(ordinals.get(i), fieldIdx)));
                    continue block10;
                }
                case INT: {
                    values.add(objectAccess.readInt(ordinals.get(i), fieldIdx));
                    continue block10;
                }
                case LONG: {
                    values.add(objectAccess.readLong(ordinals.get(i), fieldIdx));
                    continue block10;
                }
                case STRING: {
                    values.add(objectAccess.readString(ordinals.get(i), fieldIdx));
                    continue block10;
                }
                case REFERENCE: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return values;
    }

    private final String getType(HollowDiffNodeIdentifier nodeId) {
        return nodeId.getParents().get(0).getNodeName();
    }
}

