/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords;

import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;

public class FlatRecordReader {
    private final FlatRecord record;
    public int pointer;

    public FlatRecordReader(FlatRecord record) {
        this.record = record;
        this.pointer = record.dataStartByte;
    }

    public void reset() {
        this.pointer = this.record.dataStartByte;
    }

    public void resetTo(int position) {
        this.pointer = position;
    }

    public boolean hasMore() {
        return this.pointer < this.record.dataEndByte;
    }

    public HollowSchema readSchema() {
        int schemaId = VarInt.readVInt(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVInt(schemaId);
        return this.record.schemaIdMapper.getSchema(schemaId);
    }

    public int readCollectionSize() {
        int size = VarInt.readVInt(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVInt(size);
        return size;
    }

    public int readOrdinal() {
        if (VarInt.readVNull(this.record.data, (long)this.pointer)) {
            ++this.pointer;
            return -1;
        }
        int value = VarInt.readVInt(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVInt(value);
        return value;
    }

    public Boolean readBoolean() {
        if (VarInt.readVNull(this.record.data, (long)this.pointer)) {
            ++this.pointer;
            return null;
        }
        byte value = this.record.data.get(this.pointer);
        ++this.pointer;
        return value == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public int readInt() {
        if (VarInt.readVNull(this.record.data, (long)this.pointer)) {
            ++this.pointer;
            return Integer.MIN_VALUE;
        }
        int value = VarInt.readVInt(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVInt(value);
        return ZigZag.decodeInt(value);
    }

    public long readLong() {
        if (VarInt.readVNull(this.record.data, (long)this.pointer)) {
            ++this.pointer;
            return Long.MIN_VALUE;
        }
        long value = VarInt.readVLong(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVLong(value);
        return ZigZag.decodeLong(value);
    }

    public float readFloat() {
        int value = this.record.data.readIntBits(this.pointer);
        this.pointer += 4;
        if (value == HollowObjectWriteRecord.NULL_FLOAT_BITS) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(value);
    }

    public double readDouble() {
        long value = this.record.data.readLongBits(this.pointer);
        this.pointer += 8;
        if (value == HollowObjectWriteRecord.NULL_DOUBLE_BITS) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(value);
    }

    public String readString() {
        if (VarInt.readVNull(this.record.data, (long)this.pointer)) {
            ++this.pointer;
            return null;
        }
        int length = VarInt.readVInt(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVInt(length);
        int cLength = VarInt.countVarIntsInRange(this.record.data, this.pointer, length);
        char[] s = new char[cLength];
        for (int i = 0; i < cLength; ++i) {
            int charValue = VarInt.readVInt(this.record.data, (long)this.pointer);
            s[i] = (char)charValue;
            this.pointer += VarInt.sizeOfVInt(charValue);
        }
        return new String(s);
    }

    public byte[] readBytes() {
        if (VarInt.readVNull(this.record.data, (long)this.pointer)) {
            ++this.pointer;
            return null;
        }
        int length = VarInt.readVInt(this.record.data, (long)this.pointer);
        this.pointer += VarInt.sizeOfVInt(length);
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            b[i] = this.record.data.get(this.pointer++);
        }
        return b;
    }

    public void skipSchema(HollowSchema schema) {
        switch (schema.getSchemaType()) {
            case OBJECT: {
                HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
                int numFields = objectSchema.numFields();
                for (int i = 0; i < numFields; ++i) {
                    this.skipField(objectSchema.getFieldType(i));
                }
                break;
            }
            case LIST: 
            case SET: {
                int numElements = this.readCollectionSize();
                for (int i = 0; i < numElements; ++i) {
                    this.readOrdinal();
                }
                break;
            }
            case MAP: {
                int numElements = this.readCollectionSize();
                for (int i = 0; i < numElements; ++i) {
                    this.readOrdinal();
                    this.readOrdinal();
                }
                break;
            }
        }
    }

    public void skipField(HollowObjectSchema.FieldType fieldType) {
        switch (fieldType) {
            case BOOLEAN: {
                this.readBoolean();
                break;
            }
            case BYTES: {
                this.readBytes();
                break;
            }
            case DOUBLE: {
                this.readDouble();
                break;
            }
            case FLOAT: {
                this.readFloat();
                break;
            }
            case INT: {
                this.readInt();
                break;
            }
            case LONG: {
                this.readLong();
                break;
            }
            case REFERENCE: {
                this.readOrdinal();
                break;
            }
            case STRING: {
                this.readString();
            }
        }
    }
}

