/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords;

import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.HollowListWriteRecord;
import com.netflix.hollow.core.write.HollowMapWriteRecord;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowSetWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import java.util.HashMap;
import java.util.Map;

public class FlatRecordDumper {
    private final Map<Integer, Integer> ordinalMapping = new HashMap<Integer, Integer>();
    private final Map<String, HollowWriteRecord> writeRecords = new HashMap<String, HollowWriteRecord>();
    private final HollowWriteStateEngine stateEngine;
    private FlatRecord record;

    public FlatRecordDumper(HollowWriteStateEngine dumpTo) {
        this.stateEngine = dumpTo;
    }

    public void dump(FlatRecord record) {
        this.record = record;
        this.ordinalMapping.clear();
        int currentRecordPointer = record.dataStartByte;
        int currentRecordOrdinal = 0;
        while (currentRecordPointer < record.dataEndByte) {
            int currentSchemaId = VarInt.readVInt(record.data, (long)currentRecordPointer);
            currentRecordPointer += VarInt.sizeOfVInt(currentSchemaId);
            HollowSchema recordSchema = record.schemaIdMapper.getSchema(currentSchemaId);
            HollowSchema engineSchema = this.stateEngine.getSchema(recordSchema.getName());
            currentRecordPointer = this.copyRecord(recordSchema, engineSchema, currentRecordPointer, currentRecordOrdinal++);
        }
    }

    private int copyRecord(HollowSchema recordSchema, HollowSchema engineSchema, int currentRecordPointer, int currentRecordOrdinal) {
        switch (recordSchema.getSchemaType()) {
            case OBJECT: {
                return this.copyObjectRecord((HollowObjectSchema)recordSchema, (HollowObjectSchema)engineSchema, currentRecordPointer, currentRecordOrdinal);
            }
            case LIST: {
                return this.copyListRecord((HollowListSchema)engineSchema, currentRecordPointer, currentRecordOrdinal);
            }
            case SET: {
                return this.copySetRecord((HollowSetSchema)engineSchema, currentRecordPointer, currentRecordOrdinal);
            }
            case MAP: {
                return this.copyMapRecord((HollowMapSchema)engineSchema, currentRecordPointer, currentRecordOrdinal);
            }
        }
        throw new IllegalStateException("Unknown schema type: " + (Object)((Object)recordSchema.getSchemaType()));
    }

    private int copyListRecord(HollowListSchema engineSchema, int currentRecordPointer, int currentRecordOrdinal) {
        HollowListWriteRecord rec = engineSchema != null ? (HollowListWriteRecord)this.getWriteRecord(engineSchema) : null;
        int numElements = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
        currentRecordPointer += VarInt.sizeOfVInt(numElements);
        for (int i = 0; i < numElements; ++i) {
            int unmappedElementOrdinal = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
            currentRecordPointer += VarInt.sizeOfVInt(unmappedElementOrdinal);
            if (rec == null) continue;
            int mappedElementOrdinal = this.ordinalMapping.get(unmappedElementOrdinal);
            rec.addElement(mappedElementOrdinal);
        }
        if (engineSchema != null) {
            int stateEngineOrdinal = this.stateEngine.add(engineSchema.getName(), rec);
            this.ordinalMapping.put(currentRecordOrdinal, stateEngineOrdinal);
        }
        return currentRecordPointer;
    }

    private int copySetRecord(HollowSetSchema engineSchema, int currentRecordPointer, int currentRecordOrdinal) {
        HollowSetWriteRecord rec = engineSchema != null ? (HollowSetWriteRecord)this.getWriteRecord(engineSchema) : null;
        int numElements = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
        currentRecordPointer += VarInt.sizeOfVInt(numElements);
        int unmappedOrdinal = 0;
        for (int i = 0; i < numElements; ++i) {
            int unmappedOrdinalDelta = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
            currentRecordPointer += VarInt.sizeOfVInt(unmappedOrdinalDelta);
            unmappedOrdinal += unmappedOrdinalDelta;
            if (rec == null) continue;
            int mappedOrdinal = this.ordinalMapping.get(unmappedOrdinal);
            rec.addElement(mappedOrdinal);
        }
        if (engineSchema != null) {
            int stateEngineOrdinal = this.stateEngine.add(engineSchema.getName(), rec);
            this.ordinalMapping.put(currentRecordOrdinal, stateEngineOrdinal);
        }
        return currentRecordPointer;
    }

    private int copyMapRecord(HollowMapSchema engineSchema, int currentRecordPointer, int currentRecordOrdinal) {
        HollowMapWriteRecord rec = engineSchema != null ? (HollowMapWriteRecord)this.getWriteRecord(engineSchema) : null;
        int numElements = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
        currentRecordPointer += VarInt.sizeOfVInt(numElements);
        int unmappedKeyOrdinal = 0;
        for (int i = 0; i < numElements; ++i) {
            int unmappedKeyOrdinalDelta = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
            int unmappedValueOrdinal = VarInt.readVInt(this.record.data, (long)(currentRecordPointer += VarInt.sizeOfVInt(unmappedKeyOrdinalDelta)));
            currentRecordPointer += VarInt.sizeOfVInt(unmappedValueOrdinal);
            unmappedKeyOrdinal += unmappedKeyOrdinalDelta;
            if (rec == null) continue;
            int mappedKeyOrdinal = this.ordinalMapping.get(unmappedKeyOrdinal);
            int mappedValueOrdinal = this.ordinalMapping.get(unmappedValueOrdinal);
            rec.addEntry(mappedKeyOrdinal, mappedValueOrdinal);
        }
        if (engineSchema != null) {
            int stateEngineOrdinal = this.stateEngine.add(engineSchema.getName(), rec);
            this.ordinalMapping.put(currentRecordOrdinal, stateEngineOrdinal);
        }
        return currentRecordPointer;
    }

    private int copyObjectRecord(HollowObjectSchema recordSchema, HollowObjectSchema engineSchema, int currentRecordPointer, int currentRecordOrdinal) {
        HollowObjectWriteRecord rec = engineSchema != null ? (HollowObjectWriteRecord)this.getWriteRecord(engineSchema) : null;
        for (int i = 0; i < recordSchema.numFields(); ++i) {
            String fieldName = recordSchema.getFieldName(i);
            HollowObjectSchema.FieldType fieldType = recordSchema.getFieldType(i);
            boolean fieldExistsInEngine = engineSchema != null && engineSchema.getPosition(fieldName) != -1;
            currentRecordPointer = this.copyObjectField(fieldExistsInEngine ? rec : null, fieldName, fieldType, currentRecordPointer);
        }
        if (engineSchema != null) {
            int stateEngineOrdinal = this.stateEngine.add(engineSchema.getName(), rec);
            this.ordinalMapping.put(currentRecordOrdinal, stateEngineOrdinal);
        }
        return currentRecordPointer;
    }

    private int copyObjectField(HollowObjectWriteRecord rec, String fieldName, HollowObjectSchema.FieldType fieldType, int currentRecordPointer) {
        switch (fieldType) {
            case BOOLEAN: {
                if (!VarInt.readVNull(this.record.data, (long)currentRecordPointer)) {
                    boolean value;
                    boolean bl = value = this.record.data.get(currentRecordPointer) == 1;
                    if (rec != null) {
                        rec.setBoolean(fieldName, value);
                    }
                }
                return currentRecordPointer + 1;
            }
            case INT: {
                if (VarInt.readVNull(this.record.data, (long)currentRecordPointer)) {
                    return currentRecordPointer + 1;
                }
                int ivalue = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
                currentRecordPointer += VarInt.sizeOfVInt(ivalue);
                if (rec != null) {
                    rec.setInt(fieldName, ZigZag.decodeInt(ivalue));
                }
                return currentRecordPointer;
            }
            case LONG: {
                if (VarInt.readVNull(this.record.data, (long)currentRecordPointer)) {
                    return currentRecordPointer + 1;
                }
                long lvalue = VarInt.readVLong(this.record.data, (long)currentRecordPointer);
                currentRecordPointer += VarInt.sizeOfVLong(lvalue);
                if (rec != null) {
                    rec.setLong(fieldName, ZigZag.decodeLong(lvalue));
                }
                return currentRecordPointer;
            }
            case FLOAT: {
                int intBits = this.record.data.readIntBits(currentRecordPointer);
                if (intBits != HollowObjectWriteRecord.NULL_FLOAT_BITS) {
                    float fvalue = Float.intBitsToFloat(intBits);
                    if (rec != null) {
                        rec.setFloat(fieldName, fvalue);
                    }
                }
                return currentRecordPointer + 4;
            }
            case DOUBLE: {
                long longBits = this.record.data.readLongBits(currentRecordPointer);
                if (longBits != HollowObjectWriteRecord.NULL_DOUBLE_BITS) {
                    double dvalue = Double.longBitsToDouble(longBits);
                    if (rec != null) {
                        rec.setDouble(fieldName, dvalue);
                    }
                }
                return currentRecordPointer + 8;
            }
            case STRING: {
                if (VarInt.readVNull(this.record.data, (long)currentRecordPointer)) {
                    return currentRecordPointer + 1;
                }
                int length = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
                int cLength = VarInt.countVarIntsInRange(this.record.data, currentRecordPointer += VarInt.sizeOfVInt(length), length);
                char[] s = new char[cLength];
                for (int i = 0; i < cLength; ++i) {
                    int charValue = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
                    s[i] = (char)charValue;
                    currentRecordPointer += VarInt.sizeOfVInt(charValue);
                }
                if (rec != null) {
                    rec.setString(fieldName, new String(s));
                }
                return currentRecordPointer;
            }
            case BYTES: {
                if (VarInt.readVNull(this.record.data, (long)currentRecordPointer)) {
                    return currentRecordPointer + 1;
                }
                int length = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
                currentRecordPointer += VarInt.sizeOfVInt(length);
                byte[] b = new byte[length];
                for (int i = 0; i < length; ++i) {
                    b[i] = this.record.data.get(currentRecordPointer++);
                }
                if (rec != null) {
                    rec.setBytes(fieldName, b);
                }
                return currentRecordPointer;
            }
            case REFERENCE: {
                if (VarInt.readVNull(this.record.data, (long)currentRecordPointer)) {
                    return currentRecordPointer + 1;
                }
                int unmappedOrdinal = VarInt.readVInt(this.record.data, (long)currentRecordPointer);
                if (rec != null) {
                    int mappedOrdinal = this.ordinalMapping.get(unmappedOrdinal);
                    rec.setReference(fieldName, mappedOrdinal);
                }
                return currentRecordPointer + VarInt.sizeOfVInt(unmappedOrdinal);
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + (Object)((Object)fieldType));
    }

    private HollowWriteRecord getWriteRecord(HollowSchema schema) {
        HollowWriteRecord rec = this.writeRecords.get(schema.getName());
        if (rec == null) {
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    rec = new HollowObjectWriteRecord((HollowObjectSchema)schema);
                    break;
                }
                case LIST: {
                    rec = new HollowListWriteRecord();
                    break;
                }
                case SET: {
                    rec = new HollowSetWriteRecord();
                    break;
                }
                case MAP: {
                    rec = new HollowMapWriteRecord();
                }
            }
            this.writeRecords.put(schema.getName(), rec);
        }
        rec.reset();
        return rec;
    }
}

