/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.generic.GenericHollowList;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.write.HollowListTypeWriteState;
import com.netflix.hollow.core.write.HollowListWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import com.netflix.hollow.core.write.objectmapper.MemoizedList;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalListNode;
import com.netflix.hollow.core.write.objectmapper.flatrecords.traversal.FlatRecordTraversalNode;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class HollowListTypeMapper
extends HollowTypeMapper {
    private static final String NULL_ELEMENT_MESSAGE = "Null element contained in instance of a List with schema \"%s\". Lists cannot contain null elements";
    private final HollowListSchema schema;
    private final HollowListTypeWriteState writeState;
    private final ThreadLocal<IntList> intList = new ThreadLocal();
    private final boolean ignoreListOrdering;
    private final HollowTypeMapper elementMapper;

    public HollowListTypeMapper(HollowObjectMapper parentMapper, ParameterizedType type, String declaredName, int numShards, boolean ignoreListOrdering, Set<Type> visited) {
        this.elementMapper = parentMapper.getTypeMapper(type.getActualTypeArguments()[0], null, null, -1, visited);
        String typeName = declaredName != null ? declaredName : HollowListTypeMapper.getDefaultTypeName(type);
        this.schema = new HollowListSchema(typeName, this.elementMapper.getTypeName());
        this.ignoreListOrdering = ignoreListOrdering;
        HollowListTypeWriteState existingTypeState = (HollowListTypeWriteState)parentMapper.getStateEngine().getTypeState(typeName);
        this.writeState = existingTypeState != null ? existingTypeState : new HollowListTypeWriteState(this.schema, numShards);
    }

    @Override
    public String getTypeName() {
        return this.schema.getName();
    }

    @Override
    public int write(Object obj) {
        long assignedOrdinal;
        if (obj instanceof MemoizedList && ((assignedOrdinal = ((MemoizedList)obj).__assigned_ordinal) & 0xFFFFFFFF00000000L) == this.cycleSpecificAssignedOrdinalBits()) {
            return (int)assignedOrdinal & Integer.MAX_VALUE;
        }
        List l = (List)obj;
        HollowListWriteRecord rec = this.copyToWriteRecord(l, null);
        int assignedOrdinal2 = this.writeState.add(rec);
        if (obj instanceof MemoizedList) {
            ((MemoizedList)obj).__assigned_ordinal = (long)assignedOrdinal2 | this.cycleSpecificAssignedOrdinalBits();
        }
        return assignedOrdinal2;
    }

    @Override
    public int writeFlat(Object obj, FlatRecordWriter flatRecordWriter) {
        HollowListWriteRecord rec = this.copyToWriteRecord((List)obj, flatRecordWriter);
        return flatRecordWriter.write(this.schema, rec);
    }

    private HollowListWriteRecord copyToWriteRecord(List<?> l, FlatRecordWriter flatRecordWriter) {
        HollowListWriteRecord rec = (HollowListWriteRecord)this.writeRecord();
        if (this.ignoreListOrdering) {
            IntList ordinalList = this.getIntList();
            for (Object o : l) {
                if (o == null) {
                    throw new NullPointerException(String.format(NULL_ELEMENT_MESSAGE, this.schema));
                }
                int ordinal = flatRecordWriter == null ? this.elementMapper.write(o) : this.elementMapper.writeFlat(o, flatRecordWriter);
                ordinalList.add(ordinal);
            }
            ordinalList.sort();
            for (int i = 0; i < ordinalList.size(); ++i) {
                rec.addElement(ordinalList.get(i));
            }
        } else {
            for (Object o : l) {
                if (o == null) {
                    throw new NullPointerException(String.format(NULL_ELEMENT_MESSAGE, this.schema));
                }
                int ordinal = flatRecordWriter == null ? this.elementMapper.write(o) : this.elementMapper.writeFlat(o, flatRecordWriter);
                rec.addElement(ordinal);
            }
        }
        return rec;
    }

    @Override
    protected Object parseHollowRecord(HollowRecord record) {
        GenericHollowList hollowList = (GenericHollowList)record;
        ArrayList<Object> list = new ArrayList<Object>();
        for (HollowRecord element : hollowList) {
            list.add(this.elementMapper.parseHollowRecord(element));
        }
        return list;
    }

    @Override
    protected Object parseFlatRecord(FlatRecordTraversalNode node) {
        ArrayList<Object> collection = new ArrayList<Object>();
        for (FlatRecordTraversalNode elementNode : (FlatRecordTraversalListNode)node) {
            Object element = this.elementMapper.parseFlatRecord(elementNode);
            collection.add(element);
        }
        return collection;
    }

    @Override
    protected HollowWriteRecord newWriteRecord() {
        return new HollowListWriteRecord();
    }

    private IntList getIntList() {
        IntList list = this.intList.get();
        if (list == null) {
            list = new IntList();
            this.intList.set(list);
        }
        list.clear();
        return list;
    }

    @Override
    protected HollowTypeWriteState getTypeWriteState() {
        return this.writeState;
    }
}

