/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.copy;

import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.copy.HollowListCopier;
import com.netflix.hollow.core.write.copy.HollowMapCopier;
import com.netflix.hollow.core.write.copy.HollowObjectCopier;
import com.netflix.hollow.core.write.copy.HollowSetCopier;
import com.netflix.hollow.tools.combine.IdentityOrdinalRemapper;
import com.netflix.hollow.tools.combine.OrdinalRemapper;

public abstract class HollowRecordCopier {
    protected final HollowTypeReadState readTypeState;
    protected final HollowWriteRecord writeRecord;
    protected final OrdinalRemapper ordinalRemapper;
    protected final boolean preserveHashPositions;

    protected HollowRecordCopier(HollowTypeReadState readTypeState, HollowWriteRecord writeRecord, OrdinalRemapper ordinalRemapper, boolean preserveHashPositions) {
        this.readTypeState = readTypeState;
        this.writeRecord = writeRecord;
        this.ordinalRemapper = ordinalRemapper;
        this.preserveHashPositions = preserveHashPositions;
    }

    public HollowTypeReadState getReadTypeState() {
        return this.readTypeState;
    }

    public abstract HollowWriteRecord copy(int var1);

    public static HollowRecordCopier createCopier(HollowTypeReadState typeState) {
        return HollowRecordCopier.createCopier(typeState, typeState.getSchema());
    }

    public static HollowRecordCopier createCopier(HollowTypeReadState typeState, HollowSchema destinationSchema) {
        return HollowRecordCopier.createCopier(typeState, destinationSchema, IdentityOrdinalRemapper.INSTANCE, true);
    }

    public static HollowRecordCopier createCopier(HollowTypeReadState typeState, OrdinalRemapper remapper, boolean preserveHashPositions) {
        return HollowRecordCopier.createCopier(typeState, typeState.getSchema(), remapper, preserveHashPositions);
    }

    public static HollowRecordCopier createCopier(HollowTypeReadState typeState, HollowSchema destinationSchema, OrdinalRemapper ordinalRemapper, boolean preserveHashPositions) {
        if (typeState instanceof HollowObjectTypeReadState) {
            return new HollowObjectCopier((HollowObjectTypeReadState)typeState, (HollowObjectSchema)destinationSchema, ordinalRemapper);
        }
        if (typeState instanceof HollowListTypeReadState) {
            return new HollowListCopier((HollowListTypeReadState)typeState, ordinalRemapper);
        }
        if (typeState instanceof HollowSetTypeReadState) {
            return new HollowSetCopier((HollowSetTypeReadState)typeState, ordinalRemapper, preserveHashPositions);
        }
        if (typeState instanceof HollowMapTypeReadState) {
            return new HollowMapCopier((HollowMapTypeReadState)typeState, ordinalRemapper, preserveHashPositions);
        }
        throw new UnsupportedOperationException("I don't know how to create a copier for a " + typeState.getClass().getSimpleName());
    }
}

