/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.copy;

import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.OrdinalRemapper;

public class HollowObjectCopier
extends HollowRecordCopier {
    private final int[] fieldIndexMapping;

    public HollowObjectCopier(HollowObjectTypeReadState readTypeState, HollowObjectSchema destinationSchema, OrdinalRemapper ordinalRemapper) {
        super(readTypeState, new HollowObjectWriteRecord(destinationSchema), ordinalRemapper, false);
        this.fieldIndexMapping = new int[destinationSchema.numFields()];
        for (int i = 0; i < this.fieldIndexMapping.length; ++i) {
            String fieldName = destinationSchema.getFieldName(i);
            this.fieldIndexMapping[i] = this.readState().getSchema().getPosition(fieldName);
        }
    }

    @Override
    public HollowWriteRecord copy(int ordinal) {
        HollowObjectTypeReadState objectReadState = this.readState();
        HollowObjectWriteRecord rec = this.rec();
        rec.reset();
        block10: for (int i = 0; i < rec.getSchema().numFields(); ++i) {
            String fieldName = rec.getSchema().getFieldName(i);
            int readFieldIndex = this.fieldIndexMapping[i];
            if (readFieldIndex == -1) continue;
            switch (this.rec().getSchema().getFieldType(i)) {
                case BOOLEAN: {
                    Boolean bool = objectReadState.readBoolean(ordinal, readFieldIndex);
                    if (bool == null) continue block10;
                    rec.setBoolean(fieldName, bool);
                    continue block10;
                }
                case BYTES: {
                    byte[] bytes = objectReadState.readBytes(ordinal, readFieldIndex);
                    if (bytes == null) continue block10;
                    rec.setBytes(fieldName, bytes);
                    continue block10;
                }
                case STRING: {
                    String str = objectReadState.readString(ordinal, readFieldIndex);
                    if (str == null) continue block10;
                    rec.setString(fieldName, str);
                    continue block10;
                }
                case DOUBLE: {
                    double doubleVal = objectReadState.readDouble(ordinal, readFieldIndex);
                    if (Double.isNaN(doubleVal)) continue block10;
                    rec.setDouble(fieldName, doubleVal);
                    continue block10;
                }
                case FLOAT: {
                    float floatVal = objectReadState.readFloat(ordinal, readFieldIndex);
                    if (Float.isNaN(floatVal)) continue block10;
                    rec.setFloat(fieldName, floatVal);
                    continue block10;
                }
                case INT: {
                    int intVal = objectReadState.readInt(ordinal, readFieldIndex);
                    if (intVal == Integer.MIN_VALUE) continue block10;
                    rec.setInt(fieldName, intVal);
                    continue block10;
                }
                case LONG: {
                    long longVal = objectReadState.readLong(ordinal, readFieldIndex);
                    if (longVal == Long.MIN_VALUE) continue block10;
                    rec.setLong(fieldName, longVal);
                    continue block10;
                }
                case REFERENCE: {
                    int ordinalVal = objectReadState.readOrdinal(ordinal, readFieldIndex);
                    if (ordinalVal < 0) continue block10;
                    int remappedOrdinalVal = this.ordinalRemapper.getMappedOrdinal(this.readState().getSchema().getReferencedType(readFieldIndex), ordinalVal);
                    rec.setReference(fieldName, remappedOrdinalVal);
                }
            }
        }
        return rec;
    }

    private HollowObjectTypeReadState readState() {
        return (HollowObjectTypeReadState)this.readTypeState;
    }

    private HollowObjectWriteRecord rec() {
        return (HollowObjectWriteRecord)this.writeRecord;
    }
}

