/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.api.error.HollowWriteStateException;
import com.netflix.hollow.api.error.SchemaNotFoundException;
import com.netflix.hollow.core.HollowStateEngine;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.DefaultHashCodeFinder;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class HollowWriteStateEngine
implements HollowStateEngine {
    private final Logger log = Logger.getLogger(HollowWriteStateEngine.class.getName());
    private final Map<String, HollowTypeWriteState> writeStates;
    private final Map<String, HollowSchema> hollowSchemas;
    private final List<HollowTypeWriteState> orderedTypeStates;
    private final Map<String, String> headerTags = new ConcurrentHashMap<String, String>();
    private final Map<String, String> previousHeaderTags = new ConcurrentHashMap<String, String>();
    private final HollowObjectHashCodeFinder hashCodeFinder;
    private long targetMaxTypeShardSize = Long.MAX_VALUE;
    private boolean focusHoleFillInFewestShards = false;
    private boolean allowTypeResharding = false;
    private List<String> restoredStates;
    private boolean preparedForNextCycle = true;
    private long previousStateRandomizedTag = -1L;
    private long nextStateRandomizedTag;

    public HollowWriteStateEngine() {
        this(new DefaultHashCodeFinder(new String[0]));
    }

    @Deprecated
    public HollowWriteStateEngine(HollowObjectHashCodeFinder hasher) {
        this.writeStates = new HashMap<String, HollowTypeWriteState>();
        this.hollowSchemas = new HashMap<String, HollowSchema>();
        this.orderedTypeStates = new ArrayList<HollowTypeWriteState>();
        this.hashCodeFinder = hasher;
        this.nextStateRandomizedTag = this.mintNewRandomizedStateTag();
    }

    public int add(String type, HollowWriteRecord rec) {
        HollowTypeWriteState hollowTypeWriteState = this.writeStates.get(type);
        if (hollowTypeWriteState == null) {
            throw new IllegalArgumentException("Type " + type + " does not exist!");
        }
        return hollowTypeWriteState.add(rec);
    }

    public synchronized void addTypeState(HollowTypeWriteState writeState) {
        HollowSchema schema = writeState.getSchema();
        if (this.writeStates.containsKey(schema.getName())) {
            throw new IllegalStateException("The state for type " + schema.getName() + " has already been added!");
        }
        this.hollowSchemas.put(schema.getName(), schema);
        this.writeStates.put(schema.getName(), writeState);
        this.orderedTypeStates.add(writeState);
        writeState.setStateEngine(this);
    }

    public void restoreFrom(HollowReadStateEngine readStateEngine) {
        if (!readStateEngine.isListenToAllPopulatedOrdinals()) {
            throw new IllegalStateException("The specified HollowReadStateEngine must be listening for all populated ordinals!");
        }
        for (HollowTypeReadState hollowTypeReadState : readStateEngine.getTypeStates()) {
            String typeName = hollowTypeReadState.getSchema().getName();
            HollowTypeWriteState writeState = this.writeStates.get(typeName);
            if (writeState == null) continue;
            if (writeState.getNumShards() == -1) {
                writeState.setNumShards(hollowTypeReadState.numShards());
                continue;
            }
            if (hollowTypeReadState.numShards() == 0 || writeState.getNumShards() == hollowTypeReadState.numShards()) continue;
            String msg = "Attempting to restore from a HollowReadStateEngine with numShards " + hollowTypeReadState.numShards() + " for type " + typeName + " to write state engine with numShards " + writeState.getNumShards();
            throw new IllegalStateException(msg);
        }
        this.restoredStates = new ArrayList<String>();
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "restore");
        for (final HollowTypeReadState readState : readStateEngine.getTypeStates()) {
            final String typeName = readState.getSchema().getName();
            final HollowTypeWriteState writeState = this.writeStates.get(typeName);
            this.restoredStates.add(typeName);
            if (writeState == null) continue;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    HollowWriteStateEngine.this.log.info("RESTORE: " + typeName);
                    writeState.restoreFrom(readState);
                }
            });
        }
        this.previousStateRandomizedTag = readStateEngine.getCurrentRandomizedTag();
        this.nextStateRandomizedTag = this.mintNewRandomizedStateTag();
        this.overridePreviousHeaderTags(readStateEngine.getHeaderTags());
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception exception) {
            throw new HollowWriteStateException("Unable to restore write state from read state engine", exception);
        }
    }

    public void prepareForWrite() {
        this.prepareForWrite(false);
    }

    protected void prepareForWrite(final boolean canReshard) {
        if (!this.preparedForNextCycle) {
            return;
        }
        this.addTypeNamesWithDefinedHashCodesToHeader();
        try {
            SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "prepare-for-write");
            for (final Map.Entry<String, HollowTypeWriteState> typeStateEntry : this.writeStates.entrySet()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((HollowTypeWriteState)typeStateEntry.getValue()).prepareForWrite(canReshard);
                    }
                });
            }
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception ex) {
            throw new HollowWriteStateException("Failed to prepare for write", ex);
        }
        this.preparedForNextCycle = false;
    }

    public void prepareForNextCycle() {
        if (this.preparedForNextCycle) {
            return;
        }
        this.previousStateRandomizedTag = this.nextStateRandomizedTag;
        this.nextStateRandomizedTag = this.mintNewRandomizedStateTag();
        this.overridePreviousHeaderTags(this.headerTags);
        try {
            SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "prepare-for-next-cycle");
            for (final Map.Entry<String, HollowTypeWriteState> typeStateEntry : this.writeStates.entrySet()) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((HollowTypeWriteState)typeStateEntry.getValue()).prepareForNextCycle();
                    }
                });
            }
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception ex) {
            throw new HollowWriteStateException("Failed to prepare for next cycle", ex);
        }
        this.preparedForNextCycle = true;
        this.restoredStates = null;
    }

    public void addAllObjectsFromPreviousCycle() {
        for (HollowTypeWriteState typeState : this.orderedTypeStates) {
            typeState.addAllObjectsFromPreviousCycle();
        }
    }

    public void resetToLastPrepareForNextCycle() {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "reset-to-last-prepare-for-next-cycle");
        for (final Map.Entry<String, HollowTypeWriteState> typeStateEntry : this.writeStates.entrySet()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((HollowTypeWriteState)typeStateEntry.getValue()).resetToLastPrepareForNextCycle();
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception ex) {
            throw new HollowWriteStateException("Unable to reset to the prior version of the write state", ex);
        }
        this.nextStateRandomizedTag = this.mintNewRandomizedStateTag();
        this.preparedForNextCycle = true;
    }

    public boolean hasChangedSinceLastCycle() {
        for (Map.Entry<String, HollowTypeWriteState> typeStateEntry : this.writeStates.entrySet()) {
            if (!typeStateEntry.getValue().hasChangedSinceLastCycle()) continue;
            return true;
        }
        return false;
    }

    public boolean isRestored() {
        return this.restoredStates != null;
    }

    void ensureAllNecessaryStatesRestored() {
        if (!this.isRestored()) {
            return;
        }
        ArrayList<String> unrestoredStates = new ArrayList<String>();
        for (HollowTypeWriteState typeState : this.orderedTypeStates) {
            if (!this.restoredStates.contains(typeState.getSchema().getName()) || typeState.isRestored()) continue;
            unrestoredStates.add(typeState.getSchema().getName());
        }
        if (!unrestoredStates.isEmpty()) {
            throw new IllegalStateException(String.format("Current state was restored but contains unrestored state for top-level types %s. Those types need to be registered with the producer (see HollowProducer.initializeDataModel)", unrestoredStates));
        }
    }

    public List<HollowTypeWriteState> getOrderedTypeStates() {
        return this.orderedTypeStates;
    }

    public HollowTypeWriteState getTypeState(String typeName) {
        return this.writeStates.get(typeName);
    }

    @Override
    public List<HollowSchema> getSchemas() {
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>();
        for (HollowTypeWriteState typeState : this.orderedTypeStates) {
            schemas.add(typeState.getSchema());
        }
        return schemas;
    }

    @Override
    public HollowSchema getSchema(String schemaName) {
        return this.hollowSchemas.get(schemaName);
    }

    @Override
    public HollowSchema getNonNullSchema(String schemaName) {
        HollowSchema schema = this.getSchema(schemaName);
        if (schema == null) {
            ArrayList<String> schemas = new ArrayList<String>();
            for (HollowSchema s : this.getSchemas()) {
                schemas.add(s.getName());
            }
            throw new SchemaNotFoundException(schemaName, schemas);
        }
        return schema;
    }

    @Override
    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public void addHeaderTag(String name, String value) {
        this.headerTags.put(name, value);
    }

    public void addHeaderTags(Map<String, String> headerTags) {
        this.headerTags.putAll(headerTags);
    }

    public Map<String, String> getPreviousHeaderTags() {
        return this.previousHeaderTags;
    }

    @Override
    public String getHeaderTag(String name) {
        return this.headerTags.get(name);
    }

    @Deprecated
    public HollowObjectHashCodeFinder getHashCodeFinder() {
        return this.hashCodeFinder;
    }

    public long getPreviousStateRandomizedTag() {
        return this.previousStateRandomizedTag;
    }

    public void overridePreviousStateRandomizedTag(long previousStateRandomizedTag) {
        this.previousStateRandomizedTag = previousStateRandomizedTag;
    }

    public void overridePreviousHeaderTags(Map<String, String> previousHeaderTags) {
        this.previousHeaderTags.clear();
        this.previousHeaderTags.putAll(previousHeaderTags);
    }

    public long getNextStateRandomizedTag() {
        return this.nextStateRandomizedTag;
    }

    public void overrideNextStateRandomizedTag(long nextStateRandomizedTag) {
        this.nextStateRandomizedTag = nextStateRandomizedTag;
    }

    public void setTargetMaxTypeShardSize(long targetMaxTypeShardSize) {
        if (targetMaxTypeShardSize < 0L) {
            throw new IllegalArgumentException("Invalid target max shard size specified: " + targetMaxTypeShardSize);
        }
        this.targetMaxTypeShardSize = targetMaxTypeShardSize;
    }

    long getTargetMaxTypeShardSize() {
        return this.targetMaxTypeShardSize;
    }

    public void allowTypeResharding(boolean allowTypeResharding) {
        this.allowTypeResharding = allowTypeResharding;
    }

    public boolean allowTypeResharding() {
        return this.allowTypeResharding;
    }

    public void setFocusHoleFillInFewestShards(boolean focusHoleFillInFewestShards) {
        this.focusHoleFillInFewestShards = focusHoleFillInFewestShards;
    }

    boolean isFocusHoleFillInFewestShards() {
        return this.focusHoleFillInFewestShards;
    }

    private long mintNewRandomizedStateTag() {
        Random rand = new Random();
        long newTag = rand.nextLong();
        while ((newTag & 0xFFFFFFFF00000000L) == 0L || (newTag & 0xFFFFFFFF00000000L) == -4294967296L || (newTag & 0xFFFFFFFF00000000L) == (this.previousStateRandomizedTag & 0xFFFFFFFF00000000L)) {
            newTag = rand.nextLong();
        }
        return newTag;
    }

    private void addTypeNamesWithDefinedHashCodesToHeader() {
        Set<String> typeNames = this.hashCodeFinder.getTypesWithDefinedHashCodes();
        if (typeNames != null && !typeNames.isEmpty()) {
            StringBuilder typeNamesBuilder = new StringBuilder();
            int counter = 0;
            TreeSet<String> sortedNames = new TreeSet<String>(typeNames);
            for (String typeName : sortedNames) {
                if (counter++ != 0) {
                    typeNamesBuilder.append(",");
                }
                typeNamesBuilder.append(typeName);
            }
            this.addHeaderTag("DEFINED_HASH_CODES", typeNamesBuilder.toString());
        }
    }
}

