/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteArrayOrdinalMap;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HollowTypeWriteState {
    private static final Logger LOG = Logger.getLogger(HollowTypeWriteState.class.getName());
    protected final HollowSchema schema;
    protected final ByteArrayOrdinalMap ordinalMap;
    protected int maxOrdinal;
    protected int numShards;
    protected int revNumShards;
    private int resetToLastNumShards;
    protected HollowSchema restoredSchema;
    protected ByteArrayOrdinalMap restoredMap;
    protected HollowTypeReadState restoredReadState;
    protected ThreadSafeBitSet currentCyclePopulated;
    protected ThreadSafeBitSet previousCyclePopulated;
    private final ThreadLocal<ByteDataArray> serializedScratchSpace;
    protected HollowWriteStateEngine stateEngine;
    private boolean wroteData = false;
    private final boolean isNumShardsPinned;
    protected int[] maxShardOrdinal;
    protected int[] revMaxShardOrdinal;

    public HollowTypeWriteState(HollowSchema schema, int numShards) {
        this.schema = schema;
        this.ordinalMap = new ByteArrayOrdinalMap();
        this.serializedScratchSpace = new ThreadLocal();
        this.currentCyclePopulated = new ThreadSafeBitSet();
        this.previousCyclePopulated = new ThreadSafeBitSet();
        this.numShards = numShards;
        this.isNumShardsPinned = numShards != -1;
        this.resetToLastNumShards = numShards;
        if (numShards != -1 && ((numShards & numShards - 1) != 0 || numShards <= 0)) {
            throw new IllegalArgumentException("Number of shards must be a power of 2!  Check configuration for type " + schema.getName());
        }
    }

    public int add(HollowWriteRecord rec) {
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The HollowWriteStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        int ordinal = this.restoredMap == null ? this.assignOrdinal(rec) : this.reuseOrdinalFromRestoredState(rec);
        this.currentCyclePopulated.set(ordinal);
        return ordinal;
    }

    private int assignOrdinal(HollowWriteRecord rec) {
        ByteDataArray scratch = this.scratch();
        rec.writeDataTo(scratch);
        int ordinal = this.ordinalMap.getOrAssignOrdinal(scratch);
        scratch.reset();
        return ordinal;
    }

    private int reuseOrdinalFromRestoredState(HollowWriteRecord rec) {
        int ordinal;
        ByteDataArray scratch = this.scratch();
        if (this.restoredSchema instanceof HollowObjectSchema) {
            ((HollowObjectWriteRecord)rec).writeDataTo(scratch, (HollowObjectSchema)this.restoredSchema);
            int preferredOrdinal = this.restoredMap.get(scratch);
            scratch.reset();
            rec.writeDataTo(scratch);
            ordinal = this.ordinalMap.getOrAssignOrdinal(scratch, preferredOrdinal);
        } else if (rec instanceof HollowHashableWriteRecord) {
            ((HollowHashableWriteRecord)rec).writeDataTo(scratch, HollowHashableWriteRecord.HashBehavior.IGNORED_HASHES);
            int preferredOrdinal = this.restoredMap.get(scratch);
            scratch.reset();
            rec.writeDataTo(scratch);
            ordinal = this.ordinalMap.getOrAssignOrdinal(scratch, preferredOrdinal);
        } else {
            rec.writeDataTo(scratch);
            int preferredOrdinal = this.restoredMap.get(scratch);
            ordinal = this.ordinalMap.getOrAssignOrdinal(scratch, preferredOrdinal);
        }
        scratch.reset();
        return ordinal;
    }

    public void resetToLastPrepareForNextCycle() {
        this.numShards = this.resetToLastNumShards;
        if (this.restoredReadState == null) {
            this.currentCyclePopulated.clearAll();
            this.ordinalMap.compact(this.previousCyclePopulated, this.numShards, this.stateEngine.isFocusHoleFillInFewestShards());
        } else {
            this.currentCyclePopulated.clearAll();
            this.previousCyclePopulated.clearAll();
            this.ordinalMap.compact(this.previousCyclePopulated, this.numShards, this.stateEngine.isFocusHoleFillInFewestShards());
            this.restoreFrom(this.restoredReadState);
            this.wroteData = false;
        }
    }

    public void addAllObjectsFromPreviousCycle() {
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The HollowWriteStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        this.currentCyclePopulated = ThreadSafeBitSet.orAll(this.previousCyclePopulated, this.currentCyclePopulated);
    }

    public void addOrdinalFromPreviousCycle(int ordinal) {
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The HollowWriteStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        if (!this.previousCyclePopulated.get(ordinal)) {
            throw new IllegalArgumentException("Ordinal " + ordinal + " was not present in the previous cycle");
        }
        this.currentCyclePopulated.set(ordinal);
    }

    public void removeOrdinalFromThisCycle(int ordinalToRemove) {
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The HollowWriteStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        this.currentCyclePopulated.clear(ordinalToRemove);
    }

    public void removeAllOrdinalsFromThisCycle() {
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The HollowWriteStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        this.currentCyclePopulated.clearAll();
    }

    public void mapOrdinal(HollowWriteRecord rec, int newOrdinal, boolean markPreviousCycle, boolean markCurrentCycle) {
        if (!this.ordinalMap.isReadyForAddingObjects()) {
            throw new RuntimeException("The HollowWriteStateEngine is not ready to add more Objects.  Did you remember to call stateEngine.prepareForNextCycle()?");
        }
        ByteDataArray scratch = this.scratch();
        rec.writeDataTo(scratch);
        this.ordinalMap.put(scratch, newOrdinal);
        if (markPreviousCycle) {
            this.previousCyclePopulated.set(newOrdinal);
        }
        if (markCurrentCycle) {
            this.currentCyclePopulated.set(newOrdinal);
        }
        scratch.reset();
    }

    public void recalculateFreeOrdinals() {
        this.ordinalMap.recalculateFreeOrdinals();
    }

    public ThreadSafeBitSet getPopulatedBitSet() {
        return this.currentCyclePopulated;
    }

    public ThreadSafeBitSet getPreviousCyclePopulatedBitSet() {
        return this.previousCyclePopulated;
    }

    public HollowSchema getSchema() {
        return this.schema;
    }

    public int getNumShards() {
        return this.numShards;
    }

    boolean isNumShardsPinned() {
        return this.isNumShardsPinned;
    }

    int getRevNumShards() {
        return this.revNumShards;
    }

    public void setNumShards(int numShards) {
        if (this.numShards == -1) {
            this.numShards = numShards;
            this.resetToLastNumShards = numShards;
        } else if (this.numShards != numShards) {
            throw new IllegalStateException("The number of shards for type " + this.schema.getName() + " is already fixed to " + this.numShards + ".  Cannot reset to " + numShards + ".");
        }
    }

    public void resizeOrdinalMap(int size) {
        this.ordinalMap.resize(size);
    }

    public void prepareForNextCycle() {
        this.ordinalMap.compact(this.currentCyclePopulated, this.numShards, this.stateEngine.isFocusHoleFillInFewestShards());
        ThreadSafeBitSet temp = this.previousCyclePopulated;
        this.previousCyclePopulated = this.currentCyclePopulated;
        this.currentCyclePopulated = temp;
        this.currentCyclePopulated.clearAll();
        this.restoredMap = null;
        this.restoredSchema = null;
        this.restoredReadState = null;
        this.resetToLastNumShards = this.numShards;
    }

    public void prepareForWrite(boolean canReshard) {
        if (this.isRestored() && !this.wroteData) {
            HollowRecordCopier copier = HollowRecordCopier.createCopier(this.restoredReadState, this.schema);
            BitSet unusedPreviousOrdinals = this.ordinalMap.getUnusedPreviousOrdinals();
            int ordinal = unusedPreviousOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                this.restoreOrdinal(ordinal, copier, this.ordinalMap, HollowHashableWriteRecord.HashBehavior.UNMIXED_HASHES);
                ordinal = unusedPreviousOrdinals.nextSetBit(ordinal + 1);
            }
        }
        this.ordinalMap.prepareForWrite();
        this.wroteData = true;
    }

    public boolean hasChangedSinceLastCycle() {
        if (!this.currentCyclePopulated.equals(this.previousCyclePopulated)) {
            return true;
        }
        return this.numShards != this.revNumShards && this.revNumShards != 0;
    }

    public boolean isRestored() {
        return this.ordinalMap.getUnusedPreviousOrdinals() != null;
    }

    public abstract void calculateSnapshot();

    public abstract void writeSnapshot(DataOutputStream var1) throws IOException;

    public void calculateDelta() {
        this.calculateDelta(this.previousCyclePopulated, this.currentCyclePopulated, false);
    }

    public void calculateReverseDelta() {
        this.calculateDelta(this.currentCyclePopulated, this.previousCyclePopulated, true);
    }

    public void writeDelta(DataOutputStream dos) throws IOException {
        LOG.log(Level.FINE, String.format("Writing delta with num shards = %s, max shard ordinals = %s", this.numShards, Arrays.toString(this.maxShardOrdinal)));
        this.writeCalculatedDelta(dos, false, this.maxShardOrdinal);
    }

    public void writeReverseDelta(DataOutputStream dos) throws IOException {
        LOG.log(Level.FINE, String.format("Writing reversedelta with num shards = %s, max shard ordinals = %s", this.revNumShards, Arrays.toString(this.revMaxShardOrdinal)));
        this.writeCalculatedDelta(dos, true, this.revMaxShardOrdinal);
    }

    public abstract void calculateDelta(ThreadSafeBitSet var1, ThreadSafeBitSet var2, boolean var3);

    public abstract void writeCalculatedDelta(DataOutputStream var1, boolean var2, int[] var3) throws IOException;

    protected void restoreFrom(HollowTypeReadState readState) {
        if (this.previousCyclePopulated.cardinality() != 0 || this.currentCyclePopulated.cardinality() != 0) {
            throw new IllegalStateException("Attempting to restore into a non-empty state (type " + this.schema.getName() + ")");
        }
        PopulatedOrdinalListener listener = readState.getListener(PopulatedOrdinalListener.class);
        BitSet populatedOrdinals = listener.getPopulatedOrdinals();
        this.restoredReadState = readState;
        this.restoredSchema = this.schema instanceof HollowObjectSchema ? ((HollowObjectSchema)this.schema).findCommonSchema((HollowObjectSchema)readState.getSchema()) : readState.getSchema();
        HollowRecordCopier copier = HollowRecordCopier.createCopier(this.restoredReadState, this.restoredSchema);
        int size = populatedOrdinals.cardinality();
        this.restoredMap = new ByteArrayOrdinalMap(size);
        int ordinal = populatedOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            this.previousCyclePopulated.set(ordinal);
            this.restoreOrdinal(ordinal, copier, this.restoredMap, HollowHashableWriteRecord.HashBehavior.IGNORED_HASHES);
            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
        }
        this.ordinalMap.resize(size);
        this.ordinalMap.reservePreviouslyPopulatedOrdinals(populatedOrdinals);
    }

    protected void restoreOrdinal(int ordinal, HollowRecordCopier copier, ByteArrayOrdinalMap destinationMap, HollowHashableWriteRecord.HashBehavior hashBehavior) {
        HollowWriteRecord rec = copier.copy(ordinal);
        ByteDataArray scratch = this.scratch();
        if (rec instanceof HollowHashableWriteRecord) {
            ((HollowHashableWriteRecord)rec).writeDataTo(scratch, hashBehavior);
        } else {
            rec.writeDataTo(scratch);
        }
        destinationMap.put(scratch, ordinal);
        scratch.reset();
    }

    protected ByteDataArray scratch() {
        ByteDataArray scratch = this.serializedScratchSpace.get();
        if (scratch == null) {
            scratch = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.serializedScratchSpace.set(scratch);
        }
        return scratch;
    }

    void setStateEngine(HollowWriteStateEngine writeEngine) {
        this.stateEngine = writeEngine;
    }

    public HollowWriteStateEngine getStateEngine() {
        return this.stateEngine;
    }

    protected static int[] calcMaxShardOrdinal(int maxOrdinal, int numShards) {
        int[] maxShardOrdinal = new int[numShards];
        int minRecordLocationsPerShard = (maxOrdinal + 1) / numShards;
        for (int i = 0; i < numShards; ++i) {
            maxShardOrdinal[i] = i < (maxOrdinal + 1 & numShards - 1) ? minRecordLocationsPerShard : minRecordLocationsPerShard - 1;
        }
        return maxShardOrdinal;
    }

    public boolean allowTypeResharding() {
        boolean isAllowed = this.stateEngine.allowTypeResharding();
        if (isAllowed && this.isNumShardsPinned()) {
            LOG.warning(String.format("The num shards for type %s is pinned (likely using the @HollowShardLargeType annotation in the data model) but this producer is also configured for dynamically adjusting the num shards based on data size during the course of the delta chain, so the pin for num shards will not be honored and it can be dropped", this.schema.getName()));
        }
        return isAllowed;
    }

    public void gatherShardingStats(int maxOrdinal, boolean canReshard) {
        if (this.numShards == -1) {
            this.revNumShards = this.numShards = this.typeStateNumShards(maxOrdinal);
        } else {
            this.revNumShards = this.numShards;
            if (canReshard && this.allowTypeResharding()) {
                this.numShards = this.typeStateNumShards(maxOrdinal);
                if (this.numShards != this.revNumShards) {
                    this.numShards = this.numShards > this.revNumShards ? this.revNumShards * 2 : this.revNumShards / 2;
                    LOG.info(String.format("Num shards for type %s changing from %s to %s", this.schema.getName(), this.revNumShards, this.numShards));
                    this.addReshardingHeader(this.revNumShards, this.numShards);
                }
            }
        }
        this.maxShardOrdinal = HollowTypeWriteState.calcMaxShardOrdinal(maxOrdinal, this.numShards);
        if (this.revNumShards > 0) {
            this.revMaxShardOrdinal = HollowTypeWriteState.calcMaxShardOrdinal(maxOrdinal, this.revNumShards);
        }
    }

    protected abstract int typeStateNumShards(int var1);

    protected void addReshardingHeader(int prevNumShards, int newNumShards) {
        String existing = this.stateEngine.getHeaderTag("hollow.type.resharding.invoked");
        String appendTo = "";
        if (existing != null) {
            appendTo = existing + " ";
        }
        this.stateEngine.addHeaderTag("hollow.type.resharding.invoked", appendTo + this.schema.getName() + ":(" + prevNumShards + "," + newNumShards + ")");
    }
}

