/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.schema.HollowObjectSchema;

public class FieldStatistics {
    private final HollowObjectSchema schema;
    private final int[] maxBitsForField;
    private final long[] nullValueForField;
    private final long[] totalSizeOfVarLengthField;
    private int numBitsPerRecord;
    private final int[] bitOffsetForField;

    public FieldStatistics(HollowObjectSchema schema) {
        this.schema = schema;
        this.maxBitsForField = new int[schema.numFields()];
        this.nullValueForField = new long[schema.numFields()];
        this.totalSizeOfVarLengthField = new long[schema.numFields()];
        this.bitOffsetForField = new int[schema.numFields()];
    }

    public int getNumBitsPerRecord() {
        return this.numBitsPerRecord;
    }

    public int getFieldBitOffset(int fieldIndex) {
        return this.bitOffsetForField[fieldIndex];
    }

    public int getMaxBitsForField(int fieldIndex) {
        return this.maxBitsForField[fieldIndex];
    }

    public long getNullValueForField(int fieldIndex) {
        return this.nullValueForField[fieldIndex];
    }

    public void addFixedLengthFieldRequiredBits(int fieldIndex, int numberOfBits) {
        if (numberOfBits > this.maxBitsForField[fieldIndex]) {
            this.maxBitsForField[fieldIndex] = numberOfBits;
        }
    }

    public void addVarLengthFieldSize(int fieldIndex, int fieldSize) {
        int n = fieldIndex;
        this.totalSizeOfVarLengthField[n] = this.totalSizeOfVarLengthField[n] + (long)fieldSize;
    }

    public void completeCalculations() {
        for (int i = 0; i < this.schema.numFields(); ++i) {
            if (this.schema.getFieldType(i) == HollowObjectSchema.FieldType.STRING || this.schema.getFieldType(i) == HollowObjectSchema.FieldType.BYTES) {
                this.maxBitsForField[i] = this.bitsRequiredForRepresentation(this.totalSizeOfVarLengthField[i]) + 1;
            }
            this.nullValueForField[i] = this.maxBitsForField[i] == 64 ? -1L : (1L << this.maxBitsForField[i]) - 1L;
            this.bitOffsetForField[i] = this.numBitsPerRecord;
            this.numBitsPerRecord += this.maxBitsForField[i];
        }
    }

    public long getTotalSizeOfAllVarLengthData() {
        long totalVarLengthDataSize = 0L;
        for (int i = 0; i < this.totalSizeOfVarLengthField.length; ++i) {
            totalVarLengthDataSize += this.totalSizeOfVarLengthField[i];
        }
        return totalVarLengthDataSize;
    }

    private int bitsRequiredForRepresentation(long value) {
        return 64 - Long.numberOfLeadingZeros(value + 1L);
    }
}

