/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import java.util.Objects;

public final class Threads {
    private Threads() {
    }

    public static Thread daemonThread(Runnable r, Class<?> context, String description) {
        return Threads.daemonThread(r, "hollow", context, description);
    }

    public static Thread daemonThread(Runnable r, Class<?> context, String description, int priority) {
        Thread thread = Threads.daemonThread(r, "hollow", context, description);
        thread.setPriority(priority);
        return thread;
    }

    public static Thread daemonThread(Runnable r, String platform, Class<?> context, String description) {
        Objects.requireNonNull(platform, "platform required");
        Objects.requireNonNull(context, "context required");
        Objects.requireNonNull(description, "description required");
        return Threads.daemonThread(r, Threads.name(platform, context, description));
    }

    public static Thread daemonThread(Runnable r, String name) {
        Objects.requireNonNull(r, "runnable required");
        Objects.requireNonNull(name, "name required");
        Thread t = new Thread(r, name);
        t.setDaemon(true);
        return t;
    }

    private static String name(String platform, Class<?> context, String description) {
        StringBuilder sb = new StringBuilder();
        sb.append(platform);
        sb.append(" | ");
        sb.append(context.getSimpleName());
        sb.append(" | ");
        sb.append(description);
        return sb.toString();
    }
}

