/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowBlobReader;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class StateEngineRoundTripper {
    public static HollowReadStateEngine roundTripSnapshot(HollowWriteStateEngine writeEngine) throws IOException {
        HollowReadStateEngine readEngine = new HollowReadStateEngine();
        StateEngineRoundTripper.roundTripSnapshot(writeEngine, readEngine);
        return readEngine;
    }

    public static void roundTripSnapshot(HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine) throws IOException {
        StateEngineRoundTripper.roundTripSnapshot(writeEngine, readEngine, null);
    }

    public static void roundTripSnapshot(HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine, HollowFilterConfig filter) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HollowBlobWriter writer = new HollowBlobWriter(writeEngine);
        writer.writeSnapshot(baos);
        writeEngine.prepareForNextCycle();
        HollowBlobReader reader = new HollowBlobReader(readEngine);
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        try (HollowBlobInput in = HollowBlobInput.serial(is);){
            if (filter == null) {
                reader.readSnapshot(in);
            } else {
                reader.readSnapshot(in, (TypeFilter)filter);
            }
        }
    }

    public static void roundTripDelta(HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        HollowBlobWriter writer = new HollowBlobWriter(writeEngine);
        writer.writeDelta(baos);
        HollowBlobReader reader = new HollowBlobReader(readEngine);
        try (HollowBlobInput hbi = HollowBlobInput.serial(baos.toByteArray());){
            reader.applyDelta(hbi);
        }
        writeEngine.prepareForNextCycle();
    }
}

