/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import java.util.Arrays;

public class IntMap {
    private final int[] keys;
    private final int[] values;
    private int size;

    public IntMap(int numEntries) {
        int arraySize = 1 << 32 - Integer.numberOfLeadingZeros((numEntries + 1) * 4 / 3 - 1);
        this.keys = new int[arraySize];
        this.values = new int[arraySize];
        Arrays.fill(this.keys, -1);
    }

    public int size() {
        return this.size;
    }

    public int get(int key) {
        int bucket = this.hashKey(key) % this.keys.length;
        while (this.keys[bucket] != -1) {
            if (this.keys[bucket] == key) {
                return this.values[bucket];
            }
            if (++bucket != this.keys.length) continue;
            bucket = 0;
        }
        return -1;
    }

    public void put(int key, int value) {
        int bucket = this.hashKey(key) % this.keys.length;
        while (this.keys[bucket] != -1) {
            if (this.keys[bucket] == key) {
                this.values[bucket] = value;
                return;
            }
            if (++bucket != this.keys.length) continue;
            bucket = 0;
        }
        this.keys[bucket] = key;
        this.values[bucket] = value;
        ++this.size;
    }

    private int hashKey(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key & Integer.MAX_VALUE;
    }

    public IntMapEntryIterator iterator() {
        return new IntMapEntryIterator();
    }

    public class IntMapEntryIterator {
        private int currentEntry = -1;

        public boolean next() {
            while (++this.currentEntry < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.currentEntry] == -1) continue;
                return true;
            }
            return false;
        }

        public int getKey() {
            return IntMap.this.keys[this.currentEntry];
        }

        public int getValue() {
            return IntMap.this.values[this.currentEntry];
        }
    }
}

