/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class IOUtils {
    public static void copyBytes(HollowBlobInput in, DataOutputStream[] os, long numBytes) throws IOException {
        byte[] buf = new byte[4096];
        while (numBytes > 0L) {
            int numBytesToRead = 4096;
            if (numBytes < 4096L) {
                numBytesToRead = (int)numBytes;
            }
            int bytesRead = in.read(buf, 0, numBytesToRead);
            for (int i = 0; i < os.length; ++i) {
                os[i].write(buf, 0, bytesRead);
            }
            numBytes -= (long)bytesRead;
        }
    }

    public static void copySegmentedLongArray(HollowBlobInput in, DataOutputStream[] os) throws IOException {
        long numLongsToWrite = VarInt.readVLong(in);
        for (int i = 0; i < os.length; ++i) {
            VarInt.writeVLong(os[i], numLongsToWrite);
        }
        IOUtils.copyBytes(in, os, numLongsToWrite * 8L);
    }

    public static int copyVInt(HollowBlobInput in, DataOutputStream[] os) throws IOException {
        int value = VarInt.readVInt(in);
        for (int i = 0; i < os.length; ++i) {
            VarInt.writeVInt(os[i], value);
        }
        return value;
    }

    public static long copyVLong(HollowBlobInput in, DataOutputStream[] os) throws IOException {
        long value = VarInt.readVLong(in);
        for (int i = 0; i < os.length; ++i) {
            VarInt.writeVLong(os[i], value);
        }
        return value;
    }
}

