/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.type.delegate;

import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowObjectAbstractDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.type.FloatTypeAPI;
import com.netflix.hollow.core.type.delegate.FloatDelegate;

public class FloatDelegateCachedImpl
extends HollowObjectAbstractDelegate
implements HollowCachedDelegate,
FloatDelegate {
    private final Float value;
    private FloatTypeAPI typeAPI;

    public FloatDelegateCachedImpl(FloatTypeAPI typeAPI, int ordinal) {
        this.value = typeAPI.getValueBoxed(ordinal);
        this.typeAPI = typeAPI;
    }

    @Override
    public float getValue(int ordinal) {
        if (this.value == null) {
            return Float.NaN;
        }
        return this.value.floatValue();
    }

    @Override
    public Float getValueBoxed(int ordinal) {
        return this.value;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return this.typeAPI.getTypeDataAccess().getSchema();
    }

    @Override
    public HollowObjectTypeDataAccess getTypeDataAccess() {
        return this.typeAPI.getTypeDataAccess();
    }

    @Override
    public FloatTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (FloatTypeAPI)typeAPI;
    }
}

