/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class HollowSetSchema
extends HollowCollectionSchema {
    private final String elementType;
    private final PrimaryKey hashKey;
    private HollowTypeReadState elementTypeState;

    public HollowSetSchema(String schemaName, String elementType, String ... hashKeyFieldPaths) {
        super(schemaName);
        this.elementType = elementType;
        this.hashKey = hashKeyFieldPaths == null || hashKeyFieldPaths.length == 0 ? null : new PrimaryKey(elementType, hashKeyFieldPaths);
    }

    @Override
    public String getElementType() {
        return this.elementType;
    }

    public PrimaryKey getHashKey() {
        return this.hashKey;
    }

    public void setElementTypeState(HollowTypeReadState elementTypeState) {
        this.elementTypeState = elementTypeState;
    }

    @Override
    public HollowTypeReadState getElementTypeState() {
        return this.elementTypeState;
    }

    @Override
    public HollowSchema.SchemaType getSchemaType() {
        return HollowSchema.SchemaType.SET;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HollowSetSchema)) {
            return false;
        }
        HollowSetSchema otherSchema = (HollowSetSchema)other;
        if (!this.getName().equals(otherSchema.getName())) {
            return false;
        }
        if (!this.getElementType().equals(otherSchema.getElementType())) {
            return false;
        }
        return HollowSetSchema.isNullableObjectEquals(this.hashKey, otherSchema.getHashKey());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getSchemaType().hashCode();
        result = 31 * result + this.elementType.hashCode();
        result = 31 * result + Objects.hashCode(this.hashKey);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName());
        builder.append(" Set<").append(this.getElementType()).append(">");
        if (this.hashKey != null) {
            builder.append(" @HashKey(");
            if (this.hashKey.numFields() > 0) {
                builder.append(this.hashKey.getFieldPath(0));
                for (int i = 1; i < this.hashKey.numFields(); ++i) {
                    builder.append(", ").append(this.hashKey.getFieldPath(i));
                }
            }
            builder.append(")");
        }
        builder.append(";");
        return builder.toString();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        if (this.getHashKey() != null) {
            dos.write(HollowSchema.SchemaType.SET.getTypeIdWithPrimaryKey());
        } else {
            dos.write(HollowSchema.SchemaType.SET.getTypeId());
        }
        dos.writeUTF(this.getName());
        dos.writeUTF(this.getElementType());
        if (this.getHashKey() != null) {
            VarInt.writeVInt(dos, this.getHashKey().numFields());
            for (int i = 0; i < this.getHashKey().numFields(); ++i) {
                dos.writeUTF(this.getHashKey().getFieldPath(i));
            }
        }
    }
}

