/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HollowSchemaUtil {
    public static Set<String> getTopLevelTypes(HollowReadStateEngine readState) {
        List<HollowSchema> schemas = readState.getSchemas();
        HashSet<String> topLevelTypes = new HashSet<String>(readState.getAllTypes());
        for (HollowSchema schema : schemas) {
            switch (schema.getSchemaType()) {
                case LIST: {
                    HollowListSchema listSchema = (HollowListSchema)schema;
                    topLevelTypes.remove(listSchema.getElementType());
                    break;
                }
                case SET: {
                    HollowSetSchema setSchema = (HollowSetSchema)schema;
                    topLevelTypes.remove(setSchema.getElementType());
                    break;
                }
                case MAP: {
                    HollowMapSchema mapSchema = (HollowMapSchema)schema;
                    topLevelTypes.remove(mapSchema.getKeyType());
                    topLevelTypes.remove(mapSchema.getValueType());
                    break;
                }
                case OBJECT: {
                    HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
                    for (int fieldIdx = 0; fieldIdx < objectSchema.numFields(); ++fieldIdx) {
                        if (objectSchema.getFieldType(fieldIdx) != HollowObjectSchema.FieldType.REFERENCE) continue;
                        topLevelTypes.remove(objectSchema.getReferencedType(fieldIdx));
                    }
                    break;
                }
            }
        }
        return topLevelTypes;
    }
}

