/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSetSampler;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.SetMapKeyHasher;
import com.netflix.hollow.core.read.engine.ShardsHolder;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadStateShard;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeShardsHolder;
import com.netflix.hollow.core.read.engine.set.PotentialMatchHollowSetOrdinalIterator;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.EmptyOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowSetOrdinalIterator;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HollowSetTypeReadState
extends HollowCollectionTypeReadState
implements HollowSetTypeDataAccess {
    private static final Logger LOG = Logger.getLogger(HollowSetTypeReadState.class.getName());
    private final HollowSetSampler sampler;
    private int maxOrdinal;
    private volatile HollowPrimaryKeyValueDeriver keyDeriver;
    volatile HollowSetTypeShardsHolder shardsVolatile;

    @Override
    public ShardsHolder getShardsVolatile() {
        return this.shardsVolatile;
    }

    @Override
    public void updateShardsVolatile(HollowTypeReadStateShard[] shards) {
        this.shardsVolatile = new HollowSetTypeShardsHolder(shards);
    }

    @Override
    public HollowTypeDataElements[] createTypeDataElements(int len) {
        return new HollowSetTypeDataElements[len];
    }

    @Override
    public HollowTypeReadStateShard createTypeReadStateShard(HollowSchema schema, HollowTypeDataElements dataElements, int shardOrdinalShift) {
        return new HollowSetTypeReadStateShard((HollowSetTypeDataElements)dataElements, shardOrdinalShift);
    }

    public HollowSetTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowSetSchema schema) {
        super(stateEngine, memoryMode, schema);
        this.sampler = new HollowSetSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        this.shardsVolatile = null;
    }

    public HollowSetTypeReadState(HollowSetSchema schema, HollowSetTypeDataElements dataElements) {
        super(null, MemoryMode.ON_HEAP, schema);
        this.sampler = new HollowSetSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        HollowSetTypeReadStateShard newShard = new HollowSetTypeReadStateShard(dataElements, 0);
        this.shardsVolatile = new HollowSetTypeShardsHolder(new HollowSetTypeReadStateShard[]{newShard});
        this.maxOrdinal = dataElements.maxOrdinal;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler, int numShards) throws IOException {
        if (numShards > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        HollowTypeReadStateShard[] newShards = new HollowSetTypeReadStateShard[numShards];
        int shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        for (int i = 0; i < numShards; ++i) {
            HollowSetTypeDataElements shardDataElements = new HollowSetTypeDataElements(this.memoryMode, memoryRecycler);
            shardDataElements.readSnapshot(in);
            newShards[i] = new HollowSetTypeReadStateShard(shardDataElements, shardOrdinalShift);
        }
        this.shardsVolatile = new HollowSetTypeShardsHolder(newShards);
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema schema, ArraySegmentRecycler memoryRecycler, int deltaNumShards) throws IOException {
        if (this.shardsVolatile.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shardsVolatile.shards.length; ++i) {
            HollowSetTypeDataElements deltaData = new HollowSetTypeDataElements(this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                }
                HollowSetTypeDataElements currentData = this.shardsVolatile.shards[i].dataElements;
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowSetTypeDataElements nextData = new HollowSetTypeDataElements(this.memoryMode, memoryRecycler);
                HollowSetTypeDataElements oldData = this.shardsVolatile.shards[i].dataElements;
                nextData.applyDelta(oldData, deltaData);
                HollowSetTypeReadStateShard newShard = new HollowSetTypeReadStateShard(nextData, this.shardsVolatile.shards[i].shardOrdinalShift);
                this.shardsVolatile = new HollowSetTypeShardsHolder(this.shardsVolatile.shards, newShard, i);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                deltaData.encodedAdditions.destroy();
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, int numShards) throws IOException {
        HollowSetTypeReadState.discardType(in, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, int numShards) throws IOException {
        HollowSetTypeReadState.discardType(in, numShards, true);
    }

    public static void discardType(HollowBlobInput in, int numShards, boolean delta) throws IOException {
        HollowSetTypeDataElements.discardFromStream(in, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public int size(int ordinal) {
        int size;
        HollowSetTypeReadStateShard shard;
        HollowSetTypeShardsHolder shardsHolder;
        this.sampler.recordSize();
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            size = shard.size(ordinal >> shard.shardOrdinalShift);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return size;
    }

    @Override
    public boolean contains(int ordinal, int value) {
        return this.contains(ordinal, value, value);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean contains(int ordinal, int value, int hashCode) {
        this.sampler.recordGet();
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            startBucket = shard.dataElements.getStartBucket(shardOrdinal);
            endBucket = shard.dataElements.getEndBucket(shardOrdinal);
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            foundData = shard.foundData(hashCode, startBucket, endBucket, value);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return foundData;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int findElement(int ordinal, Object ... hashKey) {
        this.sampler.recordGet();
        if (this.keyDeriver == null) {
            return -1;
        }
        fieldTypes = this.keyDeriver.getFieldTypes();
        if (hashKey.length != fieldTypes.length) {
            return -1;
        }
        hashCode = SetMapKeyHasher.hash(hashKey, this.keyDeriver.getFieldTypes());
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            startBucket = shard.dataElements.getStartBucket(shardOrdinal);
            endBucket = shard.dataElements.getEndBucket(shardOrdinal);
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketOrdinal = shard.dataElements.getBucketValue(bucket);
            while (bucketOrdinal != shard.dataElements.emptyBucketValue && !this.readWasUnsafe(shardsHolder, ordinal, shard)) {
                if (this.keyDeriver.keyMatches(bucketOrdinal, hashKey)) {
                    return bucketOrdinal;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketOrdinal = shard.dataElements.getBucketValue(bucket);
            }
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int relativeBucketValue(int setOrdinal, int bucketIndex) {
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[setOrdinal & shardsHolder.shardNumberMask];
            startBucket = shard.dataElements.getStartBucket(setOrdinal >> shard.shardOrdinalShift);
            if (this.readWasUnsafe(shardsHolder, setOrdinal, shard)) ** GOTO lbl-1000
            value = shard.dataElements.getBucketValue(startBucket + (long)bucketIndex);
            if (value != shard.dataElements.emptyBucketValue) continue;
            value = -1;
        } while (this.readWasUnsafe(shardsHolder, setOrdinal, shard));
        return value;
    }

    @Override
    public HollowOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        this.sampler.recordGet();
        if (this.size(ordinal) == 0) {
            return EmptyOrdinalIterator.INSTANCE;
        }
        return new PotentialMatchHollowSetOrdinalIterator(ordinal, this, hashCode);
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler.recordIterator();
        if (this.size(ordinal) == 0) {
            return EmptyOrdinalIterator.INSTANCE;
        }
        return new HollowSetOrdinalIterator(ordinal, this);
    }

    private boolean readWasUnsafe(HollowSetTypeShardsHolder shardsHolder, int ordinal, HollowSetTypeReadStateShard shard) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        HollowSetTypeShardsHolder currShardsHolder = this.shardsVolatile;
        return shardsHolder != currShardsHolder && shard != currShardsHolder.shards[ordinal & currShardsHolder.shardNumberMask];
    }

    @Override
    public HollowSetSchema getSchema() {
        return (HollowSetSchema)this.schema;
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        HollowSetTypeReadStateShard[] shards = this.shardsVolatile.shards;
        int numShards = shards.length;
        HollowTypeReadStateShard[] newShards = new HollowSetTypeReadStateShard[numShards];
        for (int i = 0; i < numShards; ++i) {
            newShards[i] = new HollowSetTypeReadStateShard(null, shards[i].shardOrdinalShift);
        }
        this.shardsVolatile = new HollowSetTypeShardsHolder(newShards);
    }

    HollowSetTypeDataElements[] currentDataElements() {
        HollowSetTypeReadStateShard[] shards = this.shardsVolatile.shards;
        HollowSetTypeDataElements[] elements = new HollowSetTypeDataElements[shards.length];
        for (int i = 0; i < shards.length; ++i) {
            elements[i] = shards[i].dataElements;
        }
        return elements;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        HollowSetTypeShardsHolder shardsHolder = this.shardsVolatile;
        HollowSetTypeReadStateShard[] shards = shardsHolder.shards;
        if (!this.getSchema().equals(withSchema)) {
            throw new IllegalArgumentException("HollowSetTypeReadState cannot calculate checksum with unequal schemas: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            shards[i].applyShardToChecksum(checksum, populatedOrdinals, i, shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        HollowSetTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        HollowSetTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHoleCostInBytes += shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    public HollowPrimaryKeyValueDeriver getKeyDeriver() {
        return this.keyDeriver;
    }

    public void buildKeyDeriver() {
        if (this.getSchema().getHashKey() != null) {
            try {
                this.keyDeriver = new HollowPrimaryKeyValueDeriver(this.getSchema().getHashKey(), this.getStateEngine());
            }
            catch (FieldPaths.FieldPathException e) {
                if (e.error == FieldPaths.FieldPathException.ErrorKind.NOT_BINDABLE) {
                    LOG.log(Level.WARNING, "Failed to create a key value deriver for " + this.getSchema().getHashKey() + " because a field could not be bound to a type in the state");
                }
                throw e;
            }
        }
    }

    @Override
    public int numShards() {
        return this.shardsVolatile.shards.length;
    }
}

