/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;

class HollowSetDeltaApplicator {
    private final HollowSetTypeDataElements from;
    private final HollowSetTypeDataElements delta;
    private final HollowSetTypeDataElements target;
    private long currentFromStateCopyStartBit = 0L;
    private long currentDeltaCopyStartBit = 0L;
    private long currentWriteStartBit = 0L;
    private long currentFromStateStartBucket = 0L;
    private long currentDeltaStartBucket = 0L;
    private long currentWriteStartBucket = 0L;
    private GapEncodedVariableLengthIntegerReader removalsReader;
    private GapEncodedVariableLengthIntegerReader additionsReader;

    HollowSetDeltaApplicator(HollowSetTypeDataElements from, HollowSetTypeDataElements delta, HollowSetTypeDataElements target) {
        this.from = from;
        this.delta = delta;
        this.target = target;
    }

    public void applyDelta() {
        this.removalsReader = this.from.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : this.from.encodedRemovals;
        this.additionsReader = this.delta.encodedAdditions;
        this.removalsReader.reset();
        this.additionsReader.reset();
        this.target.encodedRemovals = this.delta.encodedRemovals;
        this.target.maxOrdinal = this.delta.maxOrdinal;
        this.target.bitsPerSetPointer = this.delta.bitsPerSetPointer;
        this.target.bitsPerSetSizeValue = this.delta.bitsPerSetSizeValue;
        this.target.bitsPerFixedLengthSetPortion = this.delta.bitsPerFixedLengthSetPortion;
        this.target.bitsPerElement = this.delta.bitsPerElement;
        this.target.emptyBucketValue = this.delta.emptyBucketValue;
        this.target.totalNumberOfBuckets = this.delta.totalNumberOfBuckets;
        this.target.setPointerAndSizeData = new FixedLengthElementArray(this.target.memoryRecycler, ((long)this.target.maxOrdinal + 1L) * (long)this.target.bitsPerFixedLengthSetPortion);
        this.target.elementData = new FixedLengthElementArray(this.target.memoryRecycler, this.target.totalNumberOfBuckets * (long)this.target.bitsPerElement);
        if (this.target.bitsPerSetPointer == this.from.bitsPerSetPointer && this.target.bitsPerSetSizeValue == this.from.bitsPerSetSizeValue && this.target.bitsPerElement == this.from.bitsPerElement) {
            this.fastDelta();
        } else {
            this.slowDelta();
        }
        this.from.encodedRemovals = null;
        this.removalsReader.destroy();
    }

    private void slowDelta() {
        for (int i = 0; i <= this.target.maxOrdinal; ++i) {
            this.mergeOrdinal(i);
        }
    }

    private void fastDelta() {
        int i = 0;
        int bulkCopyEndOrdinal = Math.min(this.from.maxOrdinal, this.target.maxOrdinal);
        while (i <= this.target.maxOrdinal) {
            int nextElementDiff = Math.min(this.additionsReader.nextElement(), this.removalsReader.nextElement());
            if (nextElementDiff == i || i > bulkCopyEndOrdinal) {
                this.mergeOrdinal(i++);
                continue;
            }
            int recordsToCopy = nextElementDiff - i;
            if (nextElementDiff > bulkCopyEndOrdinal) {
                recordsToCopy = bulkCopyEndOrdinal - i + 1;
            }
            this.fastCopyRecords(recordsToCopy);
            i += recordsToCopy;
        }
    }

    private void fastCopyRecords(int recordsToCopy) {
        long setPointerAndSizeBitsToCopy = (long)recordsToCopy * (long)this.target.bitsPerFixedLengthSetPortion;
        long eachSetPointerDifference = this.currentWriteStartBucket - this.currentFromStateStartBucket;
        this.target.setPointerAndSizeData.copyBits(this.from.setPointerAndSizeData, this.currentFromStateCopyStartBit, this.currentWriteStartBit, setPointerAndSizeBitsToCopy);
        this.target.setPointerAndSizeData.incrementMany(this.currentWriteStartBit, eachSetPointerDifference, this.target.bitsPerFixedLengthSetPortion, recordsToCopy);
        this.currentFromStateCopyStartBit += setPointerAndSizeBitsToCopy;
        this.currentWriteStartBit += setPointerAndSizeBitsToCopy;
        long fromDataEndElement = this.from.setPointerAndSizeData.getElementValue(this.currentFromStateCopyStartBit - (long)this.from.bitsPerFixedLengthSetPortion, this.from.bitsPerSetPointer);
        long bucketsToCopy = fromDataEndElement - this.currentFromStateStartBucket;
        long bitsToCopy = bucketsToCopy * (long)this.from.bitsPerElement;
        this.target.elementData.copyBits(this.from.elementData, this.currentFromStateStartBucket * (long)this.from.bitsPerElement, this.currentWriteStartBucket * (long)this.from.bitsPerElement, bitsToCopy);
        this.currentFromStateStartBucket += bucketsToCopy;
        this.currentWriteStartBucket += bucketsToCopy;
    }

    private void mergeOrdinal(int i) {
        boolean removeData;
        boolean addFromDelta = this.additionsReader.nextElement() == i;
        boolean bl = removeData = this.removalsReader.nextElement() == i;
        if (addFromDelta) {
            this.addFromDelta(this.additionsReader);
        }
        if (i <= this.from.maxOrdinal) {
            long fromDataEndBucket = this.from.setPointerAndSizeData.getElementValue(this.currentFromStateCopyStartBit, this.from.bitsPerSetPointer);
            if (!removeData) {
                for (long bucketIdx = this.currentFromStateStartBucket; bucketIdx < fromDataEndBucket; ++bucketIdx) {
                    long bucketValue = this.from.elementData.getElementValue(bucketIdx * (long)this.from.bitsPerElement, this.from.bitsPerElement);
                    if (bucketValue == (long)this.from.emptyBucketValue) {
                        bucketValue = this.target.emptyBucketValue;
                    }
                    this.target.elementData.setElementValue(this.currentWriteStartBucket * (long)this.target.bitsPerElement, this.target.bitsPerElement, bucketValue);
                    ++this.currentWriteStartBucket;
                }
                long fromDataSize = this.from.setPointerAndSizeData.getElementValue(this.currentFromStateCopyStartBit + (long)this.from.bitsPerSetPointer, this.from.bitsPerSetSizeValue);
                this.target.setPointerAndSizeData.setElementValue(this.currentWriteStartBit + (long)this.target.bitsPerSetPointer, this.target.bitsPerSetSizeValue, fromDataSize);
            } else {
                this.removalsReader.advance();
            }
            this.currentFromStateStartBucket = fromDataEndBucket;
            this.currentFromStateCopyStartBit += (long)this.from.bitsPerFixedLengthSetPortion;
        }
        this.target.setPointerAndSizeData.setElementValue(this.currentWriteStartBit, this.target.bitsPerSetPointer, this.currentWriteStartBucket);
        this.currentWriteStartBit += (long)this.target.bitsPerFixedLengthSetPortion;
    }

    private void addFromDelta(GapEncodedVariableLengthIntegerReader additionsReader) {
        long deltaDataEndBucket = this.delta.setPointerAndSizeData.getElementValue(this.currentDeltaCopyStartBit, this.delta.bitsPerSetPointer);
        for (long bucketIdx = this.currentDeltaStartBucket; bucketIdx < deltaDataEndBucket; ++bucketIdx) {
            long bucketValue = this.delta.elementData.getElementValue(bucketIdx * (long)this.delta.bitsPerElement, this.delta.bitsPerElement);
            this.target.elementData.setElementValue(this.currentWriteStartBucket * (long)this.target.bitsPerElement, this.target.bitsPerElement, bucketValue);
            ++this.currentWriteStartBucket;
        }
        long deltaDataSize = this.delta.setPointerAndSizeData.getElementValue(this.currentDeltaCopyStartBit + (long)this.delta.bitsPerSetPointer, this.delta.bitsPerSetSizeValue);
        this.target.setPointerAndSizeData.setElementValue(this.currentWriteStartBit + (long)this.target.bitsPerSetPointer, this.target.bitsPerSetSizeValue, deltaDataSize);
        this.currentDeltaStartBucket = deltaDataEndBucket;
        this.currentDeltaCopyStartBit += (long)this.delta.bitsPerFixedLengthSetPortion;
        additionsReader.advance();
    }
}

