/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;

class HollowObjectTypeReadStateShard
implements HollowTypeReadStateShard {
    private final HollowObjectSchema schema;
    final HollowObjectTypeDataElements dataElements;
    final int shardOrdinalShift;
    private static final ThreadLocal<char[]> chararr = ThreadLocal.withInitial(() -> new char[100]);

    @Override
    public HollowObjectTypeDataElements getDataElements() {
        return this.dataElements;
    }

    @Override
    public int getShardOrdinalShift() {
        return this.shardOrdinalShift;
    }

    public HollowObjectTypeReadStateShard(HollowObjectSchema schema, HollowObjectTypeDataElements dataElements, int shardOrdinalShift) {
        this.schema = schema;
        this.shardOrdinalShift = shardOrdinalShift;
        this.dataElements = dataElements;
    }

    public long readValue(int ordinal, int fieldIndex) {
        long bitOffset = this.fieldOffset(ordinal, fieldIndex);
        int numBitsForField = this.dataElements.bitsPerField[fieldIndex];
        return numBitsForField <= 56 ? this.dataElements.fixedLengthData.getElementValue(bitOffset, numBitsForField) : this.dataElements.fixedLengthData.getLargeElementValue(bitOffset, numBitsForField);
    }

    public long readOrdinal(int ordinal, int fieldIndex) {
        return this.readFixedLengthFieldValue(ordinal, fieldIndex);
    }

    public long readInt(int ordinal, int fieldIndex) {
        return this.readFixedLengthFieldValue(ordinal, fieldIndex);
    }

    public int readFloat(int ordinal, int fieldIndex) {
        return (int)this.readFixedLengthFieldValue(ordinal, fieldIndex);
    }

    public long readDouble(int ordinal, int fieldIndex) {
        long bitOffset = this.fieldOffset(ordinal, fieldIndex);
        return this.dataElements.fixedLengthData.getLargeElementValue(bitOffset, 64, -1L);
    }

    public long readLong(int ordinal, int fieldIndex) {
        long bitOffset = this.fieldOffset(ordinal, fieldIndex);
        int numBitsForField = this.dataElements.bitsPerField[fieldIndex];
        return this.dataElements.fixedLengthData.getLargeElementValue(bitOffset, numBitsForField);
    }

    public long readBoolean(int ordinal, int fieldIndex) {
        return this.readFixedLengthFieldValue(ordinal, fieldIndex);
    }

    private long readFixedLengthFieldValue(int ordinal, int fieldIndex) {
        long bitOffset = this.fieldOffset(ordinal, fieldIndex);
        int numBitsForField = this.dataElements.bitsPerField[fieldIndex];
        long value = this.dataElements.fixedLengthData.getElementValue(bitOffset, numBitsForField);
        return value;
    }

    public byte[] readBytes(long startByte, long endByte, int numBitsForField, int fieldIndex) {
        if ((endByte & 1L << numBitsForField - 1) != 0L) {
            return null;
        }
        int length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.dataElements.varLengthData[fieldIndex].get(startByte + (long)i);
        }
        return result;
    }

    public String readString(long startByte, long endByte, int numBitsForField, int fieldIndex) {
        if ((endByte & 1L << numBitsForField - 1) != 0L) {
            return null;
        }
        int length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
        return this.readString(this.dataElements.varLengthData[fieldIndex], startByte, length);
    }

    public boolean isStringFieldEqual(long startByte, long endByte, int numBitsForField, int fieldIndex, String testValue) {
        if ((endByte & 1L << numBitsForField - 1) != 0L) {
            return testValue == null;
        }
        if (testValue == null) {
            return false;
        }
        int length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
        return this.testStringEquality(this.dataElements.varLengthData[fieldIndex], startByte, length, testValue);
    }

    public int findVarLengthFieldHashCode(long startByte, long endByte, int numBitsForField, int fieldIndex) {
        if ((endByte & 1L << numBitsForField - 1) != 0L) {
            return -1;
        }
        int length = (int)(endByte - (startByte &= (1L << numBitsForField - 1) - 1L));
        return HashCodes.hashCode(this.dataElements.varLengthData[fieldIndex], startByte, length);
    }

    public int bitsRequiredForField(String fieldName) {
        int fieldIndex = this.schema.getPosition(fieldName);
        return fieldIndex == -1 ? 0 : this.dataElements.bitsPerField[fieldIndex];
    }

    long fieldOffset(int ordinal, int fieldIndex) {
        return (long)this.dataElements.bitsPerRecord * (long)ordinal + (long)this.dataElements.bitOffsetPerField[fieldIndex];
    }

    private String readString(ByteData data, long position, int length) {
        char[] chararr = HollowObjectTypeReadStateShard.chararr.get();
        if (length > chararr.length) {
            chararr = new char[length];
        } else {
            Arrays.fill(chararr, 0, length, '\u0000');
        }
        int count = VarInt.readVIntsInto(data, position, length, chararr);
        return new String(chararr, 0, count);
    }

    private boolean testStringEquality(ByteData data, long position, int length, String testValue) {
        if (length < testValue.length()) {
            return false;
        }
        long endPosition = position + (long)length;
        int count = 0;
        while (position < endPosition && count < testValue.length()) {
            int c = VarInt.readVInt(data, position);
            if (testValue.charAt(count++) != (char)c) {
                return false;
            }
            position += (long)VarInt.sizeOfVInt(c);
        }
        return position == endPosition && count == testValue.length();
    }

    protected void applyShardToChecksum(HollowChecksum checksum, HollowSchema withSchema, BitSet populatedOrdinals, int shardNumber, int shardNumberMask) {
        if (!(withSchema instanceof HollowObjectSchema)) {
            throw new IllegalArgumentException("HollowObjectTypeReadState can only calculate checksum with a HollowObjectSchema: " + this.schema.getName());
        }
        HollowObjectSchema commonSchema = this.schema.findCommonSchema((HollowObjectSchema)withSchema);
        ArrayList<String> commonFieldNames = new ArrayList<String>();
        for (int i = 0; i < commonSchema.numFields(); ++i) {
            commonFieldNames.add(commonSchema.getFieldName(i));
        }
        Collections.sort(commonFieldNames);
        int[] fieldIndexes = new int[commonFieldNames.size()];
        for (int i = 0; i < commonFieldNames.size(); ++i) {
            fieldIndexes[i] = this.schema.getPosition((String)commonFieldNames.get(i));
        }
        int ordinal = populatedOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            if ((ordinal & shardNumberMask) == shardNumber) {
                int shardOrdinal = ordinal >> this.shardOrdinalShift;
                checksum.applyInt(ordinal);
                for (int i = 0; i < fieldIndexes.length; ++i) {
                    int fieldIdx = fieldIndexes[i];
                    long bitOffset = this.fieldOffset(shardOrdinal, fieldIdx);
                    int numBitsForField = this.dataElements.bitsPerField[fieldIdx];
                    if (!this.schema.getFieldType(fieldIdx).isVariableLength()) {
                        long fixedLengthValue;
                        long l = fixedLengthValue = numBitsForField <= 56 ? this.dataElements.fixedLengthData.getElementValue(bitOffset, numBitsForField) : this.dataElements.fixedLengthData.getLargeElementValue(bitOffset, numBitsForField);
                        if (fixedLengthValue == this.dataElements.nullValueForField[fieldIdx]) {
                            checksum.applyInt(Integer.MAX_VALUE);
                            continue;
                        }
                        checksum.applyLong(fixedLengthValue);
                        continue;
                    }
                    long endByte = this.dataElements.fixedLengthData.getElementValue(bitOffset, numBitsForField);
                    long startByte = shardOrdinal != 0 ? this.dataElements.fixedLengthData.getElementValue(bitOffset - (long)this.dataElements.bitsPerRecord, numBitsForField) : 0L;
                    checksum.applyInt(this.findVarLengthFieldHashCode(startByte, endByte, numBitsForField, fieldIdx));
                }
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        long bitsPerFixedLengthData = (long)this.dataElements.bitsPerRecord * (long)(this.dataElements.maxOrdinal + 1);
        long requiredBytes = bitsPerFixedLengthData / 8L;
        for (int i = 0; i < this.dataElements.varLengthData.length; ++i) {
            if (this.dataElements.varLengthData[i] == null) continue;
            requiredBytes += this.dataElements.varLengthData[i].size();
        }
        return requiredBytes;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= this.dataElements.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)this.dataElements.bitsPerRecord;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }
}

