/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowObjectSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadStateShard;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeShardsHolder;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;

public class HollowObjectTypeReadState
extends HollowTypeReadState
implements HollowObjectTypeDataAccess {
    private final HollowObjectSchema unfilteredSchema;
    private final HollowObjectSampler sampler;
    private int maxOrdinal;
    volatile HollowObjectTypeShardsHolder shardsVolatile;

    @Override
    public HollowObjectTypeShardsHolder getShardsVolatile() {
        return this.shardsVolatile;
    }

    @Override
    public void updateShardsVolatile(HollowTypeReadStateShard[] shards) {
        this.shardsVolatile = new HollowObjectTypeShardsHolder(shards);
    }

    @Override
    public HollowTypeDataElements[] createTypeDataElements(int len) {
        return new HollowObjectTypeDataElements[len];
    }

    @Override
    public HollowTypeReadStateShard createTypeReadStateShard(HollowSchema schema, HollowTypeDataElements dataElements, int shardOrdinalShift) {
        return new HollowObjectTypeReadStateShard((HollowObjectSchema)schema, (HollowObjectTypeDataElements)dataElements, shardOrdinalShift);
    }

    public HollowObjectTypeReadState(HollowReadStateEngine fileEngine, MemoryMode memoryMode, HollowObjectSchema schema, HollowObjectSchema unfilteredSchema) {
        super(fileEngine, memoryMode, schema);
        this.sampler = new HollowObjectSampler(schema, DisabledSamplingDirector.INSTANCE);
        this.unfilteredSchema = unfilteredSchema;
        this.shardsVolatile = null;
    }

    public HollowObjectTypeReadState(HollowObjectSchema schema, HollowObjectTypeDataElements dataElements) {
        super(null, MemoryMode.ON_HEAP, schema);
        this.sampler = new HollowObjectSampler(schema, DisabledSamplingDirector.INSTANCE);
        this.unfilteredSchema = schema;
        HollowObjectTypeReadStateShard newShard = new HollowObjectTypeReadStateShard(schema, dataElements, 0);
        this.shardsVolatile = new HollowObjectTypeShardsHolder(new HollowObjectTypeReadStateShard[]{newShard});
        this.maxOrdinal = dataElements.maxOrdinal;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return (HollowObjectSchema)this.schema;
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler, int numShards) throws IOException {
        if (numShards > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        HollowTypeReadStateShard[] newShards = new HollowObjectTypeReadStateShard[numShards];
        int shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        for (int i = 0; i < numShards; ++i) {
            HollowObjectTypeDataElements shardDataElements = new HollowObjectTypeDataElements(this.getSchema(), this.memoryMode, memoryRecycler);
            shardDataElements.readSnapshot(in, this.unfilteredSchema);
            newShards[i] = new HollowObjectTypeReadStateShard(this.getSchema(), shardDataElements, shardOrdinalShift);
        }
        this.shardsVolatile = new HollowObjectTypeShardsHolder(newShards);
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema deltaSchema, ArraySegmentRecycler memoryRecycler, int deltaNumShards) throws IOException {
        if (this.shardsVolatile.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shardsVolatile.shards.length; ++i) {
            HollowObjectTypeDataElements deltaData = new HollowObjectTypeDataElements((HollowObjectSchema)deltaSchema, this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                }
                HollowObjectTypeDataElements currentData = this.shardsVolatile.shards[i].dataElements;
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowObjectTypeDataElements nextData = new HollowObjectTypeDataElements(this.getSchema(), this.memoryMode, memoryRecycler);
                HollowObjectTypeDataElements oldData = this.shardsVolatile.shards[i].dataElements;
                nextData.applyDelta(oldData, deltaData);
                HollowObjectTypeReadStateShard newShard = new HollowObjectTypeReadStateShard(this.getSchema(), nextData, this.shardsVolatile.shards[i].shardOrdinalShift);
                this.shardsVolatile = new HollowObjectTypeShardsHolder(this.shardsVolatile.shards, newShard, i);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                deltaData.encodedAdditions.destroy();
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, HollowObjectSchema schema, int numShards) throws IOException {
        HollowObjectTypeReadState.discardType(in, schema, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, HollowObjectSchema schema, int numShards) throws IOException {
        HollowObjectTypeReadState.discardType(in, schema, numShards, true);
    }

    public static void discardType(HollowBlobInput in, HollowObjectSchema schema, int numShards, boolean delta) throws IOException {
        HollowObjectTypeDataElements.discardFromInput(in, schema, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public boolean isNull(int ordinal, int fieldIndex) {
        long fixedLengthValue;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            fixedLengthValue = shard.readValue(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        switch (((HollowObjectSchema)this.schema).getFieldType(fieldIndex)) {
            case BYTES: 
            case STRING: {
                int numBits = shard.dataElements.bitsPerField[fieldIndex];
                return (fixedLengthValue & 1L << numBits - 1) != 0L;
            }
            case FLOAT: {
                return (int)fixedLengthValue == HollowObjectWriteRecord.NULL_FLOAT_BITS;
            }
            case DOUBLE: {
                return fixedLengthValue == HollowObjectWriteRecord.NULL_DOUBLE_BITS;
            }
        }
        return fixedLengthValue == shard.dataElements.nullValueForField[fieldIndex];
    }

    @Override
    public int readOrdinal(int ordinal, int fieldIndex) {
        long refOrdinal;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            refOrdinal = shard.readOrdinal(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        if (refOrdinal == shard.dataElements.nullValueForField[fieldIndex]) {
            return -1;
        }
        return (int)refOrdinal;
    }

    @Override
    public int readInt(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            value = shard.readInt(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        if (value == shard.dataElements.nullValueForField[fieldIndex]) {
            return Integer.MIN_VALUE;
        }
        return ZigZag.decodeInt((int)value);
    }

    @Override
    public float readFloat(int ordinal, int fieldIndex) {
        int value;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            value = shard.readFloat(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        if (value == HollowObjectWriteRecord.NULL_FLOAT_BITS) {
            return Float.NaN;
        }
        return Float.intBitsToFloat(value);
    }

    @Override
    public double readDouble(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            value = shard.readDouble(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        if (value == HollowObjectWriteRecord.NULL_DOUBLE_BITS) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(value);
    }

    @Override
    public long readLong(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            value = shard.readLong(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        if (value == shard.dataElements.nullValueForField[fieldIndex]) {
            return Long.MIN_VALUE;
        }
        return ZigZag.decodeLong(value);
    }

    @Override
    public Boolean readBoolean(int ordinal, int fieldIndex) {
        long value;
        HollowObjectTypeReadStateShard shard;
        HollowObjectTypeShardsHolder shardsHolder;
        this.sampler.recordFieldAccess(fieldIndex);
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            value = shard.readBoolean(ordinal >> shard.shardOrdinalShift, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        if (value == shard.dataElements.nullValueForField[fieldIndex]) {
            return null;
        }
        return value == 1L ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] readBytes(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            numBitsForField = shard.dataElements.bitsPerField[fieldIndex];
            currentBitOffset = shard.fieldOffset(shardOrdinal, fieldIndex);
            endByte = shard.dataElements.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = shardOrdinal != 0 ? shard.dataElements.fixedLengthData.getElementValue(currentBitOffset - (long)shard.dataElements.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            result = shard.readBytes(startByte, endByte, numBitsForField, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String readString(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            numBitsForField = shard.dataElements.bitsPerField[fieldIndex];
            currentBitOffset = shard.fieldOffset(shardOrdinal, fieldIndex);
            endByte = shard.dataElements.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = shardOrdinal != 0 ? shard.dataElements.fixedLengthData.getElementValue(currentBitOffset - (long)shard.dataElements.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            result = shard.readString(startByte, endByte, numBitsForField, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isStringFieldEqual(int ordinal, int fieldIndex, String testValue) {
        this.sampler.recordFieldAccess(fieldIndex);
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            numBitsForField = shard.dataElements.bitsPerField[fieldIndex];
            currentBitOffset = shard.fieldOffset(shardOrdinal, fieldIndex);
            endByte = shard.dataElements.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = shardOrdinal != 0 ? shard.dataElements.fixedLengthData.getElementValue(currentBitOffset - (long)shard.dataElements.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            result = shard.isStringFieldEqual(startByte, endByte, numBitsForField, fieldIndex, testValue);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int findVarLengthFieldHashCode(int ordinal, int fieldIndex) {
        this.sampler.recordFieldAccess(fieldIndex);
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            numBitsForField = shard.dataElements.bitsPerField[fieldIndex];
            currentBitOffset = shard.fieldOffset(shardOrdinal, fieldIndex);
            endByte = shard.dataElements.fixedLengthData.getElementValue(currentBitOffset, numBitsForField);
            v0 = startByte = shardOrdinal != 0 ? shard.dataElements.fixedLengthData.getElementValue(currentBitOffset - (long)shard.dataElements.bitsPerRecord, numBitsForField) : 0L;
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            hashCode = shard.findVarLengthFieldHashCode(startByte, endByte, numBitsForField, fieldIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return hashCode;
    }

    private boolean readWasUnsafe(HollowObjectTypeShardsHolder shardsHolder, int ordinal, HollowObjectTypeReadStateShard shard) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        HollowObjectTypeShardsHolder currShardsHolder = this.shardsVolatile;
        return shardsHolder != currShardsHolder && shard != currShardsHolder.shards[ordinal & currShardsHolder.shardNumberMask];
    }

    public int bitsRequiredForField(String fieldName) {
        HollowObjectTypeReadStateShard[] shards = this.shardsVolatile.shards;
        int maxBitsRequiredForField = shards[0].bitsRequiredForField(fieldName);
        for (int i = 1; i < shards.length; ++i) {
            int shardRequiredBits = shards[i].bitsRequiredForField(fieldName);
            if (shardRequiredBits <= maxBitsRequiredForField) continue;
            maxBitsRequiredForField = shardRequiredBits;
        }
        return maxBitsRequiredForField;
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        HollowObjectTypeReadStateShard[] shards = this.shardsVolatile.shards;
        int numShards = shards.length;
        HollowTypeReadStateShard[] newShards = new HollowObjectTypeReadStateShard[numShards];
        for (int i = 0; i < numShards; ++i) {
            newShards[i] = new HollowObjectTypeReadStateShard(this.getSchema(), null, shards[i].shardOrdinalShift);
        }
        this.shardsVolatile = new HollowObjectTypeShardsHolder(newShards);
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    HollowObjectTypeDataElements[] currentDataElements() {
        HollowObjectTypeReadStateShard[] shards = this.shardsVolatile.shards;
        HollowObjectTypeDataElements[] elements = new HollowObjectTypeDataElements[shards.length];
        for (int i = 0; i < shards.length; ++i) {
            elements[i] = shards[i].dataElements;
        }
        return elements;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        HollowObjectTypeShardsHolder shardsHolder = this.shardsVolatile;
        HollowObjectTypeReadStateShard[] shards = shardsHolder.shards;
        int shardNumberMask = shardsHolder.shardNumberMask;
        if (!(withSchema instanceof HollowObjectSchema)) {
            throw new IllegalArgumentException("HollowObjectTypeReadState can only calculate checksum with a HollowObjectSchema: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            shards[i].applyShardToChecksum(checksum, withSchema, populatedOrdinals, i, shardNumberMask);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        HollowObjectTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        HollowObjectTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHoleCostInBytes += shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    @Override
    public int numShards() {
        return this.shardsVolatile.shards.length;
    }
}

