/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeShardsHolder;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;
import java.util.Arrays;

public class HollowObjectDeltaHistoricalStateCreator {
    private final HollowObjectTypeDataElements historicalDataElements;
    private HollowObjectTypeReadState typeState;
    private HollowObjectTypeShardsHolder shardsHolder;
    private RemovedOrdinalIterator iter;
    private IntMap ordinalMapping;
    private int nextOrdinal;
    private final long[] currentWriteVarLengthDataPointers;

    public HollowObjectDeltaHistoricalStateCreator(HollowObjectTypeReadState typeState, boolean reverse) {
        this.typeState = typeState;
        this.historicalDataElements = new HollowObjectTypeDataElements(typeState.getSchema(), (ArraySegmentRecycler)WastefulRecycler.DEFAULT_INSTANCE);
        this.iter = new RemovedOrdinalIterator(typeState.getListener(PopulatedOrdinalListener.class), reverse);
        this.currentWriteVarLengthDataPointers = new long[typeState.getSchema().numFields()];
        this.shardsHolder = typeState.shardsVolatile;
    }

    public void populateHistory() {
        this.populateStats();
        this.historicalDataElements.fixedLengthData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, (long)this.historicalDataElements.bitsPerRecord * (long)(this.historicalDataElements.maxOrdinal + 1));
        for (int i = 0; i < this.historicalDataElements.schema.numFields(); ++i) {
            if (!this.isVarLengthField(this.typeState.getSchema().getFieldType(i))) continue;
            this.historicalDataElements.varLengthData[i] = new SegmentedByteArray(this.historicalDataElements.memoryRecycler);
        }
        this.iter.reset();
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            this.ordinalMapping.put(ordinal, this.nextOrdinal);
            int whichShard = ordinal & this.shardsHolder.shardNumberMask;
            int shardOrdinal = ordinal >> this.shardsHolder.shards[whichShard].shardOrdinalShift;
            HollowObjectTypeDataElements.copyRecord(this.historicalDataElements, this.nextOrdinal, this.shardsHolder.shards[whichShard].dataElements, shardOrdinal, this.currentWriteVarLengthDataPointers);
            ++this.nextOrdinal;
            ordinal = this.iter.next();
        }
    }

    public void dereferenceTypeState() {
        this.typeState = null;
        this.shardsHolder = null;
        this.iter = null;
    }

    public IntMap getOrdinalMapping() {
        return this.ordinalMapping;
    }

    public HollowObjectTypeReadState createHistoricalTypeReadState() {
        HollowObjectTypeReadState historicalTypeState = new HollowObjectTypeReadState(this.typeState.getSchema(), this.historicalDataElements);
        return historicalTypeState;
    }

    private void populateStats() {
        int i;
        this.iter.reset();
        int removedEntryCount = 0;
        long[] totalVarLengthSizes = new long[this.typeState.getSchema().numFields()];
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            ++removedEntryCount;
            for (i = 0; i < this.typeState.getSchema().numFields(); ++i) {
                if (!this.isVarLengthField(this.typeState.getSchema().getFieldType(i))) continue;
                int whichShard = ordinal & this.shardsHolder.shardNumberMask;
                int shardOrdinal = ordinal >> this.shardsHolder.shards[whichShard].shardOrdinalShift;
                int n = i;
                totalVarLengthSizes[n] = totalVarLengthSizes[n] + HollowObjectTypeDataElements.varLengthSize(this.shardsHolder.shards[whichShard].dataElements, shardOrdinal, i);
            }
            ordinal = this.iter.next();
        }
        this.historicalDataElements.maxOrdinal = removedEntryCount - 1;
        for (i = 0; i < this.typeState.getSchema().numFields(); ++i) {
            if (!this.isVarLengthField(this.typeState.getSchema().getFieldType(i))) {
                int fieldIdx = i;
                this.historicalDataElements.bitsPerField[i] = Arrays.stream(this.shardsHolder.shards).map(shard -> shard.dataElements.bitsPerField[fieldIdx]).max(Integer::compare).get();
            } else {
                this.historicalDataElements.bitsPerField[i] = 64 - Long.numberOfLeadingZeros(totalVarLengthSizes[i] + 1L) + 1;
            }
            this.historicalDataElements.nullValueForField[i] = this.historicalDataElements.bitsPerField[i] == 64 ? -1L : (1L << this.historicalDataElements.bitsPerField[i]) - 1L;
            this.historicalDataElements.bitOffsetPerField[i] = this.historicalDataElements.bitsPerRecord;
            this.historicalDataElements.bitsPerRecord += this.historicalDataElements.bitsPerField[i];
        }
        this.ordinalMapping = new IntMap(removedEntryCount);
    }

    private boolean isVarLengthField(HollowObjectSchema.FieldType fieldType) {
        return fieldType == HollowObjectSchema.FieldType.STRING || fieldType == HollowObjectSchema.FieldType.BYTES;
    }
}

