/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.BitSet;

class HollowMapTypeReadStateShard
implements HollowTypeReadStateShard {
    final HollowMapTypeDataElements dataElements;
    final int shardOrdinalShift;

    @Override
    public HollowMapTypeDataElements getDataElements() {
        return this.dataElements;
    }

    @Override
    public int getShardOrdinalShift() {
        return this.shardOrdinalShift;
    }

    public HollowMapTypeReadStateShard(HollowMapTypeDataElements dataElements, int shardOrdinalShift) {
        this.shardOrdinalShift = shardOrdinalShift;
        this.dataElements = dataElements;
    }

    public int size(int ordinal) {
        int size = (int)this.dataElements.mapPointerAndSizeData.getElementValue((long)ordinal * (long)this.dataElements.bitsPerFixedLengthMapPortion + (long)this.dataElements.bitsPerMapPointer, this.dataElements.bitsPerMapSizeValue);
        return size;
    }

    int get(int hashCode, long startBucket, long endBucket, int keyOrdinal) {
        hashCode = HashCodes.hashInt(hashCode);
        long bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
        int bucketKeyOrdinal = this.dataElements.getBucketKeyByAbsoluteIndex(bucket);
        while (bucketKeyOrdinal != this.dataElements.emptyBucketKeyValue) {
            if (bucketKeyOrdinal == keyOrdinal) {
                return this.dataElements.getBucketValueByAbsoluteIndex(bucket);
            }
            if (++bucket == endBucket) {
                bucket = startBucket;
            }
            bucketKeyOrdinal = this.dataElements.getBucketKeyByAbsoluteIndex(bucket);
        }
        return -1;
    }

    public long relativeBucket(long absoluteBucketIndex) {
        long key = this.dataElements.getBucketKeyByAbsoluteIndex(absoluteBucketIndex);
        if (key == (long)this.dataElements.emptyBucketKeyValue) {
            return -1L;
        }
        long bucketValue = key << 32 | (long)this.dataElements.getBucketValueByAbsoluteIndex(absoluteBucketIndex);
        return bucketValue;
    }

    protected void applyShardToChecksum(HollowChecksum checksum, BitSet populatedOrdinals, int shardNumber, int numShards) {
        int ordinal = populatedOrdinals.nextSetBit(shardNumber);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                int numBuckets = HashCodes.hashTableSize(this.size(shardOrdinal));
                long offset = this.dataElements.getStartBucket(shardOrdinal);
                checksum.applyInt(ordinal);
                for (int i = 0; i < numBuckets; ++i) {
                    int bucketKey = this.dataElements.getBucketKeyByAbsoluteIndex(offset + (long)i);
                    if (bucketKey == this.dataElements.emptyBucketKeyValue) continue;
                    checksum.applyInt(i);
                    checksum.applyInt(bucketKey);
                    checksum.applyInt(this.dataElements.getBucketValueByAbsoluteIndex(offset + (long)i));
                }
                ordinal += numShards;
            } else {
                int r = (ordinal & -numShards) + shardNumber;
                ordinal = r <= ordinal ? r + numShards : r;
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal);
        }
    }

    public long getApproximateHeapFootprintInBytes() {
        long requiredBitsForMapPointers = ((long)this.dataElements.maxOrdinal + 1L) * (long)this.dataElements.bitsPerFixedLengthMapPortion;
        long requiredBitsForMapBuckets = this.dataElements.totalNumberOfBuckets * (long)this.dataElements.bitsPerMapEntry;
        long requiredBits = requiredBitsForMapPointers + requiredBitsForMapBuckets;
        return requiredBits / 8L;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= this.dataElements.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)this.dataElements.bitsPerFixedLengthMapPortion;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }
}

