/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsSplitter;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;

public class HollowMapTypeDataElementsSplitter
extends HollowTypeDataElementsSplitter<HollowMapTypeDataElements> {
    public HollowMapTypeDataElementsSplitter(HollowMapTypeDataElements from, int numSplits) {
        super(from, numSplits);
    }

    @Override
    public void initToElements() {
        this.to = new HollowMapTypeDataElements[this.numSplits];
        for (int i = 0; i < ((HollowMapTypeDataElements[])this.to).length; ++i) {
            ((HollowMapTypeDataElements[])this.to)[i] = new HollowMapTypeDataElements(((HollowMapTypeDataElements)this.from).memoryMode, ((HollowMapTypeDataElements)this.from).memoryRecycler);
        }
    }

    @Override
    public void populateStats() {
        long[] shardTotalOfMapBuckets = new long[this.numSplits];
        long maxShardTotalOfMapBuckets = 0L;
        for (int ordinal = 0; ordinal <= ((HollowMapTypeDataElements)this.from).maxOrdinal; ++ordinal) {
            int toOrdinal;
            int toIndex = ordinal & this.toMask;
            ((HollowMapTypeDataElements[])this.to)[toIndex].maxOrdinal = toOrdinal = ordinal >> this.toOrdinalShift;
            long startBucket = ((HollowMapTypeDataElements)this.from).getStartBucket(ordinal);
            long endBucket = ((HollowMapTypeDataElements)this.from).getEndBucket(ordinal);
            long numBuckets = endBucket - startBucket;
            int n = toIndex;
            shardTotalOfMapBuckets[n] = shardTotalOfMapBuckets[n] + numBuckets;
            if (shardTotalOfMapBuckets[toIndex] <= maxShardTotalOfMapBuckets) continue;
            maxShardTotalOfMapBuckets = shardTotalOfMapBuckets[toIndex];
        }
        for (int toIndex = 0; toIndex < this.numSplits; ++toIndex) {
            HollowMapTypeDataElements target = ((HollowMapTypeDataElements[])this.to)[toIndex];
            target.bitsPerKeyElement = ((HollowMapTypeDataElements)this.from).bitsPerKeyElement;
            target.bitsPerValueElement = ((HollowMapTypeDataElements)this.from).bitsPerValueElement;
            target.bitsPerMapSizeValue = ((HollowMapTypeDataElements)this.from).bitsPerMapSizeValue;
            target.emptyBucketKeyValue = ((HollowMapTypeDataElements)this.from).emptyBucketKeyValue;
            target.bitsPerMapPointer = 64 - Long.numberOfLeadingZeros(maxShardTotalOfMapBuckets);
            target.totalNumberOfBuckets = shardTotalOfMapBuckets[toIndex];
            target.bitsPerFixedLengthMapPortion = target.bitsPerMapSizeValue + target.bitsPerMapPointer;
            target.bitsPerMapEntry = target.bitsPerKeyElement + target.bitsPerValueElement;
        }
    }

    @Override
    public void copyRecords() {
        int numSplits = ((HollowMapTypeDataElements[])this.to).length;
        long[] bucketCounter = new long[numSplits];
        for (int toIndex = 0; toIndex < numSplits; ++toIndex) {
            HollowMapTypeDataElements target = ((HollowMapTypeDataElements[])this.to)[toIndex];
            target.mapPointerAndSizeData = FixedLengthDataFactory.get((long)(target.maxOrdinal + 1) * (long)target.bitsPerFixedLengthMapPortion, target.memoryMode, target.memoryRecycler);
            target.entryData = FixedLengthDataFactory.get(target.totalNumberOfBuckets * (long)target.bitsPerMapEntry, target.memoryMode, target.memoryRecycler);
        }
        for (int ordinal = 0; ordinal <= ((HollowMapTypeDataElements)this.from).maxOrdinal; ++ordinal) {
            int toIndex = ordinal & this.toMask;
            int toOrdinal = ordinal >> this.toOrdinalShift;
            HollowMapTypeDataElements target = ((HollowMapTypeDataElements[])this.to)[toIndex];
            long startBucket = ((HollowMapTypeDataElements)this.from).getStartBucket(ordinal);
            long endBucket = ((HollowMapTypeDataElements)this.from).getEndBucket(ordinal);
            long numBuckets = endBucket - startBucket;
            target.copyBucketsFrom(bucketCounter[toIndex], (HollowMapTypeDataElements)this.from, startBucket, endBucket);
            int n = toIndex;
            bucketCounter[n] = bucketCounter[n] + numBuckets;
            target.mapPointerAndSizeData.setElementValue((long)toOrdinal * (long)target.bitsPerFixedLengthMapPortion, target.bitsPerMapPointer, bucketCounter[toIndex]);
            long mapSize = ((HollowMapTypeDataElements)this.from).mapPointerAndSizeData.getElementValue((long)ordinal * (long)((HollowMapTypeDataElements)this.from).bitsPerFixedLengthMapPortion + (long)((HollowMapTypeDataElements)this.from).bitsPerMapPointer, ((HollowMapTypeDataElements)this.from).bitsPerMapSizeValue);
            target.mapPointerAndSizeData.setElementValue((long)toOrdinal * (long)target.bitsPerFixedLengthMapPortion + (long)target.bitsPerMapPointer, target.bitsPerMapSizeValue, mapSize);
        }
    }
}

