/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsJoiner;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;

class HollowMapTypeDataElementsJoiner
extends HollowTypeDataElementsJoiner<HollowMapTypeDataElements> {
    public HollowMapTypeDataElementsJoiner(HollowMapTypeDataElements[] from) {
        super((HollowTypeDataElements[])from);
    }

    @Override
    public void initToElements() {
        this.to = new HollowMapTypeDataElements(((HollowMapTypeDataElements[])this.from)[0].memoryMode, ((HollowMapTypeDataElements[])this.from)[0].memoryRecycler);
    }

    @Override
    public void populateStats() {
        for (int fromIndex = 0; fromIndex < ((HollowMapTypeDataElements[])this.from).length; ++fromIndex) {
            int mappedMaxOrdinal = ((HollowMapTypeDataElements[])this.from)[fromIndex].maxOrdinal == -1 ? -1 : ((HollowMapTypeDataElements[])this.from)[fromIndex].maxOrdinal * ((HollowMapTypeDataElements[])this.from).length + fromIndex;
            ((HollowMapTypeDataElements)this.to).maxOrdinal = Math.max(((HollowMapTypeDataElements)this.to).maxOrdinal, mappedMaxOrdinal);
            HollowMapTypeDataElements source = ((HollowMapTypeDataElements[])this.from)[fromIndex];
            if (source.bitsPerKeyElement > ((HollowMapTypeDataElements)this.to).bitsPerKeyElement) {
                ((HollowMapTypeDataElements)this.to).bitsPerKeyElement = source.bitsPerKeyElement;
            }
            if (source.bitsPerValueElement > ((HollowMapTypeDataElements)this.to).bitsPerValueElement) {
                ((HollowMapTypeDataElements)this.to).bitsPerValueElement = source.bitsPerValueElement;
            }
            if (source.bitsPerMapSizeValue <= ((HollowMapTypeDataElements)this.to).bitsPerMapSizeValue) continue;
            ((HollowMapTypeDataElements)this.to).bitsPerMapSizeValue = source.bitsPerMapSizeValue;
        }
        ((HollowMapTypeDataElements)this.to).emptyBucketKeyValue = (1 << ((HollowMapTypeDataElements)this.to).bitsPerKeyElement) - 1;
        long totalOfMapBuckets = 0L;
        for (int ordinal = 0; ordinal <= ((HollowMapTypeDataElements)this.to).maxOrdinal; ++ordinal) {
            int fromIndex = ordinal & this.fromMask;
            int fromOrdinal = ordinal >> this.fromOrdinalShift;
            if (fromOrdinal > ((HollowMapTypeDataElements[])this.from)[fromIndex].maxOrdinal) continue;
            HollowMapTypeDataElements source = ((HollowMapTypeDataElements[])this.from)[fromIndex];
            long startBucket = source.getStartBucket(fromOrdinal);
            long endBucket = source.getEndBucket(fromOrdinal);
            long numBuckets = endBucket - startBucket;
            totalOfMapBuckets += numBuckets;
        }
        ((HollowMapTypeDataElements)this.to).totalNumberOfBuckets = totalOfMapBuckets;
        ((HollowMapTypeDataElements)this.to).bitsPerMapPointer = 64 - Long.numberOfLeadingZeros(((HollowMapTypeDataElements)this.to).totalNumberOfBuckets);
        ((HollowMapTypeDataElements)this.to).bitsPerFixedLengthMapPortion = ((HollowMapTypeDataElements)this.to).bitsPerMapSizeValue + ((HollowMapTypeDataElements)this.to).bitsPerMapPointer;
        ((HollowMapTypeDataElements)this.to).bitsPerMapEntry = ((HollowMapTypeDataElements)this.to).bitsPerKeyElement + ((HollowMapTypeDataElements)this.to).bitsPerValueElement;
    }

    @Override
    public void copyRecords() {
        long bucketCounter = 0L;
        ((HollowMapTypeDataElements)this.to).mapPointerAndSizeData = FixedLengthDataFactory.get((long)(((HollowMapTypeDataElements)this.to).maxOrdinal + 1) * (long)((HollowMapTypeDataElements)this.to).bitsPerFixedLengthMapPortion, ((HollowMapTypeDataElements)this.to).memoryMode, ((HollowMapTypeDataElements)this.to).memoryRecycler);
        ((HollowMapTypeDataElements)this.to).entryData = FixedLengthDataFactory.get(((HollowMapTypeDataElements)this.to).totalNumberOfBuckets * (long)((HollowMapTypeDataElements)this.to).bitsPerMapEntry, ((HollowMapTypeDataElements)this.to).memoryMode, ((HollowMapTypeDataElements)this.to).memoryRecycler);
        for (int ordinal = 0; ordinal <= ((HollowMapTypeDataElements)this.to).maxOrdinal; ++ordinal) {
            int fromIndex = ordinal & this.fromMask;
            int fromOrdinal = ordinal >> this.fromOrdinalShift;
            HollowMapTypeDataElements source = ((HollowMapTypeDataElements[])this.from)[fromIndex];
            long mapSize = 0L;
            if (fromOrdinal <= ((HollowMapTypeDataElements[])this.from)[fromIndex].maxOrdinal) {
                long startBucket = source.getStartBucket(fromOrdinal);
                long endBucket = source.getEndBucket(fromOrdinal);
                long numBuckets = endBucket - startBucket;
                ((HollowMapTypeDataElements)this.to).copyBucketsFrom(bucketCounter, source, startBucket, endBucket);
                bucketCounter += numBuckets;
                mapSize = source.mapPointerAndSizeData.getElementValue((long)fromOrdinal * (long)source.bitsPerFixedLengthMapPortion + (long)source.bitsPerMapPointer, source.bitsPerMapSizeValue);
            }
            ((HollowMapTypeDataElements)this.to).mapPointerAndSizeData.setElementValue((long)ordinal * (long)((HollowMapTypeDataElements)this.to).bitsPerFixedLengthMapPortion, ((HollowMapTypeDataElements)this.to).bitsPerMapPointer, bucketCounter);
            ((HollowMapTypeDataElements)this.to).mapPointerAndSizeData.setElementValue((long)ordinal * (long)((HollowMapTypeDataElements)this.to).bitsPerFixedLengthMapPortion + (long)((HollowMapTypeDataElements)this.to).bitsPerMapPointer, ((HollowMapTypeDataElements)this.to).bitsPerMapSizeValue, mapSize);
        }
    }
}

