/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowListSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.ShardsHolder;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadStateShard;
import com.netflix.hollow.core.read.engine.list.HollowListTypeShardsHolder;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.HollowListOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;

public class HollowListTypeReadState
extends HollowCollectionTypeReadState
implements HollowListTypeDataAccess {
    private final HollowListSampler sampler;
    private int maxOrdinal;
    volatile HollowListTypeShardsHolder shardsVolatile;

    @Override
    public ShardsHolder getShardsVolatile() {
        return this.shardsVolatile;
    }

    @Override
    public void updateShardsVolatile(HollowTypeReadStateShard[] shards) {
        this.shardsVolatile = new HollowListTypeShardsHolder(shards);
    }

    @Override
    public HollowTypeDataElements[] createTypeDataElements(int len) {
        return new HollowListTypeDataElements[len];
    }

    @Override
    public HollowTypeReadStateShard createTypeReadStateShard(HollowSchema schema, HollowTypeDataElements dataElements, int shardOrdinalShift) {
        return new HollowListTypeReadStateShard((HollowListTypeDataElements)dataElements, shardOrdinalShift);
    }

    public HollowListTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowListSchema schema) {
        super(stateEngine, memoryMode, schema);
        this.sampler = new HollowListSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        this.shardsVolatile = null;
    }

    public HollowListTypeReadState(HollowListSchema schema, HollowListTypeDataElements dataElements) {
        super(null, MemoryMode.ON_HEAP, schema);
        this.sampler = new HollowListSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        HollowListTypeReadStateShard newShard = new HollowListTypeReadStateShard(dataElements, 0);
        this.shardsVolatile = new HollowListTypeShardsHolder(new HollowListTypeReadStateShard[]{newShard});
        this.maxOrdinal = dataElements.maxOrdinal;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler, int numShards) throws IOException {
        if (numShards > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        HollowTypeReadStateShard[] newShards = new HollowListTypeReadStateShard[numShards];
        int shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        for (int i = 0; i < numShards; ++i) {
            HollowListTypeDataElements shardDataElements = new HollowListTypeDataElements(this.memoryMode, memoryRecycler);
            shardDataElements.readSnapshot(in);
            newShards[i] = new HollowListTypeReadStateShard(shardDataElements, shardOrdinalShift);
        }
        this.shardsVolatile = new HollowListTypeShardsHolder(newShards);
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema schema, ArraySegmentRecycler memoryRecycler, int deltaNumShards) throws IOException {
        if (this.shardsVolatile.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shardsVolatile.shards.length; ++i) {
            HollowListTypeDataElements deltaData = new HollowListTypeDataElements(this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                }
                HollowListTypeDataElements currentData = this.shardsVolatile.shards[i].dataElements;
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowListTypeDataElements nextData = new HollowListTypeDataElements(this.memoryMode, memoryRecycler);
                HollowListTypeDataElements oldData = this.shardsVolatile.shards[i].dataElements;
                nextData.applyDelta(oldData, deltaData);
                HollowListTypeReadStateShard newShard = new HollowListTypeReadStateShard(nextData, this.shardsVolatile.shards[i].shardOrdinalShift);
                this.shardsVolatile = new HollowListTypeShardsHolder(this.shardsVolatile.shards, newShard, i);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                deltaData.encodedAdditions.destroy();
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, int numShards) throws IOException {
        HollowListTypeReadState.discardType(in, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, int numShards) throws IOException {
        HollowListTypeReadState.discardType(in, numShards, true);
    }

    public static void discardType(HollowBlobInput in, int numShards, boolean delta) throws IOException {
        HollowListTypeDataElements.discardFromStream(in, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public HollowListSchema getSchema() {
        return (HollowListSchema)this.schema;
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int getElementOrdinal(int ordinal, int listIndex) {
        this.sampler.recordGet();
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            startElement = shard.dataElements.getStartElement(shardOrdinal);
            endElement = shard.dataElements.getEndElement(shardOrdinal);
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            elementOrdinal = shard.getElementOrdinal(startElement, endElement, listIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return elementOrdinal;
    }

    @Override
    public int size(int ordinal) {
        int size;
        HollowListTypeReadStateShard shard;
        HollowListTypeShardsHolder shardsHolder;
        this.sampler.recordSize();
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            size = shard.size(ordinal >> shard.shardOrdinalShift);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return size;
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler.recordIterator();
        return new HollowListOrdinalIterator(ordinal, this);
    }

    private boolean readWasUnsafe(HollowListTypeShardsHolder shardsHolder, int ordinal, HollowListTypeReadStateShard shard) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        HollowListTypeShardsHolder currShardsHolder = this.shardsVolatile;
        return shardsHolder != currShardsHolder && shard != currShardsHolder.shards[ordinal & currShardsHolder.shardNumberMask];
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        HollowListTypeReadStateShard[] shards = this.shardsVolatile.shards;
        int numShards = shards.length;
        HollowTypeReadStateShard[] newShards = new HollowListTypeReadStateShard[numShards];
        for (int i = 0; i < numShards; ++i) {
            newShards[i] = new HollowListTypeReadStateShard(null, shards[i].shardOrdinalShift);
        }
        this.shardsVolatile = new HollowListTypeShardsHolder(newShards);
    }

    HollowListTypeDataElements[] currentDataElements() {
        HollowListTypeReadStateShard[] shards = this.shardsVolatile.shards;
        HollowListTypeDataElements[] elements = new HollowListTypeDataElements[shards.length];
        for (int i = 0; i < shards.length; ++i) {
            elements[i] = shards[i].dataElements;
        }
        return elements;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        HollowListTypeReadStateShard[] shards = this.shardsVolatile.shards;
        if (!this.getSchema().equals(withSchema)) {
            throw new IllegalArgumentException("HollowListTypeReadState cannot calculate checksum with unequal schemas: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            shards[i].applyShardToChecksum(checksum, populatedOrdinals, i, shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        HollowListTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        HollowListTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHoleCostInBytes += shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    @Override
    public int numShards() {
        return this.shardsVolatile.shards.length;
    }
}

