/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;

public abstract class HollowTypeDataElementsJoiner<T extends HollowTypeDataElements> {
    public final int fromMask;
    public final int fromOrdinalShift;
    public final T[] from;
    public T to;

    public HollowTypeDataElementsJoiner(T[] from) {
        this.from = from;
        this.fromMask = from.length - 1;
        this.fromOrdinalShift = 31 - Integer.numberOfLeadingZeros(from.length);
        if (from.length <= 0 || (from.length & from.length - 1) != 0) {
            throw new IllegalStateException("No. of DataElements to be joined must be a power of 2");
        }
        for (int i = 0; i < from.length; ++i) {
            if (((HollowTypeDataElements)from[i]).maxOrdinal == -1 || ((HollowTypeDataElements)from[i]).maxOrdinal <= 0x20000000 && (((HollowTypeDataElements)from[i]).maxOrdinal == 0 || from.length <= 0x20000000 / ((HollowTypeDataElements)from[i]).maxOrdinal) && ((HollowTypeDataElements)from[i]).maxOrdinal * from.length + i <= 0x20000000) continue;
            throw new IllegalArgumentException("Too large to join, maxOrdinal would exceed 2<<29");
        }
        for (T elements : from) {
            if (((HollowTypeDataElements)elements).encodedAdditions == null) continue;
            throw new IllegalStateException("Encountered encodedAdditions in data elements joiner- this is not expected since encodedAdditions only exist on delta data elements and they dont carry over to target data elements, delta data elements are never split/joined");
        }
    }

    public T join() {
        this.initToElements();
        ((HollowTypeDataElements)this.to).maxOrdinal = -1;
        this.populateStats();
        this.copyRecords();
        GapEncodedVariableLengthIntegerReader[] fromRemovals = new GapEncodedVariableLengthIntegerReader[this.from.length];
        for (int i = 0; i < this.from.length; ++i) {
            fromRemovals[i] = ((HollowTypeDataElements)this.from[i]).encodedRemovals;
        }
        ((HollowTypeDataElements)this.to).encodedRemovals = GapEncodedVariableLengthIntegerReader.join(fromRemovals);
        return this.to;
    }

    public abstract void initToElements();

    public abstract void populateStats();

    public abstract void copyRecords();
}

