/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.dataaccess.missing;

import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSetSampler;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowSetSchema;

public class HollowSetMissingDataAccess
implements HollowSetTypeDataAccess {
    private final HollowDataAccess dataAccess;
    private final String typeName;

    public HollowSetMissingDataAccess(HollowDataAccess dataAccess, String typeName) {
        this.dataAccess = dataAccess;
        this.typeName = typeName;
    }

    @Override
    public HollowDataAccess getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowSetSchema getSchema() {
        return (HollowSetSchema)this.missingDataHandler().handleSchema(this.typeName);
    }

    @Override
    public int size(int ordinal) {
        return this.missingDataHandler().handleSetSize(this.typeName, ordinal);
    }

    @Override
    public boolean contains(int ordinal, int elementOrdinal) {
        return this.missingDataHandler().handleSetContainsElement(this.typeName, ordinal, elementOrdinal, elementOrdinal);
    }

    @Override
    public boolean contains(int ordinal, int elementOrdinal, int hashCode) {
        return this.missingDataHandler().handleSetContainsElement(this.typeName, ordinal, elementOrdinal, hashCode);
    }

    @Override
    public int findElement(int ordinal, Object ... hashKey) {
        return this.missingDataHandler().handleSetFindElement(this.typeName, ordinal, hashKey);
    }

    @Override
    public int relativeBucketValue(int ordinal, int bucketIndex) {
        throw new UnsupportedOperationException("Set type " + this.typeName + " is missing, but an attempt was made to access relative bucket values");
    }

    @Override
    public HollowOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        return this.missingDataHandler().handleSetPotentialMatchIterator(this.typeName, ordinal, hashCode);
    }

    @Override
    public HollowOrdinalIterator ordinalIterator(int ordinal) {
        return this.missingDataHandler().handleSetIterator(this.typeName, ordinal);
    }

    MissingDataHandler missingDataHandler() {
        return this.dataAccess.getMissingDataHandler();
    }

    @Override
    public HollowTypeReadState getTypeState() {
        throw new UnsupportedOperationException("No HollowTypeReadState exists for " + this.typeName);
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
    }

    @Override
    public HollowSampler getSampler() {
        return HollowSetSampler.NULL_SAMPLER;
    }
}

