/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.dataaccess.missing;

import com.netflix.hollow.api.sampling.HollowObjectSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public class HollowObjectMissingDataAccess
implements HollowObjectTypeDataAccess {
    private final HollowDataAccess dataAccess;
    private final String typeName;

    public HollowObjectMissingDataAccess(HollowDataAccess dataAccess, String typeName) {
        this.dataAccess = dataAccess;
        this.typeName = typeName;
    }

    @Override
    public HollowDataAccess getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return (HollowObjectSchema)this.missingDataHandler().handleSchema(this.typeName);
    }

    @Override
    public boolean isNull(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleIsNull(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public int readOrdinal(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleReferencedOrdinal(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public int readInt(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleInt(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public float readFloat(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleFloat(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public double readDouble(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleDouble(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public long readLong(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleLong(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public Boolean readBoolean(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleBoolean(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public byte[] readBytes(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleBytes(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public String readString(int ordinal, int fieldIndex) {
        return this.missingDataHandler().handleString(this.typeName, ordinal, this.fieldName(fieldIndex));
    }

    @Override
    public boolean isStringFieldEqual(int ordinal, int fieldIndex, String testValue) {
        return this.missingDataHandler().handleStringEquals(this.typeName, ordinal, this.fieldName(fieldIndex), testValue);
    }

    @Override
    public int findVarLengthFieldHashCode(int ordinal, int fieldIndex) {
        HollowObjectSchema schema = this.getSchema();
        if (schema.getFieldType(fieldIndex) == HollowObjectSchema.FieldType.STRING) {
            return HashCodes.hashCode(this.missingDataHandler().handleString(this.typeName, ordinal, schema.getFieldName(fieldIndex)));
        }
        return HashCodes.hashCode(this.missingDataHandler().handleBytes(this.typeName, ordinal, schema.getFieldName(fieldIndex)));
    }

    private String fieldName(int fieldIndex) {
        return this.getSchema().getFieldName(fieldIndex);
    }

    private MissingDataHandler missingDataHandler() {
        return this.dataAccess.getMissingDataHandler();
    }

    @Override
    public HollowTypeReadState getTypeState() {
        throw new UnsupportedOperationException("No HollowTypeReadState exists for " + this.typeName);
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
    }

    @Override
    public HollowSampler getSampler() {
        return HollowObjectSampler.NULL_SAMPLER;
    }
}

