/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read;

import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OptionalBlobPartInput
implements Closeable {
    private final Map<String, Object> inputsByPartName = new HashMap<String, Object>();
    private final List<InputStream> streamsToClose = new ArrayList<InputStream>();

    public void addInput(String partName, File file) {
        this.inputsByPartName.put(partName, file);
    }

    public void addInput(String partName, InputStream in) {
        this.streamsToClose.add(in);
        this.inputsByPartName.put(partName, in);
    }

    public File getFile(String partName) {
        Object f = this.inputsByPartName.get(partName);
        if (f instanceof File) {
            return (File)f;
        }
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream(String partName) throws IOException {
        Object o = this.inputsByPartName.get(partName);
        if (o instanceof File) {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream((File)o));
            this.streamsToClose.add(stream);
            return stream;
        }
        return (InputStream)o;
    }

    public Set<String> getPartNames() {
        return this.inputsByPartName.keySet();
    }

    public Map<String, HollowBlobInput> getInputsByPartName(MemoryMode mode) throws IOException {
        HashMap<String, HollowBlobInput> map = new HashMap<String, HollowBlobInput>(this.inputsByPartName.size());
        for (String part : this.getPartNames()) {
            map.put(part, HollowBlobInput.modeBasedSelector(mode, this, part));
        }
        return map;
    }

    public Map<String, InputStream> getInputStreamsByPartName() throws IOException {
        HashMap<String, InputStream> map = new HashMap<String, InputStream>(this.inputsByPartName.size());
        for (String part : this.getPartNames()) {
            map.put(part, this.getInputStream(part));
        }
        return map;
    }

    @Override
    public void close() throws IOException {
        IOException thrownException = null;
        for (InputStream is : this.streamsToClose) {
            try {
                is.close();
            }
            catch (IOException ex) {
                thrownException = ex;
            }
        }
        if (thrownException != null) {
            throw thrownException;
        }
    }
}

