/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class HollowReadFieldUtils {
    public static int fieldHashCode(HollowObjectTypeDataAccess typeAccess, int ordinal, int fieldPosition) {
        HollowObjectSchema schema = typeAccess.getSchema();
        switch (schema.getFieldType(fieldPosition)) {
            case BOOLEAN: {
                Boolean bool = typeAccess.readBoolean(ordinal, fieldPosition);
                return HollowReadFieldUtils.booleanHashCode(bool);
            }
            case BYTES: 
            case STRING: {
                return typeAccess.findVarLengthFieldHashCode(ordinal, fieldPosition);
            }
            case DOUBLE: {
                double d = typeAccess.readDouble(ordinal, fieldPosition);
                return HollowReadFieldUtils.doubleHashCode(d);
            }
            case FLOAT: {
                float f = typeAccess.readFloat(ordinal, fieldPosition);
                return HollowReadFieldUtils.floatHashCode(f);
            }
            case INT: {
                return HollowReadFieldUtils.intHashCode(typeAccess.readInt(ordinal, fieldPosition));
            }
            case LONG: {
                long l = typeAccess.readLong(ordinal, fieldPosition);
                return HollowReadFieldUtils.longHashCode(l);
            }
            case REFERENCE: {
                return typeAccess.readOrdinal(ordinal, fieldPosition);
            }
        }
        throw new IllegalStateException("I don't know how to hash a " + (Object)((Object)schema.getFieldType(fieldPosition)));
    }

    public static int hashObject(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return HollowReadFieldUtils.intHashCode((Integer)value);
        }
        if (value instanceof String) {
            return HollowReadFieldUtils.stringHashCode((String)value);
        }
        if (value instanceof Float) {
            return HollowReadFieldUtils.floatHashCode(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return HollowReadFieldUtils.doubleHashCode((Double)value);
        }
        if (value instanceof Boolean) {
            return HollowReadFieldUtils.booleanHashCode((Boolean)value);
        }
        if (value instanceof Long) {
            return HollowReadFieldUtils.longHashCode((Long)value);
        }
        if (value instanceof byte[]) {
            return HollowReadFieldUtils.byteArrayHashCode((byte[])value);
        }
        throw new RuntimeException("Unable to hash field of type " + value.getClass().getName());
    }

    public static boolean fieldsAreEqual(HollowObjectTypeDataAccess typeAccess1, int ordinal1, int fieldPosition1, HollowObjectTypeDataAccess typeAccess2, int ordinal2, int fieldPosition2) {
        HollowObjectSchema schema1 = typeAccess1.getSchema();
        switch (schema1.getFieldType(fieldPosition1)) {
            case BOOLEAN: {
                Boolean bool1 = typeAccess1.readBoolean(ordinal1, fieldPosition1);
                Boolean bool2 = typeAccess2.readBoolean(ordinal2, fieldPosition2);
                return bool1 == bool2;
            }
            case BYTES: {
                byte[] data1 = typeAccess1.readBytes(ordinal1, fieldPosition1);
                byte[] data2 = typeAccess2.readBytes(ordinal2, fieldPosition2);
                return Arrays.equals(data1, data2);
            }
            case DOUBLE: {
                double d1 = typeAccess1.readDouble(ordinal1, fieldPosition1);
                double d2 = typeAccess2.readDouble(ordinal2, fieldPosition2);
                return Double.compare(d1, d2) == 0;
            }
            case FLOAT: {
                float f1 = typeAccess1.readFloat(ordinal1, fieldPosition1);
                float f2 = typeAccess2.readFloat(ordinal2, fieldPosition2);
                return Float.compare(f1, f2) == 0;
            }
            case INT: {
                int i1 = typeAccess1.readInt(ordinal1, fieldPosition1);
                int i2 = typeAccess2.readInt(ordinal2, fieldPosition2);
                return i1 == i2;
            }
            case LONG: {
                long l1 = typeAccess1.readLong(ordinal1, fieldPosition1);
                long l2 = typeAccess2.readLong(ordinal2, fieldPosition2);
                return l1 == l2;
            }
            case STRING: {
                String s1 = typeAccess1.readString(ordinal1, fieldPosition1);
                return typeAccess2.isStringFieldEqual(ordinal2, fieldPosition2, s1);
            }
            case REFERENCE: {
                if (typeAccess1 != typeAccess2 || fieldPosition1 != fieldPosition2) break;
                return typeAccess1.readOrdinal(ordinal1, fieldPosition1) == typeAccess2.readOrdinal(ordinal2, fieldPosition2);
            }
        }
        throw new IllegalStateException("I don't know how to test equality for a " + (Object)((Object)schema1.getFieldType(fieldPosition1)));
    }

    public static String displayString(HollowObjectTypeDataAccess typeAccess, int ordinal, int fieldPosition) {
        HollowObjectSchema schema = typeAccess.getSchema();
        switch (schema.getFieldType(fieldPosition)) {
            case BOOLEAN: {
                Boolean bool = typeAccess.readBoolean(ordinal, fieldPosition);
                return String.valueOf(bool);
            }
            case BYTES: 
            case STRING: {
                return typeAccess.readString(ordinal, fieldPosition);
            }
            case DOUBLE: {
                double d = typeAccess.readDouble(ordinal, fieldPosition);
                return String.valueOf(d);
            }
            case FLOAT: {
                float f = typeAccess.readFloat(ordinal, fieldPosition);
                return String.valueOf(f);
            }
            case INT: {
                return String.valueOf(typeAccess.readInt(ordinal, fieldPosition));
            }
            case LONG: {
                long l = typeAccess.readLong(ordinal, fieldPosition);
                return String.valueOf(l);
            }
        }
        throw new IllegalStateException("I don't know how to display a " + (Object)((Object)schema.getFieldType(fieldPosition)));
    }

    public static Object fieldValueObject(HollowObjectTypeDataAccess typeAccess, int ordinal, int fieldPosition) {
        HollowObjectSchema schema = typeAccess.getSchema();
        switch (schema.getFieldType(fieldPosition)) {
            case BOOLEAN: {
                return typeAccess.readBoolean(ordinal, fieldPosition);
            }
            case BYTES: {
                return typeAccess.readBytes(ordinal, fieldPosition);
            }
            case STRING: {
                return typeAccess.readString(ordinal, fieldPosition);
            }
            case DOUBLE: {
                double d = typeAccess.readDouble(ordinal, fieldPosition);
                return Double.isNaN(d) ? null : Double.valueOf(d);
            }
            case FLOAT: {
                float f = typeAccess.readFloat(ordinal, fieldPosition);
                return Float.isNaN(f) ? null : Float.valueOf(f);
            }
            case INT: {
                int i = typeAccess.readInt(ordinal, fieldPosition);
                if (i == Integer.MIN_VALUE) {
                    return null;
                }
                return i;
            }
            case LONG: {
                long l = typeAccess.readLong(ordinal, fieldPosition);
                if (l == Long.MIN_VALUE) {
                    return null;
                }
                return l;
            }
            case REFERENCE: {
                int refOrdinal = typeAccess.readOrdinal(ordinal, fieldPosition);
                if (refOrdinal < 0) {
                    return null;
                }
                return refOrdinal;
            }
        }
        throw new IllegalStateException("Can't handle fieldType=" + (Object)((Object)schema.getFieldType(fieldPosition)) + " for schema=" + schema.getName() + ", fieldPosition=" + fieldPosition);
    }

    public static boolean fieldValueEquals(HollowObjectTypeDataAccess typeAccess, int ordinal, int fieldPosition, Object testObject) {
        HollowObjectSchema schema = typeAccess.getSchema();
        switch (schema.getFieldType(fieldPosition)) {
            case BOOLEAN: {
                if (testObject instanceof Boolean) {
                    return testObject.equals(typeAccess.readBoolean(ordinal, fieldPosition));
                }
                return testObject == null && typeAccess.readBoolean(ordinal, fieldPosition) == null;
            }
            case BYTES: {
                if (testObject instanceof byte[]) {
                    return Arrays.equals(typeAccess.readBytes(ordinal, fieldPosition), (byte[])testObject);
                }
                return testObject == null && typeAccess.readBytes(ordinal, fieldPosition) == null;
            }
            case STRING: {
                if (testObject instanceof String) {
                    return testObject.equals(typeAccess.readString(ordinal, fieldPosition));
                }
                return testObject == null && typeAccess.readString(ordinal, fieldPosition) == null;
            }
            case DOUBLE: {
                if (testObject instanceof Double) {
                    return testObject.equals(typeAccess.readDouble(ordinal, fieldPosition));
                }
                return testObject == null && !Double.isNaN(typeAccess.readDouble(ordinal, fieldPosition));
            }
            case FLOAT: {
                if (testObject instanceof Float) {
                    return testObject.equals(Float.valueOf(typeAccess.readFloat(ordinal, fieldPosition)));
                }
                return testObject == null && !Float.isNaN(typeAccess.readFloat(ordinal, fieldPosition));
            }
            case INT: {
                if (testObject instanceof Integer) {
                    return testObject.equals(typeAccess.readInt(ordinal, fieldPosition));
                }
                return testObject == null && typeAccess.readInt(ordinal, fieldPosition) == Integer.MIN_VALUE;
            }
            case LONG: {
                if (testObject instanceof Long) {
                    return testObject.equals(typeAccess.readLong(ordinal, fieldPosition));
                }
                return testObject == null && typeAccess.readLong(ordinal, fieldPosition) == Long.MIN_VALUE;
            }
            case REFERENCE: {
                if (testObject instanceof Integer) {
                    return testObject.equals(typeAccess.readOrdinal(ordinal, fieldPosition));
                }
                return testObject == null && typeAccess.readOrdinal(ordinal, fieldPosition) < 0;
            }
        }
        throw new IllegalStateException("I don't know how to test equality for a " + (Object)((Object)schema.getFieldType(fieldPosition)));
    }

    public static int compareFieldValues(HollowObjectTypeDataAccess typeAccess, int fieldPosition, int ordinal1, int ordinal2) {
        HollowObjectSchema schema = typeAccess.getSchema();
        switch (schema.getFieldType(fieldPosition)) {
            case BOOLEAN: {
                return Boolean.compare(typeAccess.readBoolean(ordinal1, fieldPosition), typeAccess.readBoolean(ordinal2, fieldPosition));
            }
            case BYTES: {
                return 0;
            }
            case DOUBLE: {
                return Double.compare(typeAccess.readDouble(ordinal1, fieldPosition), typeAccess.readDouble(ordinal2, fieldPosition));
            }
            case FLOAT: {
                return Float.compare(typeAccess.readFloat(ordinal1, fieldPosition), typeAccess.readFloat(ordinal2, fieldPosition));
            }
            case INT: {
                return Integer.compare(typeAccess.readInt(ordinal1, fieldPosition), typeAccess.readInt(ordinal2, fieldPosition));
            }
            case LONG: {
                return Long.compare(typeAccess.readLong(ordinal1, fieldPosition), typeAccess.readLong(ordinal2, fieldPosition));
            }
            case STRING: {
                return typeAccess.readString(ordinal1, fieldPosition).compareTo(typeAccess.readString(ordinal2, fieldPosition));
            }
            case REFERENCE: {
                HollowObjectTypeDataAccess refTypeAccess;
                HollowObjectSchema refSchema;
                HollowTypeDataAccess typeDataAccess = typeAccess.getDataAccess().getTypeDataAccess(schema.getReferencedType(fieldPosition));
                if (typeDataAccess instanceof HollowObjectTypeDataAccess && (refSchema = (refTypeAccess = (HollowObjectTypeDataAccess)typeDataAccess).getSchema()).numFields() == 1) {
                    return HollowReadFieldUtils.compareFieldValues(refTypeAccess, 0, typeAccess.readOrdinal(ordinal1, fieldPosition), typeAccess.readOrdinal(ordinal2, fieldPosition));
                }
                return 0;
            }
        }
        throw new IllegalStateException("I don't know how to compare a " + (Object)((Object)schema.getFieldType(fieldPosition)));
    }

    public static int byteArrayHashCode(byte[] data) {
        return HashCodes.hashCode(data);
    }

    public static int stringHashCode(String str) {
        return HashCodes.hashCode(str);
    }

    public static int booleanHashCode(Boolean bool) {
        return bool == null ? -1 : (bool != false ? 1 : 0);
    }

    public static int longHashCode(long l) {
        return (int)l ^ (int)(l >> 32);
    }

    public static int intHashCode(int i) {
        return i;
    }

    public static int floatHashCode(float f) {
        return Float.floatToIntBits(f);
    }

    public static int doubleHashCode(double d) {
        long bits = Double.doubleToLongBits(d);
        return HollowReadFieldUtils.longHashCode(bits);
    }
}

