/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.BlobByteBuffer;
import com.netflix.hollow.core.read.OptionalBlobPartInput;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class HollowBlobInput
implements Closeable {
    private final MemoryMode memoryMode;
    private final DataInput input;
    private final BlobByteBuffer buffer;

    private HollowBlobInput(MemoryMode memoryMode, DataInput input) {
        this(memoryMode, input, null);
    }

    private HollowBlobInput(MemoryMode memoryMode, DataInput input, BlobByteBuffer buffer) {
        this.memoryMode = memoryMode;
        this.input = input;
        this.buffer = buffer;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public static HollowBlobInput modeBasedSelector(MemoryMode mode, HollowConsumer.Blob blob) throws IOException {
        if (mode.equals((Object)MemoryMode.ON_HEAP)) {
            return HollowBlobInput.serial(blob.getInputStream());
        }
        if (mode.equals((Object)MemoryMode.SHARED_MEMORY_LAZY)) {
            return HollowBlobInput.randomAccess(blob.getFile());
        }
        throw new UnsupportedOperationException();
    }

    public static HollowBlobInput modeBasedSelector(MemoryMode mode, OptionalBlobPartInput input, String partName) throws IOException {
        if (mode.equals((Object)MemoryMode.ON_HEAP)) {
            return HollowBlobInput.serial(input.getInputStream(partName));
        }
        if (mode.equals((Object)MemoryMode.SHARED_MEMORY_LAZY)) {
            return HollowBlobInput.randomAccess(input.getFile(partName));
        }
        throw new UnsupportedOperationException();
    }

    public static HollowBlobInput randomAccess(File f) throws IOException {
        return HollowBlobInput.randomAccess(f, 0x40000000);
    }

    public static HollowBlobInput randomAccess(File f, int singleBufferCapacity) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        try {
            BlobByteBuffer buffer = BlobByteBuffer.mmapBlob(raf.getChannel(), singleBufferCapacity);
            return new HollowBlobInput(MemoryMode.SHARED_MEMORY_LAZY, raf, buffer);
        }
        catch (IOException exc) {
            raf.close();
            throw exc;
        }
    }

    public static HollowBlobInput serial(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return HollowBlobInput.serial(is);
    }

    public static HollowBlobInput serial(InputStream is) {
        return new HollowBlobInput(MemoryMode.ON_HEAP, new DataInputStream(is));
    }

    public int read() throws IOException {
        return this.input.readUnsignedByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).read(b, off, len);
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).read(b, off, len);
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public void seek(long pos) throws IOException {
        if (!(this.input instanceof RandomAccessFile)) {
            if (this.input instanceof DataInputStream) {
                throw new UnsupportedOperationException("Can not seek on Hollow Blob Input of type DataInputStream");
            }
            throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
        }
        ((RandomAccessFile)this.input).seek(pos);
    }

    public long getFilePointer() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).getFilePointer();
        }
        if (this.input instanceof DataInputStream) {
            throw new UnsupportedOperationException("Can not get file pointer for Hollow Blob Input of type DataInputStream");
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public final short readShort() throws IOException {
        return this.input.readShort();
    }

    public final int readInt() throws IOException {
        return this.input.readInt();
    }

    public final long readLong() throws IOException {
        return this.input.readLong();
    }

    public final String readUTF() throws IOException {
        return this.input.readUTF();
    }

    public long skipBytes(long n) throws IOException {
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).skip(n);
        }
        long total = 0L;
        int expected = 0;
        int actual = 0;
        while ((total += (long)(actual = this.input.skipBytes(expected = n - total > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(n - total)))) < n && actual > 0) {
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        if (this.input instanceof Closeable) {
            ((Closeable)((Object)this.input)).close();
        }
    }

    public Object getInput() {
        return this.input;
    }

    public BlobByteBuffer getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        if (this.input instanceof DataInputStream) {
            throw new UnsupportedOperationException("No buffer associated with underlying DataInputStream");
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }
}

