/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.pool;

import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public class RecyclingRecycler
implements ArraySegmentRecycler {
    private final int log2OfByteSegmentSize;
    private final int log2OfLongSegmentSize;
    private final Recycler<long[]> longSegmentRecycler;
    private final Recycler<byte[]> byteSegmentRecycler;

    public RecyclingRecycler() {
        this(11, 8);
    }

    public RecyclingRecycler(int log2ByteArraySize, int log2LongArraySize) {
        this.log2OfByteSegmentSize = log2ByteArraySize;
        this.log2OfLongSegmentSize = log2LongArraySize;
        this.byteSegmentRecycler = new Recycler<byte[]>(() -> new byte[1 << log2ByteArraySize]);
        this.longSegmentRecycler = new Recycler<long[]>(() -> new long[(1 << log2LongArraySize) + 1]);
    }

    @Override
    public int getLog2OfByteSegmentSize() {
        return this.log2OfByteSegmentSize;
    }

    @Override
    public int getLog2OfLongSegmentSize() {
        return this.log2OfLongSegmentSize;
    }

    @Override
    public long[] getLongArray() {
        long[] arr = this.longSegmentRecycler.get();
        Arrays.fill(arr, 0L);
        return arr;
    }

    @Override
    public void recycleLongArray(long[] arr) {
        this.longSegmentRecycler.recycle(arr);
    }

    @Override
    public byte[] getByteArray() {
        return this.byteSegmentRecycler.get();
    }

    @Override
    public void recycleByteArray(byte[] arr) {
        this.byteSegmentRecycler.recycle(arr);
    }

    @Override
    public void swap() {
        this.longSegmentRecycler.swap();
        this.byteSegmentRecycler.swap();
    }

    private static interface Creator<T> {
        public T create();
    }

    private static class Recycler<T> {
        private final Creator<T> creator;
        private Deque<T> currentSegments = new ArrayDeque<T>();
        private Deque<T> nextSegments = new ArrayDeque<T>();

        Recycler(Creator<T> creator) {
            this.creator = creator;
        }

        T get() {
            if (!this.currentSegments.isEmpty()) {
                return this.currentSegments.removeFirst();
            }
            return this.creator.create();
        }

        void recycle(T reuse) {
            this.nextSegments.addLast(reuse);
        }

        void swap() {
            if (this.nextSegments.size() > this.currentSegments.size()) {
                Deque<T> tmp = this.nextSegments;
                this.nextSegments = this.currentSegments;
                this.currentSegments = tmp;
            }
            this.currentSegments.addAll(this.nextSegments);
            this.nextSegments.clear();
        }
    }
}

