/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.encoding.BlobByteBuffer;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.IOException;

public class EncodedLongBuffer
implements FixedLengthData {
    private BlobByteBuffer bufferView;
    private long maxByteIndex = -1L;

    public static EncodedLongBuffer newFrom(HollowBlobInput in) throws IOException {
        long numLongs = VarInt.readVLong(in);
        return EncodedLongBuffer.newFrom(in, numLongs);
    }

    public static EncodedLongBuffer newFrom(HollowBlobInput in, long numLongs) throws IOException {
        EncodedLongBuffer buf = new EncodedLongBuffer();
        buf.loadFrom(in, numLongs);
        return buf;
    }

    private void loadFrom(HollowBlobInput in, long numLongs) throws IOException {
        BlobByteBuffer buffer = in.getBuffer();
        if (numLongs == 0L) {
            return;
        }
        this.maxByteIndex = numLongs * 8L - 1L;
        buffer.position(in.getFilePointer());
        this.bufferView = buffer.duplicate();
        buffer.position(buffer.position() + numLongs * 8L);
        in.seek(in.getFilePointer() + numLongs * 8L);
    }

    @Override
    public long getElementValue(long index, int bitsPerElement) {
        return this.getElementValue(index, bitsPerElement, (1L << bitsPerElement) - 1L);
    }

    @Override
    public long getElementValue(long index, int bitsPerElement, long mask) {
        long whichByte = index >>> 3;
        int whichBit = (int)(index & 7L);
        if ((double)whichByte + Math.ceil((float)bitsPerElement / 8.0f) > (double)(this.maxByteIndex + 1L)) {
            throw new IllegalStateException();
        }
        long longVal = this.bufferView.getLong(this.bufferView.position() + whichByte);
        long l = longVal >>> whichBit;
        return l & mask;
    }

    @Override
    public long getLargeElementValue(long index, int bitsPerElement) {
        long mask = bitsPerElement == 64 ? -1L : (1L << bitsPerElement) - 1L;
        return this.getLargeElementValue(index, bitsPerElement, mask);
    }

    @Override
    public long getLargeElementValue(long index, int bitsPerElement, long mask) {
        long whichLong = index >>> 6;
        int whichBit = (int)(index & 0x3FL);
        long l = this.bufferView.getLong(this.bufferView.position() + whichLong * 8L) >>> whichBit;
        int bitsRemaining = 64 - whichBit;
        if (bitsRemaining < bitsPerElement) {
            l |= this.bufferView.getLong(this.bufferView.position() + ++whichLong * 8L) << bitsRemaining;
        }
        return l & mask;
    }

    @Override
    public void setElementValue(long index, int bitsPerElement, long value) {
        throw new UnsupportedOperationException("Not supported in shared-memory mode");
    }

    @Override
    public void copyBits(FixedLengthData copyFrom, long sourceStartBit, long destStartBit, long numBits) {
        throw new UnsupportedOperationException("Not supported in shared-memory mode");
    }

    @Override
    public void incrementMany(long startBit, long increment, long bitsBetweenIncrements, int numIncrements) {
        throw new UnsupportedOperationException("Not supported in shared-memory mode");
    }

    @Override
    public void clearElementValue(long index, int bitsPerElement) {
        throw new UnsupportedOperationException("Not supported in shared-memory mode");
    }
}

