/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.traversal;

import com.netflix.hollow.core.index.traversal.HollowIndexerCollectionTraversalNode;
import com.netflix.hollow.core.index.traversal.HollowIndexerListTraversalNode;
import com.netflix.hollow.core.index.traversal.HollowIndexerMapTraversalNode;
import com.netflix.hollow.core.index.traversal.HollowIndexerObjectFieldTraversalNode;
import com.netflix.hollow.core.index.traversal.HollowIndexerObjectTraversalNode;
import com.netflix.hollow.core.index.traversal.HollowIndexerTraversalNode;
import com.netflix.hollow.core.read.dataaccess.HollowCollectionTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowListTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntList;
import java.util.ArrayList;

class TraversalTreeBuilder {
    private final HollowDataAccess dataAccess;
    private final String type;
    private final String[] fieldPaths;
    private final IntList[] fieldMatchLists;
    private final HollowTypeDataAccess[] fieldTypeDataAccess;
    private final int[] fieldSchemaPositions;

    public TraversalTreeBuilder(HollowDataAccess dataAccess, String type, String[] fieldPaths) {
        this.dataAccess = dataAccess;
        this.type = type;
        this.fieldPaths = fieldPaths;
        this.fieldMatchLists = new IntList[fieldPaths.length];
        for (int i = 0; i < fieldPaths.length; ++i) {
            this.fieldMatchLists[i] = new IntList();
        }
        this.fieldTypeDataAccess = new HollowTypeDataAccess[fieldPaths.length];
        this.fieldSchemaPositions = new int[fieldPaths.length];
    }

    public IntList[] getFieldMatchLists() {
        return this.fieldMatchLists;
    }

    public HollowTypeDataAccess[] getFieldTypeDataAccesses() {
        return this.fieldTypeDataAccess;
    }

    public int[] getFieldSchemaPositions() {
        return this.fieldSchemaPositions;
    }

    public HollowIndexerTraversalNode buildTree() {
        HollowTypeDataAccess rootTypeDataAccess = this.dataAccess.getTypeDataAccess(this.type);
        HollowIndexerTraversalNode rootNode = this.createTypeNode(rootTypeDataAccess);
        ArrayList<HollowIndexerTraversalNode> allNodes = new ArrayList<HollowIndexerTraversalNode>();
        allNodes.add(rootNode);
        for (int i = 0; i < this.fieldPaths.length; ++i) {
            String[] pathElements;
            String fieldPath = this.fieldPaths[i];
            String[] stringArray = pathElements = "".equals(fieldPath) ? new String[]{} : fieldPath.split("\\.");
            if (pathElements.length == 0) {
                rootNode.setIndexedFieldPosition(i);
                this.fieldTypeDataAccess[i] = rootTypeDataAccess;
                continue;
            }
            HollowTypeDataAccess typeDataAccess = rootTypeDataAccess;
            HollowIndexerTraversalNode currentNode = rootNode;
            for (int j = 0; j < pathElements.length; ++j) {
                String pathElement = pathElements[j];
                HollowIndexerTraversalNode child = currentNode.getChild(pathElement);
                if (child == null) {
                    child = this.createChildNode(typeDataAccess, pathElement);
                    currentNode.addChild(pathElement, child);
                    allNodes.add(child);
                }
                currentNode = child;
                if (j == pathElements.length - 1) {
                    currentNode.setIndexedFieldPosition(i);
                    this.fieldTypeDataAccess[i] = typeDataAccess;
                    if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
                        HollowObjectSchema schema = (HollowObjectSchema)typeDataAccess.getSchema();
                        if (schema.getFieldType(pathElement) == HollowObjectSchema.FieldType.REFERENCE) {
                            this.fieldSchemaPositions[i] = -1;
                            this.fieldTypeDataAccess[i] = this.getChildDataAccess(typeDataAccess, pathElement);
                            continue;
                        }
                        this.fieldSchemaPositions[i] = schema.getPosition(pathElement);
                        this.fieldTypeDataAccess[i] = typeDataAccess;
                        continue;
                    }
                    if (typeDataAccess instanceof HollowMapTypeDataAccess) {
                        this.fieldTypeDataAccess[i] = this.getChildDataAccess(typeDataAccess, pathElement);
                        this.fieldSchemaPositions[i] = -1;
                        continue;
                    }
                    if (!(typeDataAccess instanceof HollowCollectionTypeDataAccess)) continue;
                    this.fieldTypeDataAccess[i] = this.getChildDataAccess(typeDataAccess, pathElement);
                    this.fieldSchemaPositions[i] = -1;
                    continue;
                }
                typeDataAccess = this.getChildDataAccess(typeDataAccess, pathElement);
            }
        }
        for (HollowIndexerTraversalNode node : allNodes) {
            node.setUpMultiplication();
            node.setUpChildren();
        }
        return rootNode;
    }

    private HollowIndexerTraversalNode createChildNode(HollowTypeDataAccess typeDataAccess, String childName) {
        if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
            int fieldIdx;
            HollowObjectTypeDataAccess objectAccess = (HollowObjectTypeDataAccess)typeDataAccess;
            HollowObjectSchema schema = objectAccess.getSchema();
            if (schema.getFieldType(fieldIdx = schema.getPosition(childName)) == HollowObjectSchema.FieldType.REFERENCE) {
                String childType = schema.getReferencedType(fieldIdx);
                HollowTypeDataAccess childTypeAccess = this.dataAccess.getTypeDataAccess(childType);
                return this.createTypeNode(childTypeAccess);
            }
            return new HollowIndexerObjectFieldTraversalNode(objectAccess, this.fieldMatchLists);
        }
        if (typeDataAccess instanceof HollowCollectionTypeDataAccess) {
            HollowCollectionSchema schema = (HollowCollectionSchema)typeDataAccess.getSchema();
            HollowTypeDataAccess childTypeAccess = this.dataAccess.getTypeDataAccess(schema.getElementType());
            return this.createTypeNode(childTypeAccess);
        }
        if (typeDataAccess instanceof HollowMapTypeDataAccess) {
            HollowMapSchema schema = (HollowMapSchema)typeDataAccess.getSchema();
            String childType = "key".equals(childName) ? schema.getKeyType() : schema.getValueType();
            HollowTypeDataAccess childTypeAccess = this.dataAccess.getTypeDataAccess(childType);
            return this.createTypeNode(childTypeAccess);
        }
        throw new IllegalArgumentException("I can't create a child node for a " + typeDataAccess.getClass());
    }

    private HollowTypeDataAccess getChildDataAccess(HollowTypeDataAccess typeDataAccess, String childName) {
        if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
            HollowObjectSchema schema = (HollowObjectSchema)typeDataAccess.getSchema();
            int fieldIdx = schema.getPosition(childName);
            String childType = schema.getReferencedType(fieldIdx);
            return this.dataAccess.getTypeDataAccess(childType);
        }
        if (typeDataAccess instanceof HollowCollectionTypeDataAccess) {
            HollowCollectionSchema schema = (HollowCollectionSchema)typeDataAccess.getSchema();
            return this.dataAccess.getTypeDataAccess(schema.getElementType());
        }
        if (typeDataAccess instanceof HollowMapTypeDataAccess) {
            HollowMapSchema schema = (HollowMapSchema)typeDataAccess.getSchema();
            String childType = "key".equals(childName) ? schema.getKeyType() : schema.getValueType();
            return this.dataAccess.getTypeDataAccess(childType);
        }
        throw new IllegalArgumentException("I can't create a child node for a " + typeDataAccess.getClass());
    }

    private HollowIndexerTraversalNode createTypeNode(HollowTypeDataAccess typeDataAccess) {
        if (typeDataAccess instanceof HollowObjectTypeDataAccess) {
            return new HollowIndexerObjectTraversalNode((HollowObjectTypeDataAccess)typeDataAccess, this.fieldMatchLists);
        }
        if (typeDataAccess instanceof HollowListTypeDataAccess) {
            return new HollowIndexerListTraversalNode((HollowListTypeDataAccess)typeDataAccess, this.fieldMatchLists);
        }
        if (typeDataAccess instanceof HollowSetTypeDataAccess) {
            return new HollowIndexerCollectionTraversalNode(typeDataAccess, this.fieldMatchLists);
        }
        if (typeDataAccess instanceof HollowMapTypeDataAccess) {
            return new HollowIndexerMapTraversalNode(typeDataAccess, this.fieldMatchLists);
        }
        throw new IllegalArgumentException("I can't create a type node for a " + typeDataAccess.getClass());
    }
}

