/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.traversal;

import com.netflix.hollow.core.index.traversal.HollowIndexerTraversalNode;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.util.IntList;

class HollowIndexerMapTraversalNode
extends HollowIndexerTraversalNode {
    private HollowIndexerTraversalNode keyNode;
    private HollowIndexerTraversalNode valueNode;

    public HollowIndexerMapTraversalNode(HollowTypeDataAccess dataAccess, IntList[] fieldMatches) {
        super(dataAccess, fieldMatches);
    }

    @Override
    protected void setUpChildren() {
        this.keyNode = (HollowIndexerTraversalNode)this.children.get("key");
        this.valueNode = (HollowIndexerTraversalNode)this.children.get("value");
    }

    @Override
    public int doTraversal(int ordinal) {
        int numMatches = 0;
        HollowMapEntryOrdinalIterator ordinalIterator = this.dataAccess().ordinalIterator(ordinal);
        while (ordinalIterator.next()) {
            this.prepareMultiply();
            if (this.keyNode != null) {
                this.keyNode.traverse(ordinalIterator.getKey());
            }
            if (this.valueNode != null) {
                this.valueNode.traverse(ordinalIterator.getValue());
            }
            numMatches += this.doMultiply();
        }
        return numMatches;
    }

    @Override
    protected HollowMapTypeDataAccess dataAccess() {
        return (HollowMapTypeDataAccess)this.dataAccess;
    }

    @Override
    protected boolean followingChildrenMultipliesTraversal() {
        return true;
    }
}

