/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.FixedLengthMultipleOccurrenceElementArray;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

class TST {
    private int bitsPerNode;
    private int bitsPerKey;
    private int bitsForChildPointer;
    private int bitsPerOrdinal;
    private long leftChildOffset;
    private long middleChildOffset;
    private long rightChildOffset;
    private long isEndFlagOffset;
    private final long maxNodes;
    private final boolean caseSensitive;
    private FixedLengthElementArray nodes;
    private FixedLengthMultipleOccurrenceElementArray ordinalSet;
    private long indexTracker;
    private long maxDepth;

    TST(long estimatedMaxNodes, int estimatedMaxStringDuplicates, int maxOrdinalValue, boolean caseSensitive, ArraySegmentRecycler memoryRecycler) {
        this.maxNodes = estimatedMaxNodes;
        this.caseSensitive = caseSensitive;
        this.bitsPerKey = 16;
        this.bitsForChildPointer = 64 - Long.numberOfLeadingZeros(this.maxNodes);
        this.bitsPerOrdinal = maxOrdinalValue == 0 ? 1 : 32 - Integer.numberOfLeadingZeros(maxOrdinalValue);
        this.bitsPerNode = this.bitsPerKey + 3 * this.bitsForChildPointer + 1;
        this.nodes = new FixedLengthElementArray(memoryRecycler, (long)this.bitsPerNode * this.maxNodes);
        this.ordinalSet = new FixedLengthMultipleOccurrenceElementArray(memoryRecycler, this.maxNodes, this.bitsPerOrdinal, estimatedMaxStringDuplicates);
        this.indexTracker = 0L;
        this.maxDepth = 0L;
        this.leftChildOffset = this.bitsPerKey;
        this.middleChildOffset = this.leftChildOffset + (long)this.bitsForChildPointer;
        this.rightChildOffset = this.middleChildOffset + (long)this.bitsForChildPointer;
        this.isEndFlagOffset = this.rightChildOffset + (long)this.bitsForChildPointer;
    }

    void recycleMemory(ArraySegmentRecycler memoryRecycler) {
        this.nodes.destroy(memoryRecycler);
        this.ordinalSet.destroy();
    }

    private long getChildOffset(NodeType nodeType) {
        long offset = nodeType.equals((Object)NodeType.Left) ? this.leftChildOffset : (nodeType.equals((Object)NodeType.Middle) ? this.middleChildOffset : this.rightChildOffset);
        return offset;
    }

    private long getChildIndex(long currentNode, NodeType nodeType) {
        long offset = this.getChildOffset(nodeType);
        return this.nodes.getElementValue(currentNode * (long)this.bitsPerNode + offset, this.bitsForChildPointer);
    }

    private void setChildIndex(long currentNode, NodeType nodeType, long indexForNode) {
        long offset = this.getChildOffset(nodeType);
        this.nodes.setElementValue(currentNode * (long)this.bitsPerNode + offset, this.bitsForChildPointer, indexForNode);
    }

    private void setKey(long index, char ch) {
        this.nodes.setElementValue(index * (long)this.bitsPerNode, this.bitsPerKey, ch);
    }

    private long getKey(long nodeIndex) {
        return this.nodes.getElementValue(nodeIndex * (long)this.bitsPerNode, this.bitsPerKey);
    }

    private boolean isEndNode(long nodeIndex) {
        return this.nodes.getElementValue(nodeIndex * (long)this.bitsPerNode + this.isEndFlagOffset, 1) == 1L;
    }

    private void addOrdinal(long nodeIndex, long ordinal) {
        this.ordinalSet.addElement(nodeIndex, ordinal);
        this.nodes.setElementValue(nodeIndex * (long)this.bitsPerNode + this.isEndFlagOffset, 1, 1L);
    }

    List<Integer> getOrdinals(long nodeIndex) {
        if (nodeIndex < 0L) {
            return Collections.EMPTY_LIST;
        }
        return this.ordinalSet.getElements(nodeIndex).stream().map(Long::intValue).collect(Collectors.toList());
    }

    void insert(String key, int ordinal) {
        if (key == null) {
            throw new IllegalArgumentException("Null key cannot be indexed");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("Empty string cannot be indexed");
        }
        long currentNodeIndex = 0L;
        int keyIndex = 0;
        int depth = 0;
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        while (keyIndex < key.length()) {
            long keyAtCurrentNode;
            char ch = key.charAt(keyIndex);
            if (this.getKey(currentNodeIndex) == 0L) {
                this.setKey(currentNodeIndex, ch);
                ++this.indexTracker;
                if (this.indexTracker >= this.maxNodes) {
                    throw new IllegalStateException("Index Tracker reached max capacity. Try with larger estimate of number of nodes");
                }
            }
            if ((long)ch < (keyAtCurrentNode = this.getKey(currentNodeIndex))) {
                long leftIndex = this.getChildIndex(currentNodeIndex, NodeType.Left);
                if (leftIndex == 0L) {
                    leftIndex = this.indexTracker;
                }
                this.setChildIndex(currentNodeIndex, NodeType.Left, leftIndex);
                currentNodeIndex = leftIndex;
            } else if ((long)ch > keyAtCurrentNode) {
                long rightIndex = this.getChildIndex(currentNodeIndex, NodeType.Right);
                if (rightIndex == 0L) {
                    rightIndex = this.indexTracker;
                }
                this.setChildIndex(currentNodeIndex, NodeType.Right, rightIndex);
                currentNodeIndex = rightIndex;
            } else if (++keyIndex < key.length()) {
                long midIndex = this.getChildIndex(currentNodeIndex, NodeType.Middle);
                if (midIndex == 0L) {
                    midIndex = this.indexTracker;
                }
                this.setChildIndex(currentNodeIndex, NodeType.Middle, midIndex);
                currentNodeIndex = midIndex;
            }
            ++depth;
        }
        this.addOrdinal(currentNodeIndex, ordinal);
        if ((long)depth > this.maxDepth) {
            this.maxDepth = depth;
        }
    }

    long findLongestMatch(String prefix) {
        long nodeIndex = -1L;
        if (prefix == null || prefix.length() == 0) {
            return nodeIndex;
        }
        if (!this.caseSensitive) {
            prefix = prefix.toLowerCase();
        }
        boolean atRoot = true;
        long currentNodeIndex = 0L;
        int keyIndex = 0;
        while (currentNodeIndex != 0L || atRoot) {
            long currentValue = this.getKey(currentNodeIndex);
            char ch = prefix.charAt(keyIndex);
            if ((long)ch < currentValue) {
                currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Left);
            } else if ((long)ch > currentValue) {
                currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Right);
            } else {
                if (this.isEndNode(currentNodeIndex)) {
                    nodeIndex = currentNodeIndex;
                }
                if (keyIndex == prefix.length() - 1) break;
                currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Middle);
                ++keyIndex;
            }
            if (!atRoot) continue;
            atRoot = false;
        }
        return nodeIndex;
    }

    long findNodeWithKey(String key) {
        long index = -1L;
        if (key == null || key.length() == 0) {
            return index;
        }
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        boolean atRoot = true;
        long currentNodeIndex = 0L;
        int keyIndex = 0;
        while (currentNodeIndex != 0L || atRoot) {
            long currentValue = this.getKey(currentNodeIndex);
            char ch = key.charAt(keyIndex);
            if ((long)ch < currentValue) {
                currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Left);
            } else if ((long)ch > currentValue) {
                currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Right);
            } else {
                if (keyIndex == key.length() - 1) {
                    index = currentNodeIndex;
                    break;
                }
                currentNodeIndex = this.getChildIndex(currentNodeIndex, NodeType.Middle);
                ++keyIndex;
            }
            if (!atRoot) continue;
            atRoot = false;
        }
        return index;
    }

    boolean contains(String key) {
        long nodeIndex = this.findNodeWithKey(key);
        return nodeIndex >= 0L && this.isEndNode(nodeIndex);
    }

    HollowOrdinalIterator findKeysWithPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Cannot findKeysWithPrefix null prefix");
        }
        if (!this.caseSensitive) {
            prefix = prefix.toLowerCase();
        }
        final HashSet<Integer> ordinals = new HashSet<Integer>();
        long currentNodeIndex = prefix.length() == 0 ? 0L : this.findNodeWithKey(prefix);
        if (currentNodeIndex >= 0L) {
            if (this.isEndNode(currentNodeIndex)) {
                ordinals.addAll(this.getOrdinals(currentNodeIndex));
            }
            ArrayDeque<Long> queue = new ArrayDeque<Long>();
            if (prefix.length() == 0) {
                queue.add(0L);
            } else {
                long subTree = this.getChildIndex(currentNodeIndex, NodeType.Middle);
                if (subTree != 0L) {
                    queue.add(subTree);
                }
            }
            while (!queue.isEmpty()) {
                long nodeIndex = (Long)queue.remove();
                long left = this.getChildIndex(nodeIndex, NodeType.Left);
                long mid = this.getChildIndex(nodeIndex, NodeType.Middle);
                long right = this.getChildIndex(nodeIndex, NodeType.Right);
                if (this.isEndNode(nodeIndex)) {
                    ordinals.addAll(this.getOrdinals(nodeIndex));
                }
                if (left != 0L) {
                    queue.add(left);
                }
                if (mid != 0L) {
                    queue.add(mid);
                }
                if (right == 0L) continue;
                queue.add(right);
            }
        }
        return new HollowOrdinalIterator(){
            private Iterator<Integer> it;
            {
                this.it = ordinals.iterator();
            }

            @Override
            public int next() {
                if (this.it.hasNext()) {
                    return this.it.next();
                }
                return Integer.MAX_VALUE;
            }
        };
    }

    long getMaxDepth() {
        return this.maxDepth;
    }

    long getEmptyNodes() {
        return this.maxNodes - this.indexTracker;
    }

    long getNumNodes() {
        return this.indexTracker;
    }

    long getMaxNodes() {
        return this.maxNodes;
    }

    int getMaxElementsPerNode() {
        return this.ordinalSet.getMaxElementsPerNode();
    }

    long approxHeapFootprintInBytes() {
        return this.nodes.approxHeapFootprintInBytes() + this.ordinalSet.approxHeapFootprintInBytes();
    }

    private static enum NodeType {
        Left,
        Right,
        Middle;

    }
}

