/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.HollowHashIndexField;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.TestableUniqueKeyIndex;
import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HollowUniqueKeyIndex
implements HollowTypeStateListener,
TestableUniqueKeyIndex {
    private static final Logger LOG = Logger.getLogger(HollowUniqueKeyIndex.class.getName());
    private final HollowObjectTypeDataAccess objectTypeDataAccess;
    private final HollowHashIndexField[] fields;
    private final PrimaryKey primaryKey;
    private final ArraySegmentRecycler memoryRecycler;
    private final BitSet specificOrdinalsToIndex;
    private volatile HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTableVolatile;
    private static final boolean ALLOW_DELTA_UPDATE = Boolean.getBoolean("com.netflix.hollow.core.index.HollowUniqueKeyIndex.allowDeltaUpdate");

    public HollowUniqueKeyIndex(HollowDataAccess hollowDataAccess, String type, String ... fieldPaths) {
        this(hollowDataAccess, WastefulRecycler.DEFAULT_INSTANCE, type, fieldPaths);
    }

    public HollowUniqueKeyIndex(HollowDataAccess hollowDataAccess, PrimaryKey primaryKey) {
        this(hollowDataAccess, primaryKey, WastefulRecycler.DEFAULT_INSTANCE);
    }

    public HollowUniqueKeyIndex(HollowDataAccess hollowDataAccess, ArraySegmentRecycler memoryRecycler, String type, String ... fieldPaths) {
        this(hollowDataAccess, PrimaryKey.create(hollowDataAccess, type, fieldPaths), memoryRecycler);
    }

    public HollowUniqueKeyIndex(HollowDataAccess hollowDataAccess, PrimaryKey primaryKey, ArraySegmentRecycler memoryRecycler) {
        this(hollowDataAccess, primaryKey, memoryRecycler, null);
    }

    public HollowUniqueKeyIndex(HollowDataAccess hollowDataAccess, PrimaryKey primaryKey, ArraySegmentRecycler memoryRecycler, BitSet specificOrdinalsToIndex) {
        Objects.requireNonNull(primaryKey, "Hollow Primary Key Index creation failed because primaryKey was null");
        Objects.requireNonNull(hollowDataAccess, "Hollow Primary Key Index creation for type [" + primaryKey.getType() + "] failed because read state wasn't initialized");
        this.primaryKey = primaryKey;
        this.objectTypeDataAccess = (HollowObjectTypeDataAccess)hollowDataAccess.getTypeDataAccess(primaryKey.getType());
        this.fields = new HollowHashIndexField[primaryKey.numFields()];
        this.memoryRecycler = memoryRecycler;
        for (int fieldIdx = 0; fieldIdx < primaryKey.numFields(); ++fieldIdx) {
            HollowObjectSchema.FieldType fieldType = primaryKey.getFieldType(hollowDataAccess, fieldIdx);
            HollowObjectTypeDataAccess currentDataAccess = this.objectTypeDataAccess;
            int[] fieldPathPositions = primaryKey.getFieldPathIndex(hollowDataAccess, fieldIdx);
            HollowHashIndexField.FieldPathSegment[] fieldPathElements = new HollowHashIndexField.FieldPathSegment[fieldPathPositions.length];
            for (int posIdx = 0; posIdx < fieldPathPositions.length; ++posIdx) {
                if (currentDataAccess == null) {
                    throw new IllegalArgumentException("Path " + primaryKey.getFieldPath(fieldIdx) + " traverses a non-reference type. Non-reference types must be the last element of the path.");
                }
                int fieldPosition = fieldPathPositions[posIdx];
                fieldPathElements[posIdx] = new HollowHashIndexField.FieldPathSegment(fieldPosition, currentDataAccess);
                String referencedType = currentDataAccess.getSchema().getReferencedType(fieldPosition);
                currentDataAccess = referencedType != null ? (HollowObjectTypeDataAccess)hollowDataAccess.getTypeDataAccess(referencedType) : null;
            }
            this.fields[fieldIdx] = new HollowHashIndexField(fieldIdx, fieldPathElements, currentDataAccess, fieldType);
        }
        this.specificOrdinalsToIndex = specificOrdinalsToIndex;
        this.reindex();
    }

    @Override
    public void listenForDeltaUpdates() {
        if (this.specificOrdinalsToIndex != null) {
            throw new IllegalStateException("Cannot listen for delta updates when indexing only specified ordinals!");
        }
        if (!(this.objectTypeDataAccess instanceof HollowObjectTypeReadState)) {
            throw new IllegalStateException("Cannot listen for delta updates when objectTypeDataAccess is a " + this.objectTypeDataAccess.getClass().getSimpleName() + ". You may have created this index from a Data Access instance that has object longevity enabled.");
        }
        ((HollowObjectTypeReadState)this.objectTypeDataAccess).addListener(this);
    }

    public void detachFromDeltaUpdates() {
        if (this.objectTypeDataAccess instanceof HollowObjectTypeReadState) {
            ((HollowObjectTypeReadState)this.objectTypeDataAccess).removeListener(this);
        }
    }

    public HollowObjectTypeDataAccess getObjectTypeDataAccess() {
        return this.objectTypeDataAccess;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public List<HollowObjectSchema.FieldType> getFieldTypes() {
        return Arrays.stream(this.fields).map(HollowHashIndexField::getFieldType).collect(Collectors.toList());
    }

    @Override
    public int getMatchingOrdinal(Object key) {
        if (this.isProvidedKeyCountNotEqualToIndexedFieldsCount(1)) {
            return -1;
        }
        return this.getMatchingOrdinalImpl(key, null, null);
    }

    @Override
    public int getMatchingOrdinal(Object key0, Object key1) {
        if (this.isProvidedKeyCountNotEqualToIndexedFieldsCount(2)) {
            return -1;
        }
        return this.getMatchingOrdinalImpl(key0, key1, null);
    }

    @Override
    public int getMatchingOrdinal(Object key0, Object key1, Object key2) {
        if (this.isProvidedKeyCountNotEqualToIndexedFieldsCount(3)) {
            return -1;
        }
        return this.getMatchingOrdinalImpl(key0, key1, key2);
    }

    private int getMatchingOrdinalImpl(Object key0, Object key1, Object key2) {
        int ordinal;
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable;
        int fieldCount = this.fields.length;
        int hashCode = HollowUniqueKeyIndex.generateKeyHashCode(key0, this.fields[0].getFieldType());
        if (fieldCount >= 2) {
            hashCode ^= HollowUniqueKeyIndex.generateKeyHashCode(key1, this.fields[1].getFieldType());
            if (fieldCount == 3) {
                hashCode ^= HollowUniqueKeyIndex.generateKeyHashCode(key2, this.fields[2].getFieldType());
            }
        }
        do {
            hashTable = this.hashTableVolatile;
            int bucket = hashCode & hashTable.hashMask;
            ordinal = this.readOrdinal(hashTable, bucket);
            while (ordinal != -1 && (!this.keyMatches(key0, ordinal, 0) || fieldCount >= 2 && !this.keyMatches(key1, ordinal, 1) || fieldCount >= 3 && !this.keyMatches(key2, ordinal, 2))) {
                ++bucket;
                ordinal = this.readOrdinal(hashTable, bucket &= hashTable.hashMask);
            }
        } while (this.hashTableVolatile != hashTable);
        return ordinal;
    }

    public int getMatchingOrdinal(Object ... keys) {
        int ordinal;
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable;
        if (this.isProvidedKeyCountNotEqualToIndexedFieldsCount(keys.length)) {
            return -1;
        }
        int hashCode = 0;
        for (int fieldIdx = 0; fieldIdx < keys.length; ++fieldIdx) {
            hashCode ^= HollowUniqueKeyIndex.generateKeyHashCode(keys[fieldIdx], this.fields[fieldIdx].getFieldType());
        }
        do {
            hashTable = this.hashTableVolatile;
            int bucket = hashCode & hashTable.hashMask;
            ordinal = this.readOrdinal(hashTable, bucket);
            while (ordinal != -1 && !this.keysAllMatch(ordinal, keys)) {
                ++bucket;
                ordinal = this.readOrdinal(hashTable, bucket &= hashTable.hashMask);
            }
        } while (this.hashTableVolatile != hashTable);
        return ordinal;
    }

    private boolean isProvidedKeyCountNotEqualToIndexedFieldsCount(int keyCount) {
        return this.fields.length != keyCount || this.hashTableVolatile.bitsPerElement == 0;
    }

    private int readOrdinal(HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable, int bucket) {
        return (int)hashTable.hashTable.getElementValue((long)hashTable.bitsPerElement * (long)bucket, hashTable.bitsPerElement) - 1;
    }

    private static int generateKeyHashCode(Object key, HollowObjectSchema.FieldType fieldType) {
        switch (fieldType) {
            case BOOLEAN: {
                return HashCodes.hashInt(HollowReadFieldUtils.booleanHashCode((Boolean)key));
            }
            case DOUBLE: {
                return HashCodes.hashInt(HollowReadFieldUtils.doubleHashCode((Double)key));
            }
            case FLOAT: {
                return HashCodes.hashInt(HollowReadFieldUtils.floatHashCode(((Float)key).floatValue()));
            }
            case INT: {
                return HashCodes.hashInt(HollowReadFieldUtils.intHashCode((Integer)key));
            }
            case LONG: {
                return HashCodes.hashInt(HollowReadFieldUtils.longHashCode((Long)key));
            }
            case REFERENCE: {
                return HashCodes.hashInt((Integer)key);
            }
            case BYTES: {
                return HashCodes.hashCode((byte[])key);
            }
            case STRING: {
                return HashCodes.hashCode((String)key);
            }
        }
        throw new IllegalArgumentException("I don't know how to hash a " + (Object)((Object)fieldType));
    }

    private void setHashTable(HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable) {
        this.hashTableVolatile = hashTable;
    }

    @Override
    public boolean containsDuplicates() {
        return !this.getDuplicateKeys().isEmpty();
    }

    @Override
    public synchronized Collection<Object[]> getDuplicateKeys() {
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (hashTable.bitsPerElement == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> duplicateKeys = new ArrayList<Object[]>();
        for (int i = 0; i < hashTable.hashTableSize; ++i) {
            int ordinal = (int)hashTable.hashTable.getElementValue((long)i * (long)hashTable.bitsPerElement, hashTable.bitsPerElement) - 1;
            if (ordinal == -1) continue;
            int compareBucket = i + 1 & hashTable.hashMask;
            int compareOrdinal = (int)hashTable.hashTable.getElementValue((long)compareBucket * (long)hashTable.bitsPerElement, hashTable.bitsPerElement) - 1;
            while (compareOrdinal != -1) {
                if (this.recordsHaveEqualKeys(ordinal, compareOrdinal)) {
                    duplicateKeys.add(this.getRecordKey(ordinal));
                }
                compareBucket = compareBucket + 1 & hashTable.hashMask;
                compareOrdinal = (int)hashTable.hashTable.getElementValue((long)compareBucket * (long)hashTable.bitsPerElement, hashTable.bitsPerElement) - 1;
            }
        }
        return duplicateKeys;
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void addedOrdinal(int ordinal) {
    }

    @Override
    public void removedOrdinal(int ordinal) {
    }

    @Override
    public synchronized void endUpdate() {
        HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)this.objectTypeDataAccess.getTypeState();
        BitSet ordinals = typeState.getPopulatedOrdinals();
        int hashTableSize = HashCodes.hashTableSize(ordinals.cardinality());
        int bitsPerElement = 32 - Integer.numberOfLeadingZeros(typeState.maxOrdinal() + 1);
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (ALLOW_DELTA_UPDATE && hashTableSize == hashTable.hashTableSize && bitsPerElement == hashTable.bitsPerElement && this.shouldPerformDeltaUpdate()) {
            try {
                this.deltaUpdate(hashTableSize, bitsPerElement);
            }
            catch (OrdinalNotFoundException e) {
                LOG.log(Level.SEVERE, "Delta update of index failed.  Performing a full reindex", e);
                this.reindex();
            }
        } else {
            this.reindex();
        }
    }

    public void destroy() {
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (hashTable != null) {
            hashTable.hashTable.destroy(this.memoryRecycler);
        }
    }

    private synchronized void reindex() {
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        if (hashTable != null) {
            hashTable.hashTable.destroy(this.memoryRecycler);
        }
        HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)this.objectTypeDataAccess.getTypeState();
        BitSet ordinals = this.specificOrdinalsToIndex;
        if (ordinals == null) {
            ordinals = typeState.getPopulatedOrdinals();
        }
        int hashTableSize = HashCodes.hashTableSize(ordinals.cardinality());
        int bitsPerElement = 32 - Integer.numberOfLeadingZeros(typeState.maxOrdinal() + 1);
        FixedLengthElementArray hashedArray = new FixedLengthElementArray(this.memoryRecycler, (long)hashTableSize * (long)bitsPerElement);
        int hashMask = hashTableSize - 1;
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            int hashCode = this.generateRecordHash(ordinal);
            int bucket = hashCode & hashMask;
            while (hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) != 0L) {
                bucket = bucket + 1 & hashMask;
            }
            hashedArray.setElementValue((long)bucket * (long)bitsPerElement, bitsPerElement, ordinal + 1);
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        this.setHashTable(new HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable(hashedArray, hashTableSize, hashMask, bitsPerElement));
        this.memoryRecycler.swap();
    }

    private void deltaUpdate(int hashTableSize, int bitsPerElement) {
        HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable hashTable = this.hashTableVolatile;
        hashTable.hashTable.destroy(this.memoryRecycler);
        HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)this.objectTypeDataAccess.getTypeState();
        BitSet prevOrdinals = typeState.getPreviousOrdinals();
        BitSet ordinals = typeState.getPopulatedOrdinals();
        long totalBitsInHashTable = (long)hashTableSize * (long)bitsPerElement;
        FixedLengthElementArray hashedArray = new FixedLengthElementArray(this.memoryRecycler, totalBitsInHashTable);
        hashedArray.copyBits(hashTable.hashTable, 0L, 0L, totalBitsInHashTable);
        int hashMask = hashTableSize - 1;
        int prevOrdinal = prevOrdinals.nextSetBit(0);
        while (prevOrdinal != -1) {
            if (!ordinals.get(prevOrdinal)) {
                int hashCode = this.generateRecordHash(prevOrdinal);
                int bucket = this.findOrdinalBucket(bitsPerElement, hashedArray, hashCode, hashMask, prevOrdinal);
                hashedArray.clearElementValue((long)bucket * (long)bitsPerElement, bitsPerElement);
                int emptyBucket = bucket;
                bucket = bucket + 1 & hashMask;
                int moveOrdinal = (int)hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) - 1;
                while (moveOrdinal != -1) {
                    int naturalHash = this.generateRecordHash(moveOrdinal);
                    int naturalBucket = naturalHash & hashMask;
                    if (!this.bucketInRange(emptyBucket, bucket, naturalBucket)) {
                        hashedArray.setElementValue((long)emptyBucket * (long)bitsPerElement, bitsPerElement, moveOrdinal + 1);
                        hashedArray.clearElementValue((long)bucket * (long)bitsPerElement, bitsPerElement);
                        emptyBucket = bucket;
                    }
                    bucket = bucket + 1 & hashMask;
                    moveOrdinal = (int)hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) - 1;
                }
            }
            prevOrdinal = prevOrdinals.nextSetBit(prevOrdinal + 1);
        }
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            if (!prevOrdinals.get(ordinal)) {
                int hashCode = this.generateRecordHash(ordinal);
                int bucket = hashCode & hashMask;
                while (hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement) != 0L) {
                    bucket = bucket + 1 & hashMask;
                }
                hashedArray.setElementValue((long)bucket * (long)bitsPerElement, bitsPerElement, ordinal + 1);
            }
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        this.setHashTable(new HollowPrimaryKeyIndex.PrimaryKeyIndexHashTable(hashedArray, hashTableSize, hashMask, bitsPerElement));
        this.memoryRecycler.swap();
    }

    private int findOrdinalBucket(int bitsPerElement, FixedLengthElementArray hashedArray, int hashCode, int hashMask, int prevOrdinal) {
        long value;
        int startBucket;
        int bucket = startBucket = hashCode & hashMask;
        do {
            if ((long)(prevOrdinal + 1) == (value = hashedArray.getElementValue((long)bucket * (long)bitsPerElement, bitsPerElement))) {
                return bucket;
            }
            bucket = bucket + 1 & hashMask;
        } while (value != 0L && bucket != startBucket);
        if (value == 0L) {
            throw new OrdinalNotFoundException(String.format("Ordinal not found (found empty entry): ordinal=%d startBucket=%d", prevOrdinal, startBucket));
        }
        throw new OrdinalNotFoundException(String.format("Ordinal not found (wrapped around table): ordinal=%d startBucket=%d", prevOrdinal, startBucket));
    }

    private boolean bucketInRange(int fromBucket, int toBucket, int testBucket) {
        if (toBucket > fromBucket) {
            return testBucket > fromBucket && testBucket <= toBucket;
        }
        return testBucket > fromBucket || testBucket <= toBucket;
    }

    private int generateRecordHash(int ordinal) {
        int hashCode = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            hashCode ^= this.generateFieldHash(ordinal, i);
        }
        return hashCode;
    }

    private int generateFieldHash(int ordinal, int fieldIdx) {
        HollowHashIndexField field = this.fields[fieldIdx];
        int lastPathIdx = field.getSchemaFieldPositionPath().length - 1;
        for (int pathIdx = 0; pathIdx < lastPathIdx; ++pathIdx) {
            HollowHashIndexField.FieldPathSegment pathElement = field.getSchemaFieldPositionPath()[pathIdx];
            ordinal = pathElement.getOrdinalForField(ordinal);
        }
        HollowHashIndexField.FieldPathSegment lastPathElement = field.getLastFieldPositionPathElement();
        int hashCode = HollowReadFieldUtils.fieldHashCode(lastPathElement.getObjectTypeDataAccess(), ordinal, lastPathElement.getSegmentFieldPosition());
        switch (field.getFieldType()) {
            case BYTES: 
            case STRING: {
                return hashCode;
            }
        }
        return HashCodes.hashInt(hashCode);
    }

    @Override
    public Object[] getRecordKey(int ordinal) {
        Object[] results = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            HollowHashIndexField field = this.fields[i];
            int lastPathOrdinal = this.getOrdinalForFieldPath(field, ordinal);
            HollowHashIndexField.FieldPathSegment lastElement = field.getLastFieldPositionPathElement();
            results[i] = HollowReadFieldUtils.fieldValueObject(lastElement.getObjectTypeDataAccess(), lastPathOrdinal, lastElement.getSegmentFieldPosition());
        }
        return results;
    }

    private int getOrdinalForFieldPath(HollowHashIndexField field, int ordinal) {
        HollowHashIndexField.FieldPathSegment[] pathElements = field.getSchemaFieldPositionPath();
        for (int posIdx = 0; posIdx < pathElements.length - 1; ++posIdx) {
            HollowHashIndexField.FieldPathSegment fieldPathElement = pathElements[posIdx];
            ordinal = fieldPathElement.getOrdinalForField(ordinal);
        }
        return ordinal;
    }

    private boolean keysAllMatch(int ordinal, Object ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            if (this.keyMatches(keys[i], ordinal, i)) continue;
            return false;
        }
        return true;
    }

    private boolean keyMatches(Object key, int recordOrdinal, int fieldIdx) {
        HollowHashIndexField field = this.fields[fieldIdx];
        int lastElementOrdinal = this.getOrdinalForFieldPath(field, recordOrdinal);
        HollowHashIndexField.FieldPathSegment lastPathElement = field.getLastFieldPositionPathElement();
        int lastPathPosition = lastPathElement.getSegmentFieldPosition();
        HollowObjectTypeDataAccess typeDataAccess = lastPathElement.getObjectTypeDataAccess();
        return HollowPrimaryKeyValueDeriver.keyMatches(key, field.getFieldType(), lastPathPosition, lastElementOrdinal, typeDataAccess);
    }

    private boolean recordsHaveEqualKeys(int ordinal1, int ordinal2) {
        for (int fieldIdx = 0; fieldIdx < this.fields.length; ++fieldIdx) {
            if (this.fieldsAreEqual(ordinal1, ordinal2, fieldIdx)) continue;
            return false;
        }
        return true;
    }

    private boolean fieldsAreEqual(int ordinal1, int ordinal2, int fieldIdx) {
        HollowHashIndexField field = this.fields[fieldIdx];
        HollowHashIndexField.FieldPathSegment[] fieldPathElements = field.getSchemaFieldPositionPath();
        for (int posIdx = 0; posIdx < fieldPathElements.length - 1; ++posIdx) {
            HollowHashIndexField.FieldPathSegment pathElement = fieldPathElements[posIdx];
            ordinal1 = pathElement.getOrdinalForField(ordinal1);
            ordinal2 = pathElement.getOrdinalForField(ordinal2);
        }
        if (field.getFieldType() == HollowObjectSchema.FieldType.REFERENCE) {
            return ordinal1 == ordinal2;
        }
        HollowHashIndexField.FieldPathSegment lastPathElement = field.getLastFieldPositionPathElement();
        return HollowReadFieldUtils.fieldsAreEqual(lastPathElement.getObjectTypeDataAccess(), ordinal1, lastPathElement.getSegmentFieldPosition(), lastPathElement.getObjectTypeDataAccess(), ordinal2, lastPathElement.getSegmentFieldPosition());
    }

    private boolean shouldPerformDeltaUpdate() {
        HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)this.objectTypeDataAccess.getTypeState();
        BitSet previousOrdinals = typeState.getPreviousOrdinals();
        BitSet ordinals = typeState.getPopulatedOrdinals();
        int prevCardinality = 0;
        int removedRecords = 0;
        int prevOrdinal = previousOrdinals.nextSetBit(0);
        while (prevOrdinal != -1) {
            ++prevCardinality;
            if (!ordinals.get(prevOrdinal)) {
                ++removedRecords;
            }
            prevOrdinal = previousOrdinals.nextSetBit(prevOrdinal + 1);
        }
        return !((double)removedRecords > (double)prevCardinality * 0.1);
    }

    private static class OrdinalNotFoundException
    extends IllegalStateException {
        public OrdinalNotFoundException(String message) {
            super(message);
        }
    }
}

