/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.FieldPath;
import com.netflix.hollow.core.index.TST;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@Deprecated
public class HollowPrefixIndex
implements HollowTypeStateListener {
    private static final Logger LOG = Logger.getLogger(HollowPrefixIndex.class.getName());
    private final FieldPath fieldPath;
    private final HollowReadStateEngine readStateEngine;
    private final String type;
    private final int estimatedMaxStringDuplicates;
    private final boolean caseSensitive;
    private volatile TST prefixIndexVolatile;
    private ArraySegmentRecycler memoryRecycle;
    private int totalWords;
    private int averageWordLen;
    private int maxOrdinalOfType;
    private boolean buildIndexOnUpdate;

    public HollowPrefixIndex(HollowReadStateEngine readStateEngine, String type, String fieldPath) {
        this(readStateEngine, type, fieldPath, 1, false);
    }

    public HollowPrefixIndex(HollowReadStateEngine readStateEngine, String type, String fieldPath, int estimatedMaxStringDuplicates, boolean caseSensitive) {
        Objects.requireNonNull(type, "Hollow Prefix Key Index creation failed because type was null");
        Objects.requireNonNull(readStateEngine, "Hollow Prefix Key Index creation for type [" + type + "] failed because read state wasn't initialized");
        if (fieldPath == null || fieldPath.isEmpty()) {
            throw new IllegalArgumentException("fieldPath cannot be null or empty");
        }
        if (estimatedMaxStringDuplicates < 1) {
            throw new IllegalArgumentException("estimatedMaxStringDuplicates cannot be < 1");
        }
        this.readStateEngine = readStateEngine;
        this.type = type;
        this.estimatedMaxStringDuplicates = estimatedMaxStringDuplicates;
        this.caseSensitive = caseSensitive;
        this.fieldPath = new FieldPath(readStateEngine, type, fieldPath);
        if (!this.fieldPath.getLastFieldType().equals((Object)HollowObjectSchema.FieldType.STRING)) {
            throw new IllegalArgumentException("Field path should lead to a string type");
        }
        this.memoryRecycle = WastefulRecycler.DEFAULT_INSTANCE;
        this.buildIndexOnUpdate = true;
        this.initialize();
    }

    private void initialize() {
        String lastRefType = this.fieldPath.getLastRefTypeInPath();
        this.totalWords = this.readStateEngine.getTypeState(lastRefType).getPopulatedOrdinals().cardinality();
        this.averageWordLen = 0;
        double avg = 0.0;
        HollowObjectTypeReadState objectTypeReadState = (HollowObjectTypeReadState)this.readStateEngine.getTypeState(lastRefType);
        BitSet keyBitSet = objectTypeReadState.getPopulatedOrdinals();
        int ordinal = keyBitSet.nextSetBit(0);
        while (ordinal != -1) {
            avg += (double)objectTypeReadState.readString(ordinal, 0).length() / (double)this.totalWords;
            ordinal = keyBitSet.nextSetBit(ordinal + 1);
        }
        this.averageWordLen = (int)Math.ceil(avg);
        HollowObjectTypeReadState valueState = (HollowObjectTypeReadState)this.readStateEngine.getTypeDataAccess(this.type);
        this.maxOrdinalOfType = valueState.maxOrdinal();
        this.build();
    }

    private void build() {
        if (!this.buildIndexOnUpdate) {
            return;
        }
        TST current = this.prefixIndexVolatile;
        if (current != null) {
            current.recycleMemory(this.memoryRecycle);
        }
        long estimatedMaxNodes = this.estimateNumNodes(this.totalWords, this.averageWordLen);
        TST tst = new TST(estimatedMaxNodes, this.estimatedMaxStringDuplicates, this.maxOrdinalOfType, this.caseSensitive, this.memoryRecycle);
        BitSet ordinals = this.readStateEngine.getTypeState(this.type).getPopulatedOrdinals();
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            for (String key : this.getKeys(ordinal, this.caseSensitive)) {
                tst.insert(key, ordinal);
            }
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        this.prefixIndexVolatile = tst;
        this.memoryRecycle.swap();
        this.buildIndexOnUpdate = false;
        Stats stats = this.usageStats();
        LOG.info("Prefix index built with stats= [" + stats + "]");
    }

    protected long estimateNumNodes(long totalWords, long averageWordLen) {
        return totalWords * averageWordLen;
    }

    protected String[] getKeys(int ordinal, boolean caseSensitive) {
        Object[] values = this.fieldPath.findValues(ordinal);
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = caseSensitive ? (String)values[i] : ((String)values[i]).toLowerCase();
        }
        return stringValues;
    }

    @Deprecated
    protected String[] getKeys(int ordinal) {
        return this.getKeys(ordinal, false);
    }

    public HollowOrdinalIterator findKeysWithPrefix(String prefix) {
        HollowOrdinalIterator it;
        TST current;
        do {
            current = this.prefixIndexVolatile;
            it = current.findKeysWithPrefix(prefix);
        } while (current != this.prefixIndexVolatile);
        return it;
    }

    public List<Integer> findLongestMatch(String key) {
        List<Integer> ordinals;
        TST current;
        do {
            current = this.prefixIndexVolatile;
            long nodeIndex = current.findLongestMatch(key);
            ordinals = current.getOrdinals(nodeIndex);
        } while (current != this.prefixIndexVolatile);
        return ordinals;
    }

    public boolean contains(String key) {
        boolean result;
        TST current;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        do {
            current = this.prefixIndexVolatile;
            result = current.contains(key);
        } while (current != this.prefixIndexVolatile);
        return result;
    }

    public void listenForDeltaUpdates() {
        this.readStateEngine.getTypeState(this.type).addListener(this);
    }

    public void detachFromDeltaUpdates() {
        this.readStateEngine.getTypeState(this.type).removeListener(this);
    }

    @Override
    public void beginUpdate() {
    }

    @Override
    public void addedOrdinal(int ordinal) {
        this.buildIndexOnUpdate = true;
    }

    @Override
    public void removedOrdinal(int ordinal) {
        this.buildIndexOnUpdate = true;
    }

    @Override
    public void endUpdate() {
        this.initialize();
    }

    public Stats usageStats() {
        Stats stats = new Stats();
        stats.nodesCapacity = this.prefixIndexVolatile.getMaxNodes();
        stats.nodesUsed = this.prefixIndexVolatile.getNumNodes();
        stats.nodesEmpty = this.prefixIndexVolatile.getEmptyNodes();
        stats.worstCaseLookups = this.prefixIndexVolatile.getMaxDepth();
        stats.maxValuesPerNode = this.prefixIndexVolatile.getMaxElementsPerNode();
        stats.approxHeapFootprintInBytes = this.prefixIndexVolatile.approxHeapFootprintInBytes();
        return stats;
    }

    public static class Stats {
        long nodesCapacity;
        long nodesUsed;
        long nodesEmpty;
        long worstCaseLookups;
        int maxValuesPerNode;
        long approxHeapFootprintInBytes;

        public String toString() {
            return "nodesCapacity=" + this.nodesCapacity + ", nodesUsed=" + this.nodesUsed + ", nodesEmpty=" + this.nodesEmpty + ", worstCaseLookups=" + this.worstCaseLookups + ", maxValuesPerNode=" + this.maxValuesPerNode + ", approxHeapFootprintInBytes=" + this.approxHeapFootprintInBytes;
        }
    }
}

