/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class FieldPaths {
    private static final Logger LOG = Logger.getLogger(FieldPaths.class.getName());

    public static FieldPath<ObjectFieldSegment> createFieldPathForPrimaryKey(HollowDataset dataset, String type, String path) {
        boolean autoExpand = !path.endsWith("!");
        path = autoExpand ? path : path.substring(0, path.length() - 1);
        FieldPath<FieldSegment> fp = FieldPaths.createFieldPath(dataset, type, path, autoExpand, false, false);
        assert (fp.segments.stream().allMatch(o -> o instanceof ObjectFieldSegment));
        FieldPath<FieldSegment> result = fp;
        return result;
    }

    public static FieldPath<FieldSegment> createFieldPathForHashIndex(HollowDataset dataset, String type, String path) {
        return FieldPaths.createFieldPath(dataset, type, path, false, false, true);
    }

    public static FieldPath<FieldSegment> createFieldPathForPrefixIndex(HollowDataset dataset, String type, String path, boolean autoExpand) {
        boolean requireFullPath = !autoExpand;
        return FieldPaths.createFieldPath(dataset, type, path, autoExpand, requireFullPath, true);
    }

    static FieldPath<FieldSegment> createFieldPath(HollowDataset dataset, String type, String path, boolean autoExpand, boolean requireFullPath, boolean traverseSequences) {
        Objects.requireNonNull(dataset);
        Objects.requireNonNull(type);
        Objects.requireNonNull(path);
        String[] segments = path.isEmpty() ? new String[]{} : path.split("\\.");
        ArrayList<FieldSegment> fieldSegments = new ArrayList<FieldSegment>();
        String segmentType = type;
        for (int i = 0; i < segments.length; ++i) {
            HollowSchema schema = dataset.getSchema(segmentType);
            if (schema == null) {
                LOG.log(Level.WARNING, FieldPathException.message(FieldPathException.ErrorKind.NOT_BINDABLE, dataset, type, segments, fieldSegments, null, i));
                throw new FieldPathException(FieldPathException.ErrorKind.NOT_BINDABLE, dataset, type, segments, fieldSegments, null, i);
            }
            String segment = segments[i];
            HollowSchema.SchemaType schemaType = schema.getSchemaType();
            if (schemaType == HollowSchema.SchemaType.OBJECT) {
                HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
                int index = objectSchema.getPosition(segment);
                if (index == -1) {
                    throw new FieldPathException(FieldPathException.ErrorKind.NOT_FOUND, dataset, type, segments, fieldSegments, schema, i);
                }
                segmentType = objectSchema.getReferencedType(index);
                fieldSegments.add(new ObjectFieldSegment(objectSchema, segment, segmentType, index));
            } else if (traverseSequences && (schemaType == HollowSchema.SchemaType.SET || schemaType == HollowSchema.SchemaType.LIST)) {
                HollowCollectionSchema collectionSchema = (HollowCollectionSchema)schema;
                if (!segment.equals("element")) {
                    throw new FieldPathException(FieldPathException.ErrorKind.NOT_FOUND, dataset, type, segments, fieldSegments, schema, i);
                }
                segmentType = collectionSchema.getElementType();
                fieldSegments.add(new FieldSegment(collectionSchema, segment, segmentType));
            } else if (traverseSequences && schemaType == HollowSchema.SchemaType.MAP) {
                HollowMapSchema mapSchema = (HollowMapSchema)schema;
                if (segment.equals("key")) {
                    segmentType = mapSchema.getKeyType();
                } else if (segment.equals("value")) {
                    segmentType = mapSchema.getValueType();
                } else {
                    throw new FieldPathException(FieldPathException.ErrorKind.NOT_FOUND, dataset, type, segments, fieldSegments, schema, i);
                }
                fieldSegments.add(new FieldSegment(mapSchema, segment, segmentType));
            } else if (!traverseSequences) {
                throw new FieldPathException(FieldPathException.ErrorKind.NOT_TRAVERSABLE, dataset, type, segments, fieldSegments, schema, i);
            }
            if (i >= segments.length - 1 || segmentType != null) continue;
            throw new FieldPathException(FieldPathException.ErrorKind.NOT_TRAVERSABLE, dataset, type, segments, fieldSegments, schema, i);
        }
        if (autoExpand) {
            while (segmentType != null) {
                HollowSchema schema = dataset.getSchema(segmentType);
                if (schema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
                    HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
                    if (objectSchema.numFields() == 1) {
                        segmentType = objectSchema.getReferencedType(0);
                        fieldSegments.add(new ObjectFieldSegment(objectSchema, objectSchema.getFieldName(0), segmentType, 0));
                        continue;
                    }
                    if (objectSchema.getPrimaryKey() != null && objectSchema.getPrimaryKey().numFields() == 1) {
                        FieldPath<ObjectFieldSegment> expandedFieldSegments;
                        PrimaryKey key = objectSchema.getPrimaryKey();
                        try {
                            expandedFieldSegments = FieldPaths.createFieldPathForPrimaryKey(dataset, key.getType(), key.getFieldPaths()[0]);
                        }
                        catch (FieldPathException cause) {
                            FieldPathException e = new FieldPathException(FieldPathException.ErrorKind.NOT_EXPANDABLE, dataset, type, segments, fieldSegments, objectSchema);
                            e.initCause(cause);
                            throw e;
                        }
                        fieldSegments.addAll(expandedFieldSegments.segments);
                        break;
                    }
                    throw new FieldPathException(FieldPathException.ErrorKind.NOT_EXPANDABLE, dataset, type, segments, fieldSegments, objectSchema);
                }
                throw new FieldPathException(FieldPathException.ErrorKind.NOT_EXPANDABLE, dataset, type, segments, fieldSegments, schema);
            }
        } else if (requireFullPath && segmentType != null) {
            throw new FieldPathException(FieldPathException.ErrorKind.NOT_FULL, dataset, type, segments, fieldSegments);
        }
        return new FieldPath<FieldSegment>(type, fieldSegments, !autoExpand);
    }

    public static final class ObjectFieldSegment
    extends FieldSegment {
        final int index;
        final HollowObjectSchema.FieldType type;

        ObjectFieldSegment(HollowObjectSchema enclosingSchema, String name, String typeName, int index) {
            super(enclosingSchema, name, typeName);
            this.index = index;
            this.type = enclosingSchema.getFieldType(index);
        }

        @Override
        public HollowObjectSchema getEnclosingSchema() {
            return (HollowObjectSchema)super.getEnclosingSchema();
        }

        public int getIndex() {
            return this.index;
        }

        public HollowObjectSchema.FieldType getType() {
            return this.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ObjectFieldSegment that = (ObjectFieldSegment)o;
            return this.index == that.index && this.type == that.type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.index, this.type});
        }
    }

    public static class FieldSegment {
        final HollowSchema enclosingSchema;
        final String name;
        final String typeName;

        FieldSegment(HollowSchema enclosingSchema, String name, String typeName) {
            this.name = name;
            this.typeName = typeName;
            this.enclosingSchema = enclosingSchema;
        }

        public HollowSchema getEnclosingSchema() {
            return this.enclosingSchema;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldSegment that = (FieldSegment)o;
            return Objects.equals(this.enclosingSchema, that.enclosingSchema) && Objects.equals(this.name, that.name) && Objects.equals(this.typeName, that.typeName);
        }

        public int hashCode() {
            return Objects.hash(this.enclosingSchema, this.name, this.typeName);
        }
    }

    public static final class FieldPath<T extends FieldSegment> {
        final String rootType;
        final List<T> segments;
        final boolean noAutoExpand;

        FieldPath(String rootType, List<T> segments, boolean noAutoExpand) {
            this.rootType = rootType;
            this.segments = Collections.unmodifiableList(segments);
            this.noAutoExpand = noAutoExpand;
        }

        public String getRootType() {
            return this.rootType;
        }

        public List<T> getSegments() {
            return this.segments;
        }

        public String toString() {
            String path = this.segments.stream().map(FieldSegment::getName).collect(Collectors.joining("."));
            return this.noAutoExpand ? path + "!" : path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldPath fieldPath = (FieldPath)o;
            return this.noAutoExpand == fieldPath.noAutoExpand && this.rootType.equals(fieldPath.rootType) && this.segments.equals(fieldPath.segments);
        }

        public int hashCode() {
            return Objects.hash(this.rootType, this.segments, this.noAutoExpand);
        }
    }

    public static final class FieldPathException
    extends IllegalArgumentException {
        public final ErrorKind error;
        final String rootType;
        final String[] segments;
        final List<FieldSegment> fieldSegments;
        final HollowSchema enclosingSchema;
        final int segmentIndex;

        FieldPathException(ErrorKind error, HollowDataset dataset, String rootType, String[] segments, List<FieldSegment> fieldSegments) {
            this(error, dataset, rootType, segments, fieldSegments, null, segments.length);
        }

        FieldPathException(ErrorKind error, HollowDataset dataset, String rootType, String[] segments, List<FieldSegment> fieldSegments, HollowSchema enclosingSchema) {
            this(error, dataset, rootType, segments, fieldSegments, enclosingSchema, segments.length);
        }

        FieldPathException(ErrorKind error, HollowDataset dataset, String rootType, String[] segments, List<FieldSegment> fieldSegments, HollowSchema enclosingSchema, int segmentIndex) {
            super(FieldPathException.message(error, dataset, rootType, segments, fieldSegments, enclosingSchema, segmentIndex));
            this.error = error;
            this.rootType = rootType;
            this.segments = segments;
            this.fieldSegments = Collections.unmodifiableList(fieldSegments);
            this.enclosingSchema = enclosingSchema;
            this.segmentIndex = segmentIndex;
        }

        static String message(ErrorKind error, HollowDataset dataset, String rootType, String[] segments, List<FieldSegment> fieldSegments, HollowSchema enclosingSchema, int segmentIndex) {
            switch (error) {
                case NOT_BINDABLE: {
                    return String.format("Field path \"%s\" cannot be bound to data set %s. A schema of type named \"%s\" cannot be found for the last segment of the path prefix \"%s\".", FieldPathException.toPathString(segments), dataset, FieldPathException.getLastTypeName(rootType, fieldSegments), FieldPathException.toPathString(segments, segmentIndex + 1));
                }
                case NOT_FOUND: {
                    return String.format("Field path \"%s\" not found in data set %s. A schema of type named \"%s\" does not contain a field for the last segment of the path prefix \"%s\".", FieldPathException.toPathString(segments), dataset, enclosingSchema.getName(), FieldPathException.toPathString(segments, segmentIndex + 1));
                }
                case NOT_TRAVERSABLE: {
                    if (enclosingSchema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
                        return String.format("Field path \"%s\" is not traversable in data set %s. A non-object schema of type named \"%s\" and of schema type %s cannot be traversed for the last segment of the path prefix \"%s\".", new Object[]{FieldPathException.toPathString(segments), dataset, enclosingSchema.getName(), enclosingSchema.getSchemaType(), FieldPathException.toPathString(segments, segmentIndex + 1)});
                    }
                    return String.format("Field path \"%s\" is not traversable in data set %s. An object schema of type named \"%s\" cannot be traversed for the last segment of the path prefix \"%s\". The last segment of the path prefix refers to a value (non-reference) field.", FieldPathException.toPathString(segments), dataset, enclosingSchema.getName(), FieldPathException.toPathString(segments, segmentIndex + 1));
                }
                case NOT_FULL: {
                    return String.format("Field path \"%s\" is not a full path in data set %s. The last segment of the path is not a value (non-reference) field and refers to a reference field whose schema is of type named \"%s\"", FieldPathException.toPathString(segments), dataset, fieldSegments.get(fieldSegments.size() - 1).getTypeName());
                }
                case NOT_EXPANDABLE: {
                    HollowObjectSchema objectSchema;
                    if (enclosingSchema.getSchemaType() == HollowSchema.SchemaType.OBJECT && ((objectSchema = (HollowObjectSchema)enclosingSchema).numFields() != 1 || objectSchema.getPrimaryKey() == null || objectSchema.getPrimaryKey().numFields() != 1)) {
                        return String.format("Field path \"%s\" is not expandable in data set %s. An object schema of type named \"%s\" cannot be traversed for the last segment of the partially expanded path \"%s\". The schema contains more than one field, or has no primary key, or has a primary key with more than one field path.", FieldPathException.toPathString(segments), dataset, enclosingSchema.getName(), FieldPathException.toPathString(fieldSegments));
                    }
                    return String.format("Field path \"%s\" is not expandable in data set %s. A non-object schema of type named \"%s\" and of schema type %s cannot be traversed for the last segment of the partially expanded path \"%s\".", new Object[]{FieldPathException.toPathString(segments), dataset, enclosingSchema.getName(), enclosingSchema.getSchemaType(), FieldPathException.toPathString(fieldSegments)});
                }
            }
            throw new InternalError("Cannot reach here");
        }

        static String getLastTypeName(String rootType, List<FieldSegment> fieldSegments) {
            return fieldSegments.isEmpty() ? rootType : fieldSegments.get((int)(fieldSegments.size() - 1)).typeName;
        }

        static String toPathString(List<FieldSegment> segments) {
            return segments.stream().map(FieldSegment::getName).collect(Collectors.joining("."));
        }

        static String toPathString(String[] segments) {
            return FieldPathException.toPathString(segments, segments.length);
        }

        static String toPathString(String[] segments, int l) {
            return Arrays.stream(segments).limit(l).collect(Collectors.joining("."));
        }

        public static enum ErrorKind {
            NOT_BINDABLE,
            NOT_FOUND,
            NOT_FULL,
            NOT_TRAVERSABLE,
            NOT_EXPANDABLE;

        }
    }
}

