/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.testdata;

import com.netflix.hollow.api.testdata.HollowTestRecord;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.HollowMapWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import java.util.ArrayList;
import java.util.List;

public abstract class HollowTestMapRecord<T>
extends HollowTestRecord<T> {
    private final List<Entry<?>> entries = new ArrayList();

    protected HollowTestMapRecord(T parent) {
        super(parent);
    }

    protected void addEntry(Entry<? extends HollowTestRecord<?>> entry) {
        this.entries.add(entry);
    }

    public <T> Entry<T> getEntry(int idx) {
        return this.entries.get(idx);
    }

    @Override
    public HollowWriteRecord toWriteRecord(HollowWriteStateEngine writeEngine) {
        HollowMapWriteRecord rec = new HollowMapWriteRecord();
        for (Entry<?> entry : this.entries) {
            int keyOrdinal = ((Entry)entry).key.addTo(writeEngine);
            int valueOrdinal = ((Entry)entry).value.addTo(writeEngine);
            rec.addEntry(keyOrdinal, valueOrdinal);
        }
        return rec;
    }

    public static class Entry<T>
    extends HollowTestRecord<T> {
        private HollowTestRecord<?> key;
        private HollowTestRecord<?> value;

        public Entry(T parent) {
            super(parent);
        }

        protected void setKey(HollowTestRecord<?> key) {
            this.key = key;
        }

        protected void setValue(HollowTestRecord<?> value) {
            this.value = value;
        }

        public <T extends HollowTestRecord<?>> T getKey() {
            return (T)this.key;
        }

        public <T extends HollowTestRecord<?>> T getValue() {
            return (T)this.value;
        }

        @Override
        protected HollowSchema getSchema() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected HollowWriteRecord toWriteRecord(HollowWriteStateEngine writeEngine) {
            throw new UnsupportedOperationException();
        }
    }
}

