/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.sampling;

import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.SamplingStatusListener;
import com.netflix.hollow.core.util.Threads;
import java.util.ArrayList;
import java.util.List;

public class TimeSliceSamplingDirector
extends HollowSamplingDirector {
    private final List<SamplingStatusListener> listeners = new ArrayList<SamplingStatusListener>();
    private int msOff;
    private int msOn;
    private boolean isInPlay = false;
    private boolean record = false;

    public TimeSliceSamplingDirector() {
        this(1000, 1);
    }

    public TimeSliceSamplingDirector(int msOff, int msOn) {
        this.msOff = msOff;
        this.msOn = msOn;
    }

    @Override
    public boolean shouldRecord() {
        return this.record && !this.isUpdateThread();
    }

    public void startSampling() {
        if (!this.isInPlay) {
            this.isInPlay = true;
            Threads.daemonThread(new SampleToggler(), this.getClass(), "toggler").start();
        }
    }

    public void setTiming(int msOff, int msOn) {
        this.msOff = msOff;
        this.msOn = msOn;
    }

    public void stopSampling() {
        this.isInPlay = false;
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).samplingStatusChanged(this.record);
        }
    }

    public void addSamplingStatusListener(SamplingStatusListener listener) {
        listener.samplingStatusChanged(this.record);
        this.listeners.add(listener);
    }

    private class SampleToggler
    implements Runnable {
        private SampleToggler() {
        }

        @Override
        public void run() {
            while (TimeSliceSamplingDirector.this.isInPlay) {
                TimeSliceSamplingDirector.this.record = false;
                TimeSliceSamplingDirector.this.notifyListeners();
                this.sleep(TimeSliceSamplingDirector.this.msOff);
                TimeSliceSamplingDirector.this.record = TimeSliceSamplingDirector.this.isInPlay;
                TimeSliceSamplingDirector.this.notifyListeners();
                this.sleep(TimeSliceSamplingDirector.this.msOn);
            }
            TimeSliceSamplingDirector.this.record = false;
            TimeSliceSamplingDirector.this.notifyListeners();
        }

        private void sleep(int ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

