/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import java.util.function.Supplier;

public class MinimumRecordCountValidator
implements ValidatorListener {
    private static final String INVALID_THRESHOLD = "Minimum record count validation for type %s has failed due to invalid threshold: %s";
    private static final String FAILED_MIN_RECORD_COUNT_VALIDATION = "Minimum record count validation for type %s has failed since the record count %s is less than the configured threshold of %s";
    private static final String DATA_TYPE_NAME = "Typename";
    private static final String ALLOWABLE_MIN_RECORD_COUNT_NAME = "AllowableMinRecordCount";
    private static final String RECORD_COUNT_NAME = "RecordCount";
    private final String typeName;
    private final Supplier<Integer> minRecordCountSupplier;

    public MinimumRecordCountValidator(String typeName, Supplier<Integer> minRecordCountSupplier) {
        this.typeName = typeName;
        this.minRecordCountSupplier = minRecordCountSupplier;
    }

    @Override
    public String getName() {
        return MinimumRecordCountValidator.class.getSimpleName() + "_" + this.typeName;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        ValidationResult.ValidationResultBuilder vrb = ValidationResult.from(this);
        Integer minRecordCount = this.minRecordCountSupplier.get();
        if (minRecordCount == null || minRecordCount < 0 || minRecordCount > 0x20000000) {
            String message = String.format(INVALID_THRESHOLD, this.typeName, minRecordCount);
            return vrb.error(new IllegalArgumentException(message));
        }
        vrb.detail(DATA_TYPE_NAME, this.typeName).detail(ALLOWABLE_MIN_RECORD_COUNT_NAME, minRecordCount);
        HollowTypeReadState typeState = readState.getStateEngine().getTypeState(this.typeName);
        int recordCount = typeState.getPopulatedOrdinals().cardinality();
        vrb.detail(RECORD_COUNT_NAME, recordCount);
        if (recordCount < minRecordCount) {
            String message = String.format(FAILED_MIN_RECORD_COUNT_VALIDATION, this.typeName, recordCount, minRecordCount);
            return vrb.failed(message);
        }
        return vrb.passed("MinimumRecordCount type=" + this.typeName + ", numRecords=" + recordCount + ", threshold=" + minRecordCount);
    }
}

