/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.objectmapper.HollowPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class DuplicateDataDetectionValidator
implements ValidatorListener {
    private static final String DUPLICATE_KEYS_FOUND_ERRRO_MSG_FORMAT = "Duplicate keys found for type %s. Primarykey in schema is %s. Duplicate IDs are: %s";
    private static final String NO_PRIMARY_KEY_ERROR_MSG_FORMAT = "DuplicateDataDetectionValidator defined but unable to find primary key for data type %s. Please check schema definition.";
    private static final String NO_SCHEMA_FOUND_MSG_FORMAT = "DuplicateDataDetectionValidator defined for data type %s but schema not found.Please check that the HollowProducer is initialized with the data type's schema (see initializeDataModel)";
    private static final String NOT_AN_OBJECT_ERROR_MSG_FORMAT = "DuplicateDataDetectionValidator is defined but schema type of %s is not Object. This validation cannot be done.";
    private static final String FIELD_PATH_NAME = "FieldPaths";
    private static final String DATA_TYPE_NAME = "Typename";
    private static final String NAME = DuplicateDataDetectionValidator.class.getName();
    private final String dataTypeName;
    private final String[] fieldPathNames;

    public DuplicateDataDetectionValidator(Class<?> dataType) {
        Objects.requireNonNull(dataType);
        if (!dataType.isAnnotationPresent(HollowPrimaryKey.class)) {
            throw new IllegalArgumentException("The data class " + dataType.getName() + " must be annotated with @HollowPrimaryKey");
        }
        this.dataTypeName = HollowTypeMapper.getDefaultTypeName(dataType);
        this.fieldPathNames = null;
    }

    public DuplicateDataDetectionValidator(String dataTypeName) {
        this.dataTypeName = Objects.requireNonNull(dataTypeName);
        this.fieldPathNames = null;
    }

    public DuplicateDataDetectionValidator(String dataTypeName, String[] fieldPathNames) {
        this.dataTypeName = Objects.requireNonNull(dataTypeName);
        this.fieldPathNames = (String[])fieldPathNames.clone();
    }

    @Override
    public String getName() {
        return NAME + "_" + this.dataTypeName;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        PrimaryKey primaryKey;
        ValidationResult.ValidationResultBuilder vrb = ValidationResult.from(this);
        vrb.detail(DATA_TYPE_NAME, this.dataTypeName);
        if (this.fieldPathNames == null) {
            HollowSchema schema = readState.getStateEngine().getSchema(this.dataTypeName);
            if (schema == null) {
                return vrb.failed(String.format(NO_SCHEMA_FOUND_MSG_FORMAT, this.dataTypeName));
            }
            if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
                return vrb.failed(String.format(NOT_AN_OBJECT_ERROR_MSG_FORMAT, this.dataTypeName));
            }
            HollowObjectSchema oSchema = (HollowObjectSchema)schema;
            primaryKey = oSchema.getPrimaryKey();
            if (primaryKey == null) {
                return vrb.failed(String.format(NO_PRIMARY_KEY_ERROR_MSG_FORMAT, this.dataTypeName));
            }
        } else {
            primaryKey = new PrimaryKey(this.dataTypeName, this.fieldPathNames);
        }
        String fieldPaths = Arrays.toString(primaryKey.getFieldPaths());
        vrb.detail(FIELD_PATH_NAME, fieldPaths);
        Collection<Object[]> duplicateKeys = this.getDuplicateKeys(readState.getStateEngine(), primaryKey);
        if (!duplicateKeys.isEmpty()) {
            String message = String.format(DUPLICATE_KEYS_FOUND_ERRRO_MSG_FORMAT, this.dataTypeName, fieldPaths, this.duplicateKeysToString(duplicateKeys));
            return vrb.failed(message);
        }
        return vrb.passed();
    }

    private Collection<Object[]> getDuplicateKeys(HollowReadStateEngine stateEngine, PrimaryKey primaryKey) {
        HollowTypeReadState typeState = stateEngine.getTypeState(this.dataTypeName);
        HollowPrimaryKeyIndex hollowPrimaryKeyIndex = typeState.getListener(HollowPrimaryKeyIndex.class);
        if (hollowPrimaryKeyIndex == null) {
            hollowPrimaryKeyIndex = new HollowPrimaryKeyIndex(stateEngine, primaryKey);
        }
        return hollowPrimaryKeyIndex.getDuplicateKeys();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DuplicateDataDetectionValidator that = (DuplicateDataDetectionValidator)o;
        return this.dataTypeName.equals(that.dataTypeName) && Arrays.equals(this.fieldPathNames, that.fieldPathNames);
    }

    public int hashCode() {
        int result = Objects.hash(this.dataTypeName);
        result = 31 * result + Arrays.hashCode(this.fieldPathNames);
        return result;
    }

    private String duplicateKeysToString(Collection<Object[]> duplicateKeys) {
        return duplicateKeys.stream().map(Arrays::toString).collect(Collectors.joining(","));
    }

    public static void addValidatorsForSchemaWithPrimaryKey(HollowProducer producer) {
        producer.getWriteEngine().getOrderedTypeStates().stream().filter(ts -> ts.getSchema().getSchemaType() == HollowSchema.SchemaType.OBJECT).map(ts -> (HollowObjectSchema)ts.getSchema()).filter(hos -> hos.getPrimaryKey() != null).map(HollowObjectSchema::getPrimaryKey).forEach(k -> producer.addListener(new DuplicateDataDetectionValidator(k.getType())));
    }
}

