/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.common.ListenerSupport;
import com.netflix.hollow.api.common.Listeners;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.HollowProducerListener;
import com.netflix.hollow.api.producer.IncrementalCycleListener;
import com.netflix.hollow.api.producer.Status;
import com.netflix.hollow.api.producer.listener.AnnouncementListener;
import com.netflix.hollow.api.producer.listener.CycleListener;
import com.netflix.hollow.api.producer.listener.DataModelInitializationListener;
import com.netflix.hollow.api.producer.listener.HollowProducerEventListener;
import com.netflix.hollow.api.producer.listener.IncrementalPopulateListener;
import com.netflix.hollow.api.producer.listener.IntegrityCheckListener;
import com.netflix.hollow.api.producer.listener.PopulateListener;
import com.netflix.hollow.api.producer.listener.PublishListener;
import com.netflix.hollow.api.producer.listener.RestoreListener;
import com.netflix.hollow.api.producer.validation.ValidationStatus;
import com.netflix.hollow.api.producer.validation.ValidationStatusListener;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ProducerListenerSupport
extends ListenerSupport {
    private static final Logger LOG = Logger.getLogger(ProducerListenerSupport.class.getName());
    private static final Collection<Class<? extends HollowProducerEventListener>> LISTENERS = Stream.of(DataModelInitializationListener.class, RestoreListener.class, CycleListener.class, PopulateListener.class, PublishListener.class, IntegrityCheckListener.class, AnnouncementListener.class, ValidatorListener.class, ValidationStatusListener.class).distinct().collect(Collectors.toList());
    private final Set<IncrementalCycleListener> incrementalCycleListeners;

    static boolean isValidListener(HollowProducerEventListener l) {
        return LISTENERS.stream().anyMatch(c -> c.isInstance(l));
    }

    ProducerListenerSupport() {
        this.incrementalCycleListeners = new CopyOnWriteArraySet<IncrementalCycleListener>();
    }

    ProducerListenerSupport(List<? extends HollowProducerEventListener> listeners) {
        super(listeners);
        this.incrementalCycleListeners = new CopyOnWriteArraySet<IncrementalCycleListener>();
    }

    ProducerListenerSupport(ProducerListenerSupport that) {
        super(that);
        this.incrementalCycleListeners = new CopyOnWriteArraySet<IncrementalCycleListener>(that.incrementalCycleListeners);
    }

    ProducerListeners listeners() {
        return new ProducerListeners(this.eventListeners.toArray(new HollowProducerEventListener[0]));
    }

    void add(IncrementalCycleListener listener) {
        this.incrementalCycleListeners.add(listener);
    }

    void remove(IncrementalCycleListener listener) {
        this.incrementalCycleListeners.remove(listener);
    }

    private <T> void fire(Collection<T> ls, Consumer<? super T> r) {
        this.fire(ls.stream(), r);
    }

    private <T> void fire(Stream<T> ls, Consumer<? super T> r) {
        ls.forEach(l -> {
            try {
                r.accept(l);
            }
            catch (RuntimeException e) {
                LOG.log(Level.WARNING, "Error executing listener", e);
            }
        });
    }

    void fireIncrementalCycleComplete(long version, long recordsAddedOrModified, long recordsRemoved, Map<String, Object> cycleMetadata) {
        IncrementalCycleListener.IncrementalCycleStatus.Builder icsb = new IncrementalCycleListener.IncrementalCycleStatus.Builder().success(version, recordsAddedOrModified, recordsRemoved, cycleMetadata);
        this.fire(this.incrementalCycleListeners, (? super T l) -> l.onCycleComplete(icsb.build(), icsb.elapsed(), TimeUnit.MILLISECONDS));
    }

    void fireIncrementalCycleFail(Throwable cause, long recordsAddedOrModified, long recordsRemoved, Map<String, Object> cycleMetadata) {
        IncrementalCycleListener.IncrementalCycleStatus.Builder icsb = new IncrementalCycleListener.IncrementalCycleStatus.Builder().fail(cause, recordsAddedOrModified, recordsRemoved, cycleMetadata);
        this.fire(this.incrementalCycleListeners, (? super T l) -> l.onCycleFail(icsb.build(), icsb.elapsed(), TimeUnit.MILLISECONDS));
    }

    static final class ProducerListeners
    extends Listeners {
        ProducerListeners(HollowProducerEventListener[] listeners) {
            super(listeners);
        }

        void fireProducerInit(long elapsedMillis) {
            this.fire(DataModelInitializationListener.class, l -> l.onProducerInit(Duration.ofMillis(elapsedMillis)));
        }

        Status.RestoreStageBuilder fireProducerRestoreStart(long version) {
            this.fire(RestoreListener.class, l -> l.onProducerRestoreStart(version));
            return new Status.RestoreStageBuilder();
        }

        void fireProducerRestoreComplete(Status.RestoreStageBuilder b) {
            Status s = b.build();
            long versionDesired = b.versionDesired;
            long versionReached = b.versionReached;
            Duration elapsed = b.elapsed();
            this.fire(RestoreListener.class, l -> l.onProducerRestoreComplete(s, versionDesired, versionReached, elapsed));
        }

        void fireNewDeltaChain(long version) {
            this.fire(CycleListener.class, l -> l.onNewDeltaChain(version));
        }

        void fireCycleSkipped(CycleListener.CycleSkipReason reason) {
            this.fire(CycleListener.class, l -> l.onCycleSkip(reason));
        }

        Status.StageWithStateBuilder fireCycleStart(long version) {
            this.fire(CycleListener.class, l -> l.onCycleStart(version));
            return new Status.StageWithStateBuilder().version(version);
        }

        void fireCycleComplete(Status.StageWithStateBuilder b) {
            Status s = b.build();
            HollowProducer.ReadState readState = b.readState;
            long version = b.version;
            Duration elapsed = b.elapsed();
            this.fire(CycleListener.class, l -> l.onCycleComplete(s, readState, version, elapsed));
        }

        Status.IncrementalPopulateBuilder fireIncrementalPopulateStart(long version) {
            this.fire(IncrementalPopulateListener.class, l -> l.onIncrementalPopulateStart(version));
            return new Status.IncrementalPopulateBuilder().version(version);
        }

        void fireIncrementalPopulateComplete(Status.IncrementalPopulateBuilder b) {
            Status s = b.build();
            long version = b.version;
            Duration elapsed = b.elapsed();
            long removed = b.removed;
            long addedOrModified = b.addedOrModified;
            this.fire(IncrementalPopulateListener.class, l -> l.onIncrementalPopulateComplete(s, removed, addedOrModified, version, elapsed));
        }

        Status.StageBuilder firePopulateStart(long version) {
            this.fire(PopulateListener.class, l -> l.onPopulateStart(version));
            return new Status.StageBuilder().version(version);
        }

        void firePopulateComplete(Status.StageBuilder b) {
            Status s = b.build();
            long version = b.version;
            Duration elapsed = b.elapsed();
            this.fire(PopulateListener.class, l -> l.onPopulateComplete(s, version, elapsed));
        }

        void fireNoDelta(long version) {
            this.fire(PublishListener.class, l -> l.onNoDeltaAvailable(version));
        }

        Status.StageBuilder firePublishStart(long version) {
            this.fire(PublishListener.class, l -> l.onPublishStart(version));
            return new Status.StageBuilder().version(version);
        }

        void fireBlobStage(Status.PublishBuilder b) {
            Status s = b.build();
            HollowProducer.Blob blob = b.blob;
            Duration elapsed = b.elapsed();
            this.fire(PublishListener.class, l -> l.onBlobStage(s, blob, elapsed));
        }

        void fireBlobPublishAsync(CompletableFuture<HollowProducer.Blob> f) {
            this.fire(PublishListener.class, l -> l.onBlobPublishAsync(f));
        }

        void fireBlobPublish(Status.PublishBuilder b) {
            Status s = b.build();
            HollowProducer.Blob blob = b.blob;
            Duration elapsed = b.elapsed();
            this.fire(PublishListener.class, l -> l.onBlobPublish(s, blob, elapsed));
        }

        void firePublishComplete(Status.StageBuilder b) {
            Status s = b.build();
            long version = b.version;
            Duration elapsed = b.elapsed();
            this.fire(PublishListener.class, l -> l.onPublishComplete(s, version, elapsed));
        }

        Status.StageWithStateBuilder fireIntegrityCheckStart(HollowProducer.ReadState readState) {
            long version = readState.getVersion();
            this.fire(IntegrityCheckListener.class, l -> l.onIntegrityCheckStart(version));
            return new Status.StageWithStateBuilder().readState(readState);
        }

        void fireIntegrityCheckComplete(Status.StageWithStateBuilder b) {
            Status s = b.build();
            HollowProducer.ReadState readState = b.readState;
            long version = b.version;
            Duration elapsed = b.elapsed();
            this.fire(IntegrityCheckListener.class, l -> l.onIntegrityCheckComplete(s, readState, version, elapsed));
        }

        Status.StageWithStateBuilder fireValidationStart(HollowProducer.ReadState readState) {
            long version = readState.getVersion();
            this.fire(HollowProducerListener.class, l -> l.onValidationStart(version));
            this.fire(ValidationStatusListener.class, l -> l.onValidationStatusStart(version));
            return new Status.StageWithStateBuilder().readState(readState);
        }

        void fireValidationComplete(Status.StageWithStateBuilder b, ValidationStatus vs) {
            Status s = b.build();
            HollowProducer.ReadState readState = b.readState;
            long version = b.version;
            Duration elapsed = b.elapsed();
            this.fire(HollowProducerListener.class, l -> l.onValidationComplete(new HollowProducerListener.ProducerStatus(s, readState, version), elapsed.toMillis(), TimeUnit.MILLISECONDS));
            this.fire(ValidationStatusListener.class, l -> l.onValidationStatusComplete(vs, version, elapsed));
        }

        Status.StageWithStateBuilder fireAnnouncementStart(HollowProducer.ReadState readState) {
            long version = readState.getVersion();
            this.fire(AnnouncementListener.class, l -> l.onAnnouncementStart(version));
            this.fire(AnnouncementListener.class, l -> l.onAnnouncementStart(readState));
            return new Status.StageWithStateBuilder().readState(readState);
        }

        void fireAnnouncementComplete(Status.StageWithStateBuilder b) {
            Status s = b.build();
            HollowProducer.ReadState readState = b.readState;
            long version = b.version;
            Duration elapsed = b.elapsed();
            this.fire(AnnouncementListener.class, l -> l.onAnnouncementComplete(s, readState, version, elapsed));
        }
    }
}

