/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.producer.HollowIncrementalCyclePopulator;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.IncrementalCycleListener;
import com.netflix.hollow.api.producer.ProducerListenerSupport;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public class HollowIncrementalProducer {
    private static final long FAILED_VERSION = Long.MIN_VALUE;
    private final HollowProducer producer;
    private final ConcurrentHashMap<RecordPrimaryKey, Object> mutations;
    private final HollowProducer.Populator populator;
    private final ProducerListenerSupport listeners;
    private final Map<String, Object> cycleMetadata;
    private final Class<?>[] dataModel;
    private final HollowConsumer.AnnouncementWatcher announcementWatcher;
    private final HollowConsumer.BlobRetriever blobRetriever;
    private final double threadsPerCpu;
    private long lastSucessfulCycle;

    public HollowIncrementalProducer(HollowProducer producer) {
        this(producer, 1.0, null, null, new ArrayList<IncrementalCycleListener>(), new Class[0]);
    }

    public HollowIncrementalProducer(HollowProducer producer, double threadsPerCpu) {
        this(producer, threadsPerCpu, null, null, new ArrayList<IncrementalCycleListener>(), new Class[0]);
    }

    protected HollowIncrementalProducer(HollowProducer producer, double threadsPerCpu, HollowConsumer.AnnouncementWatcher announcementWatcher, HollowConsumer.BlobRetriever blobRetriever, List<IncrementalCycleListener> listeners, Class<?> ... classes) {
        this.producer = producer;
        this.mutations = new ConcurrentHashMap();
        this.populator = new HollowIncrementalCyclePopulator(this.mutations, threadsPerCpu);
        this.dataModel = classes;
        this.announcementWatcher = announcementWatcher;
        this.blobRetriever = blobRetriever;
        this.listeners = new ProducerListenerSupport();
        this.cycleMetadata = new HashMap<String, Object>();
        this.threadsPerCpu = threadsPerCpu;
        for (IncrementalCycleListener listener : listeners) {
            this.listeners.add(listener);
        }
    }

    public void restoreFromLastState() {
        this.producer.initializeDataModel(this.dataModel);
        long latestAnnouncedVersion = this.announcementWatcher.getLatestVersion();
        if (latestAnnouncedVersion == Long.MIN_VALUE || latestAnnouncedVersion < 0L) {
            return;
        }
        this.restore(latestAnnouncedVersion, this.blobRetriever);
    }

    public void restore(long versionDesired, HollowConsumer.BlobRetriever blobRetriever) {
        this.producer.hardRestore(versionDesired, blobRetriever);
    }

    public void addOrModify(Object obj) {
        RecordPrimaryKey pk = this.extractRecordPrimaryKey(obj);
        this.mutations.put(pk, obj);
    }

    public void addIfAbsent(Object obj) {
        RecordPrimaryKey pk = this.extractRecordPrimaryKey(obj);
        this.mutations.putIfAbsent(pk, new HollowIncrementalCyclePopulator.AddIfAbsent(obj));
    }

    public void addOrModify(Collection<Object> objList) {
        for (Object obj : objList) {
            this.addOrModify(obj);
        }
    }

    public void addOrModify(FlatRecord flatRecord) {
        RecordPrimaryKey pk = flatRecord.getRecordPrimaryKey();
        this.mutations.put(pk, flatRecord);
    }

    public void addIfAbsent(FlatRecord flatRecord) {
        RecordPrimaryKey pk = flatRecord.getRecordPrimaryKey();
        this.mutations.putIfAbsent(pk, new HollowIncrementalCyclePopulator.AddIfAbsent(flatRecord));
    }

    public void addOrModifyInParallel(Collection<Object> objList) {
        this.executeInParallel(objList, "add-or-modify", this::addOrModify);
    }

    public void delete(Object obj) {
        RecordPrimaryKey pk = this.extractRecordPrimaryKey(obj);
        this.delete(pk);
    }

    public void delete(Collection<Object> objList) {
        for (Object obj : objList) {
            this.delete(obj);
        }
    }

    public void deleteInParallel(Collection<Object> objList) {
        this.executeInParallel(objList, "delete", this::delete);
    }

    public void discard(Object obj) {
        RecordPrimaryKey pk = this.extractRecordPrimaryKey(obj);
        this.discard(pk);
    }

    public void discard(Collection<Object> objList) {
        for (Object obj : objList) {
            this.discard(obj);
        }
    }

    public void discardInParallel(Collection<Object> objList) {
        this.executeInParallel(objList, "discard", this::discard);
    }

    public void delete(RecordPrimaryKey key) {
        this.mutations.put(key, HollowIncrementalCyclePopulator.DELETE_RECORD);
    }

    public void discard(RecordPrimaryKey key) {
        this.mutations.remove(key);
    }

    public void clearChanges() {
        this.mutations.clear();
    }

    public boolean hasChanges() {
        return this.mutations.size() > 0;
    }

    public void addCycleMetadata(String key, Object value) {
        this.cycleMetadata.put(key, value);
    }

    public void addAllCycleMetadata(Map<String, Object> metadata) {
        this.cycleMetadata.putAll(metadata);
    }

    public void removeFromCycleMetadata(String key) {
        this.cycleMetadata.remove(key);
    }

    public void clearCycleMetadata() {
        this.cycleMetadata.clear();
    }

    public boolean hasMetadata() {
        return !this.cycleMetadata.isEmpty();
    }

    public void addListener(IncrementalCycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IncrementalCycleListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runCycle() {
        long recordsRemoved = this.countRecordsToRemove();
        long recordsAddedOrModified = (long)this.mutations.values().size() - recordsRemoved;
        try {
            long version = this.producer.runCycle(this.populator);
            if (version == this.lastSucessfulCycle) {
                long l = version;
                return l;
            }
            this.listeners.fireIncrementalCycleComplete(version, recordsAddedOrModified, recordsRemoved, new HashMap<String, Object>(this.cycleMetadata));
            this.clearChanges();
            this.lastSucessfulCycle = version;
            long l = version;
            return l;
        }
        catch (Exception e) {
            this.listeners.fireIncrementalCycleFail(e, recordsAddedOrModified, recordsRemoved, new HashMap<String, Object>(this.cycleMetadata));
            long l = Long.MIN_VALUE;
            return l;
        }
        finally {
            this.clearCycleMetadata();
        }
    }

    private long countRecordsToRemove() {
        long recordsToRemove = 0L;
        Collection<Object> records = this.mutations.values();
        for (Object record : records) {
            if (record != HollowIncrementalCyclePopulator.DELETE_RECORD) continue;
            ++recordsToRemove;
        }
        return recordsToRemove;
    }

    private RecordPrimaryKey extractRecordPrimaryKey(Object obj) {
        return this.producer.getObjectMapper().extractPrimaryKey(obj);
    }

    public static Builder withProducer(HollowProducer hollowProducer) {
        Builder builder = new Builder();
        return builder.withProducer(hollowProducer);
    }

    private void executeInParallel(Collection<Object> objList, String description, Callback callback) {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.threadsPerCpu, this.getClass(), description);
        for (Object obj : objList) {
            executor.execute(() -> callback.call(obj));
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static interface Callback {
        public void call(Object var1);
    }

    public static class Builder<B extends Builder<B>> {
        protected HollowProducer producer;
        protected double threadsPerCpu = 1.0;
        protected HollowConsumer.AnnouncementWatcher announcementWatcher;
        protected HollowConsumer.BlobRetriever blobRetriever;
        protected Class<?>[] dataModel;
        protected List<IncrementalCycleListener> listeners = new ArrayList<IncrementalCycleListener>();

        public B withProducer(HollowProducer producer) {
            this.producer = producer;
            return (B)this;
        }

        public B withThreadsPerCpu(double threadsPerCpu) {
            this.threadsPerCpu = threadsPerCpu;
            return (B)this;
        }

        public B withAnnouncementWatcher(HollowConsumer.AnnouncementWatcher announcementWatcher) {
            this.announcementWatcher = announcementWatcher;
            return (B)this;
        }

        public B withBlobRetriever(HollowConsumer.BlobRetriever blobRetriever) {
            this.blobRetriever = blobRetriever;
            return (B)this;
        }

        public B withDataModel(Class<?> ... classes) {
            this.dataModel = classes;
            return (B)this;
        }

        public B withListener(IncrementalCycleListener listener) {
            this.listeners.add(listener);
            return (B)this;
        }

        public B withListeners(IncrementalCycleListener ... listeners) {
            for (IncrementalCycleListener listener : listeners) {
                this.listeners.add(listener);
            }
            return (B)this;
        }

        protected void checkArguments() {
            if (this.producer == null) {
                throw new IllegalArgumentException("HollowProducer must be specified.");
            }
        }

        public HollowIncrementalProducer build() {
            this.checkArguments();
            return new HollowIncrementalProducer(this.producer, this.threadsPerCpu, this.announcementWatcher, this.blobRetriever, this.listeners, this.dataModel);
        }
    }
}

