/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;

final class CloseableWriteState
implements HollowProducer.WriteState,
AutoCloseable {
    private final long version;
    private final HollowObjectMapper objectMapper;
    private final HollowProducer.ReadState priorReadState;
    private volatile boolean closed;

    CloseableWriteState(long version, HollowObjectMapper objectMapper, HollowProducer.ReadState priorReadState) {
        this.version = version;
        this.objectMapper = objectMapper;
        this.priorReadState = priorReadState;
    }

    @Override
    public int add(Object o) throws IllegalStateException {
        this.ensureNotClosed();
        return this.objectMapper.add(o);
    }

    @Override
    public HollowObjectMapper getObjectMapper() throws IllegalStateException {
        this.ensureNotClosed();
        return this.objectMapper;
    }

    @Override
    public HollowWriteStateEngine getStateEngine() throws IllegalStateException {
        this.ensureNotClosed();
        return this.objectMapper.getStateEngine();
    }

    @Override
    public long getVersion() throws IllegalStateException {
        this.ensureNotClosed();
        return this.version;
    }

    @Override
    public HollowProducer.ReadState getPriorState() throws IllegalStateException {
        this.ensureNotClosed();
        return this.priorReadState;
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(String.format("Write state operated on after the population stage of a cycle; version=%d", this.version));
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

