/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.metrics.HollowMetricsCollector;
import com.netflix.hollow.api.metrics.HollowProducerMetrics;
import com.netflix.hollow.api.producer.CloseableIncrementalWriteState;
import com.netflix.hollow.api.producer.CloseableWriteState;
import com.netflix.hollow.api.producer.HollowIncrementalCyclePopulator;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.HollowProducerListener;
import com.netflix.hollow.api.producer.ProducerListenerSupport;
import com.netflix.hollow.api.producer.ReadStateHelper;
import com.netflix.hollow.api.producer.Status;
import com.netflix.hollow.api.producer.VersionMinterWithCounter;
import com.netflix.hollow.api.producer.enforcer.BasicSingleProducerEnforcer;
import com.netflix.hollow.api.producer.enforcer.SingleProducerEnforcer;
import com.netflix.hollow.api.producer.fs.HollowFilesystemBlobStager;
import com.netflix.hollow.api.producer.listener.CycleListener;
import com.netflix.hollow.api.producer.listener.HollowProducerEventListener;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidationStatus;
import com.netflix.hollow.api.producer.validation.ValidationStatusException;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowBlobHeaderReader;
import com.netflix.hollow.core.read.engine.HollowBlobReader;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSchemaHash;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

abstract class AbstractHollowProducer {
    static final long DEFAULT_TARGET_MAX_TYPE_SHARD_SIZE = 0x1000000L;
    private static final String ANNOUNCE_TAG_HEAP_FOOTPRINT = "hollow.data.size.heap.bytes.approx";
    final Logger log = Logger.getLogger(AbstractHollowProducer.class.getName());
    final HollowProducer.BlobStager blobStager;
    final HollowProducer.Publisher publisher;
    final HollowProducer.Announcer announcer;
    final HollowProducer.BlobStorageCleaner blobStorageCleaner;
    HollowObjectMapper objectMapper;
    final HollowProducer.VersionMinter versionMinter;
    final ProducerListenerSupport listeners;
    ReadStateHelper readStates;
    final Executor snapshotPublishExecutor;
    final int numStatesBetweenSnapshots;
    int numStatesUntilNextSnapshot;
    HollowProducerMetrics metrics;
    HollowMetricsCollector<HollowProducerMetrics> metricsCollector;
    final SingleProducerEnforcer singleProducerEnforcer;
    long lastSuccessfulCycle = 0L;
    final HollowObjectHashCodeFinder hashCodeFinder;
    final boolean doIntegrityCheck;
    int cycleCountSincePrimaryStatus = 0;
    boolean isInitialized;
    private final long targetMaxTypeShardSize;
    private final boolean focusHoleFillInFewestShards;
    private final boolean allowTypeResharding;
    private final boolean forceCoverageOfTypeResharding;

    @Deprecated
    public AbstractHollowProducer(HollowProducer.Publisher publisher, HollowProducer.Announcer announcer) {
        this(new HollowFilesystemBlobStager(), publisher, announcer, Collections.emptyList(), new VersionMinterWithCounter(), null, 0, 0x1000000L, false, false, false, null, new DummyBlobStorageCleaner(), new BasicSingleProducerEnforcer(), null, true);
    }

    AbstractHollowProducer(HollowProducer.Builder<?> b) {
        this(b.stager, b.publisher, b.announcer, b.eventListeners, b.versionMinter, b.snapshotPublishExecutor, b.numStatesBetweenSnapshots, b.targetMaxTypeShardSize, b.focusHoleFillInFewestShards, b.allowTypeResharding, b.forceCoverageOfTypeResharding, b.metricsCollector, b.blobStorageCleaner, b.singleProducerEnforcer, b.hashCodeFinder, b.doIntegrityCheck);
    }

    private AbstractHollowProducer(HollowProducer.BlobStager blobStager, HollowProducer.Publisher publisher, HollowProducer.Announcer announcer, List<? extends HollowProducerEventListener> eventListeners, HollowProducer.VersionMinter versionMinter, Executor snapshotPublishExecutor, int numStatesBetweenSnapshots, long targetMaxTypeShardSize, boolean focusHoleFillInFewestShards, boolean allowTypeResharding, boolean forceCoverageOfTypeResharding, HollowMetricsCollector<HollowProducerMetrics> metricsCollector, HollowProducer.BlobStorageCleaner blobStorageCleaner, SingleProducerEnforcer singleProducerEnforcer, HollowObjectHashCodeFinder hashCodeFinder, boolean doIntegrityCheck) {
        this.publisher = publisher;
        this.announcer = announcer;
        this.versionMinter = versionMinter;
        this.blobStager = blobStager;
        this.singleProducerEnforcer = singleProducerEnforcer;
        this.snapshotPublishExecutor = snapshotPublishExecutor;
        this.numStatesBetweenSnapshots = numStatesBetweenSnapshots;
        this.hashCodeFinder = hashCodeFinder;
        this.doIntegrityCheck = doIntegrityCheck;
        this.targetMaxTypeShardSize = targetMaxTypeShardSize;
        this.allowTypeResharding = allowTypeResharding;
        this.forceCoverageOfTypeResharding = forceCoverageOfTypeResharding;
        this.focusHoleFillInFewestShards = focusHoleFillInFewestShards;
        HollowWriteStateEngine writeEngine = hashCodeFinder == null ? new HollowWriteStateEngine() : new HollowWriteStateEngine(hashCodeFinder);
        writeEngine.setTargetMaxTypeShardSize(targetMaxTypeShardSize);
        writeEngine.allowTypeResharding(allowTypeResharding);
        writeEngine.setFocusHoleFillInFewestShards(focusHoleFillInFewestShards);
        this.objectMapper = new HollowObjectMapper(writeEngine);
        if (hashCodeFinder != null) {
            this.objectMapper.doNotUseDefaultHashKeys();
        }
        this.readStates = ReadStateHelper.newDeltaChain();
        this.blobStorageCleaner = blobStorageCleaner;
        this.listeners = new ProducerListenerSupport(eventListeners.stream().distinct().collect(Collectors.toList()));
        this.metrics = new HollowProducerMetrics();
        this.metricsCollector = metricsCollector;
    }

    public HollowProducerMetrics getMetrics() {
        return this.metrics;
    }

    public void initializeDataModel(Class<?> ... classes) {
        Objects.requireNonNull(classes);
        if (classes.length == 0) {
            throw new IllegalArgumentException("classes is empty");
        }
        long start = System.currentTimeMillis();
        for (Class<?> c : classes) {
            this.objectMapper.initializeTypeState(c);
        }
        this.listeners.listeners().fireProducerInit(System.currentTimeMillis() - start);
        this.isInitialized = true;
    }

    public void initializeDataModel(HollowSchema ... schemas) {
        Objects.requireNonNull(schemas);
        if (schemas.length == 0) {
            throw new IllegalArgumentException("classes is empty");
        }
        long start = System.currentTimeMillis();
        HollowWriteStateCreator.populateStateEngineWithTypeWriteStates(this.getWriteEngine(), Arrays.asList(schemas));
        this.listeners.listeners().fireProducerInit(System.currentTimeMillis() - start);
        this.isInitialized = true;
    }

    public HollowProducer.ReadState restore(long versionDesired, HollowConsumer.BlobRetriever blobRetriever) {
        return this.restore(versionDesired, blobRetriever, (restoreFrom, restoreTo) -> restoreTo.restoreFrom((HollowReadStateEngine)restoreFrom));
    }

    HollowProducer.ReadState hardRestore(long versionDesired, HollowConsumer.BlobRetriever blobRetriever) {
        return this.restore(versionDesired, blobRetriever, (restoreFrom, restoreTo) -> HollowWriteStateCreator.populateUsingReadEngine(restoreTo, restoreFrom, false));
    }

    private HollowProducer.ReadState restore(long versionDesired, HollowConsumer.BlobRetriever blobRetriever, BiConsumer<HollowReadStateEngine, HollowWriteStateEngine> restoreAction) {
        Objects.requireNonNull(blobRetriever);
        Objects.requireNonNull(restoreAction);
        if (!this.isInitialized) {
            throw new IllegalStateException("You must initialize the data model of a HollowProducer with producer.initializeDataModel(...) prior to restoring");
        }
        HollowProducer.ReadState readState = null;
        ProducerListenerSupport.ProducerListeners localListeners = this.listeners.listeners();
        Status.RestoreStageBuilder status = localListeners.fireProducerRestoreStart(versionDesired);
        try {
            if (versionDesired != Long.MIN_VALUE) {
                HollowConsumer client = HollowConsumer.withBlobRetriever(blobRetriever).build();
                client.triggerRefreshTo(versionDesired);
                readState = ReadStateHelper.newReadState(client.getCurrentVersionId(), client.getStateEngine());
                this.readStates = ReadStateHelper.restored(readState);
                List<HollowSchema> schemas = this.objectMapper.getStateEngine().getSchemas();
                HollowWriteStateEngine writeEngine = this.hashCodeFinder == null ? new HollowWriteStateEngine() : new HollowWriteStateEngine(this.hashCodeFinder);
                writeEngine.setTargetMaxTypeShardSize(this.targetMaxTypeShardSize);
                writeEngine.allowTypeResharding(this.allowTypeResharding);
                writeEngine.setFocusHoleFillInFewestShards(this.focusHoleFillInFewestShards);
                HollowWriteStateCreator.populateStateEngineWithTypeWriteStates(writeEngine, schemas);
                HollowObjectMapper newObjectMapper = new HollowObjectMapper(writeEngine);
                if (this.hashCodeFinder != null) {
                    newObjectMapper.doNotUseDefaultHashKeys();
                }
                restoreAction.accept(this.readStates.current().getStateEngine(), writeEngine);
                status.versions(versionDesired, readState.getVersion()).success();
                this.objectMapper = newObjectMapper;
            }
        }
        catch (Throwable th) {
            status.fail(th);
            throw th;
        }
        finally {
            localListeners.fireProducerRestoreComplete(status);
        }
        return readState;
    }

    public HollowWriteStateEngine getWriteEngine() {
        return this.objectMapper.getStateEngine();
    }

    public HollowObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public boolean enablePrimaryProducer(boolean doEnable) {
        if (!this.singleProducerEnforcer.isPrimary()) {
            this.cycleCountSincePrimaryStatus = 0;
        }
        if (doEnable) {
            this.singleProducerEnforcer.enable();
        } else {
            this.singleProducerEnforcer.disable();
        }
        return this.singleProducerEnforcer.isPrimary() == doEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long runCycle(HollowProducer.Incremental.IncrementalPopulator incrementalPopulator, HollowProducer.Populator populator) {
        ProducerListenerSupport.ProducerListeners localListeners = this.listeners.listeners();
        if (!this.singleProducerEnforcer.isPrimary()) {
            this.log.log(Level.INFO, "cycle not executed -- not primary (aka leader)");
            localListeners.fireCycleSkipped(CycleListener.CycleSkipReason.NOT_PRIMARY_PRODUCER);
            this.cycleCountSincePrimaryStatus = 0;
            return this.lastSuccessfulCycle;
        }
        long toVersion = this.versionMinter.mint();
        if (!this.readStates.hasCurrent()) {
            localListeners.fireNewDeltaChain(toVersion);
        }
        Status.StageWithStateBuilder cycleStatus = localListeners.fireCycleStart(toVersion);
        try {
            long l = this.runCycle(localListeners, incrementalPopulator, populator, cycleStatus, toVersion);
            return l;
        }
        finally {
            localListeners.fireCycleComplete(cycleStatus);
            this.metrics.updateCycleMetrics(cycleStatus.build(), cycleStatus.readState, cycleStatus.version);
            if (this.metricsCollector != null) {
                this.metricsCollector.collect(this.metrics);
            }
        }
    }

    long runCycle(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.Incremental.IncrementalPopulator incrementalPopulator, HollowProducer.Populator populator, Status.StageWithStateBuilder cycleStatus, long toVersion) {
        block13: {
            Artifacts artifacts = new Artifacts();
            HollowWriteStateEngine writeEngine = this.getWriteEngine();
            try {
                writeEngine.prepareForNextCycle();
                writeEngine.addHeaderTag("hollow.metric.cycle.start", String.valueOf(System.currentTimeMillis()));
                this.populate(listeners, incrementalPopulator, populator, toVersion);
                if (writeEngine.hasChangedSinceLastCycle()) {
                    boolean schemaChangedFromPriorVersion = this.readStates.hasCurrent() && !writeEngine.hasIdenticalSchemas(this.readStates.current().getStateEngine());
                    this.updateHeaderTags(writeEngine, toVersion, schemaChangedFromPriorVersion);
                    if (this.allowTypeResharding && this.forceCoverageOfTypeResharding) {
                        int shift = (int)(Math.random() * 9.0) - 4;
                        long adjustedShardSize = shift > 0 ? this.targetMaxTypeShardSize << shift : (shift < 0 ? this.targetMaxTypeShardSize >> -shift : this.targetMaxTypeShardSize);
                        writeEngine.setTargetMaxTypeShardSize(adjustedShardSize);
                    }
                    this.publish(listeners, toVersion, artifacts);
                    ReadStateHelper candidate = this.readStates.roundtrip(toVersion);
                    cycleStatus.readState(candidate.pending());
                    candidate = this.doIntegrityCheck ? this.checkIntegrity(listeners, candidate, artifacts, schemaChangedFromPriorVersion) : this.noIntegrityCheck(candidate, artifacts);
                    try {
                        this.validate(listeners, candidate.pending());
                        this.announce(listeners, candidate.pending());
                        this.readStates = candidate.commit();
                        cycleStatus.readState(this.readStates.current()).success();
                    }
                    catch (Throwable th) {
                        if (artifacts.hasReverseDelta()) {
                            this.applyDelta(artifacts.reverseDelta, candidate.pending().getStateEngine());
                            this.readStates = candidate.rollback();
                        }
                        throw th;
                    }
                    this.lastSuccessfulCycle = toVersion;
                    break block13;
                }
                writeEngine.resetToLastPrepareForNextCycle();
                cycleStatus.success();
                listeners.fireNoDelta(toVersion);
                this.log.info("Populate stage completed with no delta in output state; skipping publish, announce, etc.");
            }
            catch (Throwable th) {
                try {
                    writeEngine.resetToLastPrepareForNextCycle();
                }
                catch (Throwable innerTh) {
                    this.log.log(Level.SEVERE, "resetToLastPrepareForNextCycle encountered an exception when attempting recovery:", innerTh);
                }
                cycleStatus.fail(th);
                if (th instanceof RuntimeException) {
                    throw (RuntimeException)th;
                }
                throw new RuntimeException(th);
            }
            finally {
                artifacts.cleanup();
                ++this.cycleCountSincePrimaryStatus;
            }
        }
        return this.lastSuccessfulCycle;
    }

    public void addListener(HollowProducerListener listener) {
        this.listeners.addListener(listener);
    }

    public void addListener(HollowProducerEventListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(HollowProducerListener listener) {
        this.listeners.removeListener(listener);
    }

    public void removeListener(HollowProducerEventListener listener) {
        this.listeners.removeListener(listener);
    }

    private void updateHeaderTags(HollowWriteStateEngine writeEngine, long toVersion, boolean schemaChangedFromPriorVersion) {
        String str;
        writeEngine.addHeaderTag("hollow.schema.hash", new HollowSchemaHash(writeEngine.getSchemas()).getHash());
        if (schemaChangedFromPriorVersion) {
            writeEngine.addHeaderTag("hollow.schema.changedFromPriorVersion", Boolean.TRUE.toString());
        } else {
            writeEngine.getHeaderTags().remove("hollow.schema.changedFromPriorVersion");
        }
        writeEngine.addHeaderTag("hollow.blob.to.version", String.valueOf(toVersion));
        writeEngine.getHeaderTags().remove("hollow.type.resharding.invoked");
        long prevDeltaChainVersionCounter = 0L;
        if (this.readStates.hasCurrent() && (str = this.readStates.current().getStateEngine().getHeaderTag("hollow.delta.chain.version.counter")) != null) {
            try {
                prevDeltaChainVersionCounter = Long.valueOf(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        long deltaChainVersionCounter = prevDeltaChainVersionCounter + 1L;
        writeEngine.addHeaderTag("hollow.delta.chain.version.counter", String.valueOf(deltaChainVersionCounter));
    }

    void populate(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.Incremental.IncrementalPopulator incrementalPopulator, HollowProducer.Populator populator, long toVersion) throws Exception {
        assert (incrementalPopulator != null ^ populator != null);
        Status.StageBuilder populateStatus = listeners.firePopulateStart(toVersion);
        try {
            if (incrementalPopulator != null) {
                populator = this.incrementalPopulate(listeners, incrementalPopulator, toVersion);
            }
            try (CloseableWriteState writeState = new CloseableWriteState(toVersion, this.objectMapper, this.readStates.current());){
                populator.populate(writeState);
                populateStatus.success();
            }
        }
        catch (Throwable th) {
            populateStatus.fail(th);
            throw th;
        }
        finally {
            listeners.firePopulateComplete(populateStatus);
        }
    }

    HollowProducer.Populator incrementalPopulate(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.Incremental.IncrementalPopulator incrementalPopulator, long toVersion) throws Exception {
        ConcurrentHashMap<RecordPrimaryKey, Object> events = new ConcurrentHashMap<RecordPrimaryKey, Object>();
        Status.IncrementalPopulateBuilder incrementalPopulateStatus = listeners.fireIncrementalPopulateStart(toVersion);
        try (CloseableIncrementalWriteState iws = new CloseableIncrementalWriteState(events, this.getObjectMapper());){
            incrementalPopulator.populate(iws);
            incrementalPopulateStatus.success();
            long removed = events.values().stream().filter(o -> o == HollowIncrementalCyclePopulator.DELETE_RECORD).count();
            long addedOrModified = (long)events.size() - removed;
            incrementalPopulateStatus.changes(removed, addedOrModified);
        }
        catch (Throwable th) {
            incrementalPopulateStatus.fail(th);
            throw th;
        }
        finally {
            listeners.fireIncrementalPopulateComplete(incrementalPopulateStatus);
        }
        return new HollowIncrementalCyclePopulator(events, 1.0);
    }

    void publish(ProducerListenerSupport.ProducerListeners listeners, long toVersion, Artifacts artifacts) throws IOException {
        Status.StageBuilder psb = listeners.firePublishStart(toVersion);
        try {
            artifacts.header = this.blobStager.openHeader(toVersion);
            if (!this.readStates.hasCurrent() || this.doIntegrityCheck || this.numStatesUntilNextSnapshot <= 0) {
                artifacts.snapshot = this.stageBlob(listeners, this.blobStager.openSnapshot(toVersion));
            }
            this.publishHeaderBlob(artifacts.header);
            if (this.readStates.hasCurrent()) {
                artifacts.delta = this.stageBlob(listeners, this.blobStager.openDelta(this.readStates.current().getVersion(), toVersion));
                artifacts.reverseDelta = this.stageBlob(listeners, this.blobStager.openReverseDelta(toVersion, this.readStates.current().getVersion()));
                this.publishBlob(listeners, artifacts.delta);
                this.publishBlob(listeners, artifacts.reverseDelta);
                if (--this.numStatesUntilNextSnapshot < 0) {
                    if (this.snapshotPublishExecutor == null) {
                        this.publishBlob(listeners, artifacts.snapshot);
                        artifacts.markSnapshotPublishComplete();
                    } else {
                        this.publishSnapshotBlobAsync(listeners, artifacts);
                    }
                    this.numStatesUntilNextSnapshot = this.numStatesBetweenSnapshots;
                } else {
                    artifacts.markSnapshotPublishComplete();
                }
            } else {
                this.publishBlob(listeners, artifacts.snapshot);
                artifacts.markSnapshotPublishComplete();
                this.numStatesUntilNextSnapshot = this.numStatesBetweenSnapshots;
            }
            psb.success();
        }
        catch (Throwable throwable) {
            psb.fail(throwable);
            throw throwable;
        }
        finally {
            listeners.firePublishComplete(psb);
        }
    }

    private HollowProducer.Blob stageBlob(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.Blob blob) throws IOException {
        Status.PublishBuilder builder = new Status.PublishBuilder();
        HollowBlobWriter writer = new HollowBlobWriter(this.getWriteEngine());
        try {
            builder.blob(blob);
            blob.write(writer);
            builder.success();
            HollowProducer.Blob blob2 = blob;
            return blob2;
        }
        catch (Throwable t) {
            builder.fail(t);
            throw t;
        }
        finally {
            listeners.fireBlobStage(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishBlob(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.Blob blob) {
        Status.PublishBuilder builder = new Status.PublishBuilder();
        try {
            builder.blob(blob);
            if (!blob.type.equals((Object)HollowProducer.Blob.Type.SNAPSHOT)) {
                try {
                    this.singleProducerEnforcer.lock();
                    if (!this.singleProducerEnforcer.isPrimary()) {
                        this.log.log(Level.INFO, "Publish failed because current producer is not primary (aka leader)");
                        throw new HollowProducer.NotPrimaryMidCycleException("Publish failed primary (aka leader) check");
                    }
                    this.publishBlob(blob);
                }
                finally {
                    this.singleProducerEnforcer.unlock();
                }
            } else {
                this.publishBlob(blob);
            }
            builder.success();
        }
        catch (Throwable t) {
            builder.fail(t);
            throw t;
        }
        finally {
            listeners.fireBlobPublish(builder);
            this.metrics.updateBlobTypeMetrics(builder.build(), blob);
            if (this.metricsCollector != null) {
                this.metricsCollector.collect(this.metrics);
            }
        }
    }

    private void publishSnapshotBlobAsync(ProducerListenerSupport.ProducerListeners listeners, Artifacts artifacts) {
        HollowProducer.Blob blob = artifacts.snapshot;
        CompletableFuture<HollowProducer.Blob> cf = new CompletableFuture<HollowProducer.Blob>();
        try {
            this.snapshotPublishExecutor.execute(() -> {
                Status.StageBuilder builder = new Status.StageBuilder();
                try {
                    this.publishBlob(blob);
                    builder.success();
                    cf.complete(blob);
                }
                catch (Throwable t) {
                    builder.fail(t);
                    cf.completeExceptionally(t);
                    throw t;
                }
                finally {
                    this.metrics.updateBlobTypeMetrics(builder.build(), blob);
                    if (this.metricsCollector != null) {
                        this.metricsCollector.collect(this.metrics);
                    }
                }
                artifacts.markSnapshotPublishComplete();
            });
        }
        catch (Throwable t) {
            cf.completeExceptionally(t);
            this.metrics.updateBlobTypeMetrics(((Status.StageBuilder)new Status.StageBuilder().fail(t)).build(), blob);
            if (this.metricsCollector != null) {
                this.metricsCollector.collect(this.metrics);
            }
            throw t;
        }
        finally {
            listeners.fireBlobPublishAsync(cf);
        }
    }

    private void publishBlob(HollowProducer.Blob b) {
        try {
            this.publisher.publish((HollowProducer.PublishArtifact)b);
        }
        finally {
            this.blobStorageCleaner.clean(b.getType());
        }
    }

    private void publishHeaderBlob(HollowProducer.HeaderBlob b) {
        try {
            HollowBlobWriter writer = new HollowBlobWriter(this.getWriteEngine());
            b.write(writer);
            this.publisher.publish(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ReadStateHelper checkIntegrity(ProducerListenerSupport.ProducerListeners listeners, ReadStateHelper readStates, Artifacts artifacts, boolean schemaChangedFromPriorVersion) throws Exception {
        Status.StageWithStateBuilder status = listeners.fireIntegrityCheckStart(readStates.pending());
        try {
            ReadStateHelper result = readStates;
            HollowReadStateEngine pending = readStates.pending().getStateEngine();
            this.readSnapshot(artifacts.snapshot, pending);
            if (readStates.hasCurrent()) {
                HollowReadStateEngine current = readStates.current().getStateEngine();
                this.log.info("CHECKSUMS");
                HollowChecksum currentChecksum = HollowChecksum.forStateEngineWithCommonSchemas(current, pending);
                this.log.info("  CUR        " + currentChecksum);
                HollowChecksum pendingChecksum = HollowChecksum.forStateEngineWithCommonSchemas(pending, current);
                this.log.info("         PND " + pendingChecksum);
                if (artifacts.hasDelta()) {
                    if (!artifacts.hasReverseDelta()) {
                        throw new IllegalStateException("Both a delta and reverse delta are required");
                    }
                    this.applyDelta(artifacts.delta, current);
                    HollowChecksum forwardChecksum = HollowChecksum.forStateEngineWithCommonSchemas(current, pending);
                    if (!forwardChecksum.equals(pendingChecksum)) {
                        throw new HollowProducer.ChecksumValidationException(HollowProducer.Blob.Type.DELTA, forwardChecksum, pendingChecksum);
                    }
                    this.applyDelta(artifacts.reverseDelta, pending);
                    HollowChecksum reverseChecksum = HollowChecksum.forStateEngineWithCommonSchemas(pending, current);
                    if (!reverseChecksum.equals(currentChecksum)) {
                        throw new HollowProducer.ChecksumValidationException(HollowProducer.Blob.Type.REVERSE_DELTA, reverseChecksum, currentChecksum);
                    }
                    if (!schemaChangedFromPriorVersion) {
                        this.log.log(Level.FINE, "current and pending have identical schemas, swapping");
                        result = readStates.swap();
                    } else {
                        this.log.log(Level.FINE, "current and pending have non-identical schemas, reverting");
                        this.applyDelta(artifacts.reverseDelta, current);
                        this.applyDelta(artifacts.delta, pending);
                    }
                }
            }
            status.success();
            ReadStateHelper readStateHelper = result;
            return readStateHelper;
        }
        catch (Throwable th) {
            status.fail(th);
            throw th;
        }
        finally {
            listeners.fireIntegrityCheckComplete(status);
        }
    }

    private ReadStateHelper noIntegrityCheck(ReadStateHelper readStates, Artifacts artifacts) throws IOException {
        ReadStateHelper result = readStates;
        if (!readStates.hasCurrent() || !readStates.current().getStateEngine().hasIdenticalSchemas(this.getWriteEngine()) && artifacts.snapshot != null) {
            HollowReadStateEngine pending = readStates.pending().getStateEngine();
            this.readSnapshot(artifacts.snapshot, pending);
        } else {
            HollowReadStateEngine current = readStates.current().getStateEngine();
            if (artifacts.hasDelta()) {
                if (!artifacts.hasReverseDelta()) {
                    throw new IllegalStateException("Both a delta and reverse delta are required");
                }
                this.applyDelta(artifacts.delta, current);
                result = readStates.swap();
            }
        }
        return result;
    }

    private void readSnapshot(HollowProducer.Blob blob, HollowReadStateEngine stateEngine) throws IOException {
        try (HollowBlobInput in = HollowBlobInput.serial(blob.newInputStream());){
            new HollowBlobReader(stateEngine, new HollowBlobHeaderReader()).readSnapshot(in);
        }
    }

    private void applyDelta(HollowProducer.Blob blob, HollowReadStateEngine stateEngine) throws IOException {
        try (HollowBlobInput in = HollowBlobInput.serial(blob.newInputStream());){
            new HollowBlobReader(stateEngine, new HollowBlobHeaderReader()).applyDelta(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.ReadState readState) {
        Status.StageWithStateBuilder psb = listeners.fireValidationStart(readState);
        ValidationStatus status = null;
        try {
            List<ValidationResult> results = listeners.getListeners(ValidatorListener.class).map(v -> {
                try {
                    return v.onValidate(readState);
                }
                catch (RuntimeException e) {
                    return ValidationResult.from(v).error(e);
                }
            }).collect(Collectors.toList());
            status = new ValidationStatus(results);
            if (!status.passed()) {
                ValidationStatusException e = new ValidationStatusException(status, "One or more validations failed. Please check individual failures.");
                psb.fail(e);
                throw e;
            }
            psb.success();
            listeners.fireValidationComplete(psb, status);
        }
        catch (Throwable throwable) {
            listeners.fireValidationComplete(psb, status);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announce(ProducerListenerSupport.ProducerListeners listeners, HollowProducer.ReadState readState) {
        if (this.announcer != null) {
            Status.StageWithStateBuilder status = listeners.fireAnnouncementStart(readState);
            try {
                this.singleProducerEnforcer.lock();
                try {
                    if (!this.singleProducerEnforcer.isPrimary()) {
                        this.log.log(Level.INFO, "Fail the announcement because current producer is not primary (aka leader)");
                        throw new HollowProducer.NotPrimaryMidCycleException("Announcement failed primary (aka leader) check");
                    }
                    HashMap<String, String> announcementMetadata = new HashMap<String, String>();
                    announcementMetadata.put("hollow.metric.announcement", String.valueOf(System.currentTimeMillis()));
                    announcementMetadata.putAll(readState.getStateEngine().getHeaderTags());
                    announcementMetadata.put(ANNOUNCE_TAG_HEAP_FOOTPRINT, String.valueOf(readState.getStateEngine().calcApproxDataSize()));
                    this.announcer.announce(readState.getVersion(), announcementMetadata);
                }
                finally {
                    this.singleProducerEnforcer.unlock();
                }
                status.success();
            }
            catch (Throwable th) {
                status.fail(th);
                throw th;
            }
            finally {
                listeners.fireAnnouncementComplete(status);
            }
        }
    }

    public int getCycleCountWithPrimaryStatus() {
        return this.cycleCountSincePrimaryStatus;
    }

    static class DummyBlobStorageCleaner
    extends HollowProducer.BlobStorageCleaner {
        DummyBlobStorageCleaner() {
        }

        @Override
        public void cleanSnapshots() {
        }

        @Override
        public void cleanReverseDeltas() {
        }

        @Override
        public void cleanDeltas() {
        }
    }

    static final class Artifacts {
        HollowProducer.Blob snapshot = null;
        HollowProducer.Blob delta = null;
        HollowProducer.Blob reverseDelta = null;
        HollowProducer.HeaderBlob header = null;
        boolean cleanupCalled;
        boolean snapshotPublishComplete;

        Artifacts() {
        }

        synchronized void cleanup() {
            this.cleanupCalled = true;
            this.cleanupSnapshot();
            if (this.delta != null) {
                this.delta.cleanup();
                this.delta = null;
            }
            if (this.reverseDelta != null) {
                this.reverseDelta.cleanup();
                this.reverseDelta = null;
            }
            if (this.header != null) {
                this.header.cleanup();
                this.header = null;
            }
        }

        synchronized void markSnapshotPublishComplete() {
            this.snapshotPublishComplete = true;
            this.cleanupSnapshot();
        }

        private void cleanupSnapshot() {
            if (this.cleanupCalled && this.snapshotPublishComplete && this.snapshot != null) {
                this.snapshot.cleanup();
                this.snapshot = null;
            }
        }

        boolean hasDelta() {
            return this.delta != null;
        }

        boolean hasReverseDelta() {
            return this.reverseDelta != null;
        }

        boolean hasHeader() {
            return this.header != null;
        }
    }
}

