/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HollowPerformanceAPI;
import com.netflix.hollow.api.perfapi.Ref;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;

public abstract class HollowTypePerfAPI {
    private final HollowPerformanceAPI api;
    protected final long maskedTypeIdx;

    public HollowTypePerfAPI(String typeName, HollowPerformanceAPI api) {
        int typeIdx = api.types.getIdx(typeName);
        this.maskedTypeIdx = Ref.toTypeMasked(typeIdx);
        this.api = api;
    }

    public long refForOrdinal(int ordinal) {
        return Ref.toRefWithTypeMasked(this.maskedTypeIdx, ordinal);
    }

    public abstract HollowTypeDataAccess typeAccess();

    public HollowPerformanceAPI api() {
        return this.api;
    }

    public int ordinal(long ref) {
        if (!Ref.isRefOfTypeMasked(this.maskedTypeIdx, ref)) {
            String expectedType = this.api.types.getTypeName(Ref.type(this.maskedTypeIdx));
            if (Ref.isNull(ref)) {
                throw new NullPointerException("Reference is null -- expected type " + expectedType);
            }
            String foundType = this.api.types.getTypeName(Ref.type(ref));
            throw new IllegalArgumentException("Wrong reference type -- expected type " + expectedType + " but ref was of type " + foundType);
        }
        return Ref.ordinal(ref);
    }

    public boolean isMissingType() {
        return this.maskedTypeIdx == Ref.toTypeMasked(-1);
    }
}

