/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HollowPerformanceAPI;
import com.netflix.hollow.api.perfapi.HollowTypePerfAPI;
import com.netflix.hollow.api.perfapi.Ref;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.missing.HollowObjectMissingDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public abstract class HollowObjectTypePerfAPI
extends HollowTypePerfAPI {
    protected final HollowObjectTypeDataAccess typeAccess;
    protected final int[] fieldIdx;
    protected final long[] refMaskedTypeIdx;

    public HollowObjectTypePerfAPI(HollowDataAccess dataAccess, String typeName, HollowPerformanceAPI api, String[] fieldNames) {
        super(typeName, api);
        HollowObjectTypeDataAccess typeAccess = (HollowObjectTypeDataAccess)dataAccess.getTypeDataAccess(typeName);
        this.fieldIdx = new int[fieldNames.length];
        this.refMaskedTypeIdx = new long[fieldNames.length];
        if (typeAccess != null) {
            HollowObjectSchema schema = typeAccess.getSchema();
            for (int i = 0; i < fieldNames.length; ++i) {
                this.fieldIdx[i] = schema.getPosition(fieldNames[i]);
                if (this.fieldIdx[i] == -1 || schema.getFieldType(this.fieldIdx[i]) != HollowObjectSchema.FieldType.REFERENCE) continue;
                this.refMaskedTypeIdx[i] = Ref.toTypeMasked(api.types.getIdx(schema.getReferencedType(this.fieldIdx[i])));
            }
        } else {
            Arrays.fill(this.fieldIdx, -1);
            Arrays.fill(this.refMaskedTypeIdx, Ref.toTypeMasked(-1));
        }
        if (typeAccess == null) {
            typeAccess = new HollowObjectMissingDataAccess(dataAccess, typeName);
        }
        this.typeAccess = typeAccess;
    }

    @Override
    public HollowObjectTypeDataAccess typeAccess() {
        return this.typeAccess;
    }
}

