/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.generic;

import com.netflix.hollow.api.objects.HollowObject;
import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.delegate.HollowObjectDelegate;
import com.netflix.hollow.api.objects.delegate.HollowObjectGenericDelegate;
import com.netflix.hollow.api.objects.generic.GenericHollowList;
import com.netflix.hollow.api.objects.generic.GenericHollowMap;
import com.netflix.hollow.api.objects.generic.GenericHollowRecordHelper;
import com.netflix.hollow.api.objects.generic.GenericHollowSet;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.tools.stringifier.HollowRecordStringifier;

public class GenericHollowObject
extends HollowObject {
    public GenericHollowObject(HollowDataAccess dataAccess, String typeName, int ordinal) {
        this((HollowObjectTypeDataAccess)dataAccess.getTypeDataAccess(typeName, ordinal), ordinal);
    }

    public GenericHollowObject(HollowObjectTypeDataAccess dataAccess, int ordinal) {
        this(new HollowObjectGenericDelegate(dataAccess), ordinal);
    }

    public GenericHollowObject(HollowObjectDelegate delegate, int ordinal) {
        super(delegate, ordinal);
    }

    public GenericHollowObject getObject(String fieldName) {
        return (GenericHollowObject)this.getReferencedGenericRecord(fieldName);
    }

    public GenericHollowList getList(String fieldName) {
        return (GenericHollowList)this.getReferencedGenericRecord(fieldName);
    }

    public GenericHollowSet getSet(String fieldName) {
        return (GenericHollowSet)this.getReferencedGenericRecord(fieldName);
    }

    public GenericHollowMap getMap(String fieldName) {
        return (GenericHollowMap)this.getReferencedGenericRecord(fieldName);
    }

    public final HollowRecord getReferencedGenericRecord(String fieldName) {
        int ordinal;
        String referencedType = this.getSchema().getReferencedType(fieldName);
        if (referencedType == null) {
            try {
                HollowObjectSchema hollowObjectSchema = (HollowObjectSchema)this.getTypeDataAccess().getDataAccess().getMissingDataHandler().handleSchema(this.getSchema().getName());
                referencedType = hollowObjectSchema.getReferencedType(fieldName);
                if (referencedType == null) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((ordinal = this.getOrdinal(fieldName)) == -1) {
            return null;
        }
        return GenericHollowRecordHelper.instantiate(this.getTypeDataAccess().getDataAccess(), referencedType, ordinal);
    }

    @Override
    public String toString() {
        return new HollowRecordStringifier().stringify(this);
    }
}

